/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
 
	spfunc.cxx: implementation of the CSPfunction class wrapping S-PLUS object of class "function".
*/

#include "S_y_tab.h"
#include "spchar.h"
#include "spfunc.h"
#include "spcall.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//The default constructor
CSPfunction::CSPfunction()
: CSPlanguage()
{
}
//Copy constructor 
CSPfunction::CSPfunction(const CSPfunction& sObject)
: CSPlanguage()
{
	Attach(&sObject, TRUE);
}
//Construct from a base class object
CSPfunction::CSPfunction(const CSPobject& sObject)
: CSPlanguage()
{	
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a valid S-expression
CSPfunction::CSPfunction(const char* pszExpression)
: CSPlanguage()
{
	Create(pszExpression);
}
//Construct from a valid S object
CSPfunction::CSPfunction(s_object* ps_object, BOOL bTryToFreeOnDetach)
: CSPlanguage()
{
	Attach(ps_object, bTryToFreeOnDetach);
}
//Assigment from the same class
CSPfunction& CSPfunction::operator=(const CSPfunction& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the base class
CSPfunction& CSPfunction::operator=(const CSPobject& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the S object
CSPfunction& CSPfunction::operator=(s_object* ps_object)
{
	Attach(ps_object, FALSE);
	return *this;
}
//The destructor
CSPfunction::~CSPfunction()
{
}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Return TRUE if the object is a valid class
BOOL CSPfunction::IsValid(void) const
{
	if(CSPobject::IsValid()) //skip pass CSPlanguage::IsValid() because it returns FALSE for mode==S_FUN_DEF
		return IS(GetPtr(), s_function_class);
	return FALSE;
}

//Validate the evaluator
void CSPfunction::Validate(void) const
{
	if(!IsValid())
		SCONNECT_ThrowException("Invalid 'function' object\n");
}

void CSPfunction::Attach(s_object *ps_object, BOOL bTryToFreeOnDetach)
{
	BaseCoerceAttach(ps_object, MAKE_CLASS("function"), bTryToFreeOnDetach);
}

// access to elements 
CSPcharacter CSPfunction::GetArgNames(BOOL bValidate) const
{
	if(bValidate)
		Validate();
	long nLen = GetLength(FALSE);
	if( nLen < 1L)
		return CSPcharacter();
	else
	{
		CSPcharacter schNames( ::get_names(GetPtr()) );
		if(schNames.IsValid() && schNames.GetLength() > 0L)
			schNames.SetLength(schNames.GetLength()-1); //drops the last one which is the body's name 
		return schNames;
	}
}

CSPbrace CSPfunction::GetBody(BOOL bValidate) const
{
	s_object* ps_value=NULL;
	if(bValidate)
		Validate();
	long nLen = GetLength(FALSE);
	if( nLen < 1L)
	{
		//Impossible: a function without a body?
		SCONNECT_ThrowException("Bad \"function\" object");			
	}
	else
	{
		ps_value = LIST_POINTER(GetPtr())[nLen-1];

		if(ps_value == S_MODE_NULL)
			SCONNECT_ThrowException("Function body is NULL");	
		else if(!S_LANGUAGE_TYPE(ps_value->mode))		
			SCONNECT_ThrowException("Class of the function body is not \"language\" ");	
	}
	return CSPbrace(ps_value, TRUE);
}

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
//Eval the function passing no argument in the current evaluation frame
//Evaluate the S-function call with its 1st, 2nd, ... arguments specified by the input parameter CSPlist

CSPobject CSPfunction::Eval(void) const
{
	Validate();

	s_object* ps_value = NULL;
	try
	{ 
		CSPevaluator sEvaluator; //If frame 1 does not exist, open it.
		sEvaluator.PushFrame();
		ps_value = sEvaluator.Eval(GetBody());
		ps_value = sEvaluator.PopFrame(ps_value);
	}
	catch(...)
	{
		SCONNECT_ThrowException("Failed to evaluate call");
	}
	return CSPobject(ps_value, TRUE);
}

CSPobject CSPfunction::Eval(const CSPlist& slistArgs) const
{
	CSPcall sfunCall(*this);
	sfunCall.SetArgs(slistArgs);
	return sfunCall.Eval();
}              

//Evaluate the S-function call (method) with its 1st, 2nd, ... arguments specified by the input parameters
//Argument names are ignor. 
CSPobject CSPfunction::Eval(s_object*  ps_1, s_object*  ps_2, s_object*  ps_3, s_object*  ps_4, s_object*  ps_5,
                        s_object*  ps_6, s_object*  ps_7, s_object*  ps_8, s_object*  ps_9, s_object* ps_10,
                        s_object* ps_11, s_object* ps_12, s_object* ps_13, s_object* ps_14, s_object* ps_15,
                        s_object* ps_16, s_object* ps_17, s_object* ps_18, s_object* ps_19, s_object* ps_20,
                        s_object* ps_21, s_object* ps_22, s_object* ps_23, s_object* ps_24, s_object* ps_25,
                        s_object* ps_26, s_object* ps_27, s_object* ps_28, s_object* ps_29, s_object* ps_30,
												s_object* ps_31) const
{
	CSPevaluator sEvaluator;
	Validate();
	CSPcall sfunCall(*this);
	s_object* ps_value = sfunCall.Eval( ps_1,   ps_2,   ps_3,   ps_4,   ps_5,
                ps_6,   ps_7,   ps_8,   ps_9,  ps_10,
                ps_11, ps_12,  ps_13,  ps_14,  ps_15,
                ps_16, ps_17,  ps_18,  ps_19,  ps_20,
                ps_21, ps_22,  ps_23,  ps_24,  ps_25,
                ps_26, ps_27,  ps_28,  ps_29,  ps_30,
								ps_31);
	sEvaluator.TryToFree(sfunCall.Detach(), FALSE);
	return CSPobject(ps_value, TRUE);
}
