/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spvariant.h
*/

#ifndef __SCONNECT_SPVARIANT_H_INCLUDED__
#define __SCONNECT_SPVARIANT_H_INCLUDED__

#ifdef WIN32
#include "spdefs.h"  

// special VT_ and VTS_ values
#define VT_MFCVALUE         0xFFF       // special value for DISPID_VALUE
#define VT_MFCBYREF         0x40        // indicates VT_BYREF type
#define VT_MFCMARKER        0xFF        // delimits named parameters (INTERNAL USE)
#define VT_BSTRA            14
#define VT_BSTRT            VT_BSTRA

SCONNECT_DLLAPI( BOOL ) IsValidVariantType( const VARTYPE varType );
SCONNECT_DLLAPI( BOOL ) IsEmptyOrNullVariantType( const VARTYPE varType );
SCONNECT_DLLAPI( LPVARIANT ) ConvertByRefVariantToVariant( const VARIANT &vaResult );
SCONNECT_DLLAPI( VARTYPE ) GetActualDataTypeFromVariant( const VARIANT &vaResult );
SCONNECT_DLLAPI( int ) GetVariantDataSize( const VARTYPE varType );

SCONNECT_DLLAPI( int ) GetSafeArrayElementNumber( SAFEARRAY * pSafeArray );
SCONNECT_DLLAPI( SAFEARRAY* ) GetSafeArrayFromVariant( const LPVARIANT lpVariant );

SCONNECT_DLLAPI( BOOL ) ConvertVoidPtrToVariant(
	LPVARIANT lpVariant,
	const void *vpData,
	const VARTYPE varType,
	const int cbDataSize,
	BOOL bMissingsAsErrors = TRUE );

SCONNECT_DLLAPI( BOOL ) ConvertVariantToVoidPtr(
	void **ppvRet,
	const VARIANT &vaResult );

SCONNECT_DLLAPI( BOOL ) ConvertVariantArrayToByteArray(
	char **ppByteArray,
	const VARIANT *pVariantArray,
	const long variantArrayLength );

SCONNECT_DLLAPI( BOOL ) ConvertByteArrayToVariantArray(
	LPVARIANT pVariantArray,
	va_list pByteArray,
	const long variantArrayLength,
	int *pDataSizes,
	BOOL bMissingsAsErrors = TRUE );

SCONNECT_DLLAPI( HRESULT ) TxCopyVariant( LPVARIANT lpDestVariant, const LPVARIANT lpSourceVariant );
SCONNECT_DLLAPI( HRESULT ) TxDeleteVariant( VARIANT **ppVariant, BOOL bDeleteVariant );

SCONNECT_DLLAPI( LPVARIANT ) ConvertSafeArrayToVariantSafeArray( LPVARIANT lpInVariant );

SCONNECT_DLLAPI( BOOL ) IsVariant2D( const LPVARIANT lpVariant );

#endif // WIN32

#endif // __SCONNECT_SPVARIANT_H_INCLUDED__
