/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributeEnum;
import com.netscape.jndi.ldap.AttributeIDEnum;
import java.util.Enumeration;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPModificationSet;

class AttributesImpl
implements Attributes {
    LDAPAttributeSet m_attrSet;
    static String[] m_binaryAttrs = new String[]{"photo", "userpassword", "jpegphoto", "audio", "thumbnailphoto", "thumbnaillogo", "usercertificate", "cacertificate", "certificaterevocationlist", "authorityrevocationlist", "crosscertificatepair", "personalsignature", "x500uniqueidentifier", "javaserializeddata"};
    static String[] m_userBinaryAttrs = null;

    public AttributesImpl(LDAPAttributeSet attrSet, String[] userBinaryAttrs) {
        this.m_attrSet = attrSet;
        m_userBinaryAttrs = userBinaryAttrs;
    }

    public Object clone() {
        return new AttributesImpl((LDAPAttributeSet)this.m_attrSet.clone(), m_userBinaryAttrs);
    }

    public Attribute get(String attrID) {
        LDAPAttribute attr = this.m_attrSet.getAttribute(attrID);
        return attr == null ? null : AttributesImpl.ldapAttrToJndiAttr(attr);
    }

    public NamingEnumeration getAll() {
        return new AttributeEnum(this.m_attrSet.getAttributes());
    }

    public NamingEnumeration getIDs() {
        return new AttributeIDEnum(this.m_attrSet.getAttributes());
    }

    public boolean isCaseIgnored() {
        return false;
    }

    public Attribute put(String attrID, Object val) {
        LDAPAttribute attr = this.m_attrSet.getAttribute(attrID);
        if (val == null) {
            this.m_attrSet.add(new LDAPAttribute(attrID));
        } else if (val instanceof byte[]) {
            this.m_attrSet.add(new LDAPAttribute(attrID, (byte[])val));
        } else {
            this.m_attrSet.add(new LDAPAttribute(attrID, val.toString()));
        }
        return attr == null ? null : AttributesImpl.ldapAttrToJndiAttr(attr);
    }

    public Attribute put(Attribute jndiAttr) {
        try {
            LDAPAttribute oldAttr = this.m_attrSet.getAttribute(jndiAttr.getID());
            this.m_attrSet.add(AttributesImpl.jndiAttrToLdapAttr(jndiAttr));
            return oldAttr == null ? null : AttributesImpl.ldapAttrToJndiAttr(oldAttr);
        }
        catch (NamingException e) {
            System.err.println("Error in AttributesImpl.put(): " + e.toString());
            e.printStackTrace(System.err);
            return null;
        }
    }

    public Attribute remove(String attrID) {
        Attribute attr = this.get(attrID);
        this.m_attrSet.remove(attrID);
        return attr;
    }

    public int size() {
        return this.m_attrSet.size();
    }

    static boolean isBinaryAttribute(String attrID) {
        if (attrID.indexOf(";binary") >= 0) {
            return true;
        }
        attrID = attrID.toLowerCase();
        int i = 0;
        while (i < m_binaryAttrs.length) {
            if (m_binaryAttrs[i].equals(attrID)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (m_userBinaryAttrs != null && i < m_userBinaryAttrs.length) {
            if (m_userBinaryAttrs[i].equals(attrID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static LDAPAttributeSet jndiAttrsToLdapAttrSet(Attributes jndiAttrs) throws NamingException {
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        NamingEnumeration<? extends Attribute> namingEnumeration = jndiAttrs.getAll();
        while (namingEnumeration.hasMoreElements()) {
            attrs.add(AttributesImpl.jndiAttrToLdapAttr((Attribute)namingEnumeration.nextElement()));
        }
        return attrs;
    }

    static LDAPAttribute jndiAttrToLdapAttr(Attribute jndiAttr) throws NamingException {
        LDAPAttribute attr = new LDAPAttribute(jndiAttr.getID());
        NamingEnumeration<?> vals = jndiAttr.getAll();
        while (vals.hasMoreElements()) {
            Object val = vals.nextElement();
            if (val == null) continue;
            if (val instanceof byte[]) {
                attr.addValue((byte[])val);
                continue;
            }
            attr.addValue(val.toString());
        }
        return attr;
    }

    static Attribute ldapAttrToJndiAttr(LDAPAttribute attr) {
        BasicAttribute jndiAttr = new BasicAttribute(attr.getName());
        Enumeration enumVals = null;
        enumVals = AttributesImpl.isBinaryAttribute(attr.getName()) ? attr.getByteValues() : attr.getStringValues();
        if (enumVals != null) {
            while (enumVals.hasMoreElements()) {
                jndiAttr.add(enumVals.nextElement());
            }
        }
        return jndiAttr;
    }

    static LDAPModificationSet jndiModsToLdapModSet(ModificationItem[] jndiMods) throws NamingException {
        LDAPModificationSet mods = new LDAPModificationSet();
        int i = 0;
        while (i < jndiMods.length) {
            int modop = jndiMods[i].getModificationOp();
            LDAPAttribute attr = AttributesImpl.jndiAttrToLdapAttr(jndiMods[i].getAttribute());
            if (modop == 1) {
                mods.add(0, attr);
            } else if (modop == 2) {
                mods.add(2, attr);
            } else if (modop == 3) {
                mods.add(1, attr);
            }
            ++i;
        }
        return mods;
    }

    static LDAPModificationSet jndiAttrsToLdapModSet(int modop, Attributes jndiAttrs) throws NamingException {
        LDAPModificationSet mods = new LDAPModificationSet();
        NamingEnumeration<? extends Attribute> attrEnum = jndiAttrs.getAll();
        while (attrEnum.hasMore()) {
            LDAPAttribute attr = AttributesImpl.jndiAttrToLdapAttr(attrEnum.next());
            if (modop == 1) {
                mods.add(0, attr);
                continue;
            }
            if (modop == 2) {
                mods.add(2, attr);
                continue;
            }
            if (modop == 3) {
                mods.add(1, attr);
                continue;
            }
            throw new IllegalArgumentException("Illegal Attribute Modification Operation");
        }
        return mods;
    }
}

