/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.common.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeBase64Decoder;
import netscape.ldap.util.MimeBase64Encoder;

public class ObjectMapper {
    static final String OC_JAVAOBJECT = "javaObject";
    static final String OC_SERIALOBJ = "javaSerializedObject";
    static final String OC_MARSHALOBJ = "javaMarshalledObject";
    static final String OC_REFERENCE = "javaNamingReference";
    static final String OC_CONTAINER = "javaContainer";
    static final String AT_CLASSNAME = "javaClassName";
    static final String AT_CLASSNAMES = "javaClassNames";
    static final String AT_DESCRIPTION = "description";
    static final String AT_JAVADOC = "javaDoc";
    static final String AT_CODEBASE = "javaCodeBase";
    static final String AT_SERIALDATA = "javaSerializedData";
    static final String AT_REFADDR = "javaReferenceAddress";
    static final String AT_OBJFACTORY = "javaFactory";
    static final String DEFAULT_OBJCLASS = "javax.naming.directory.DirContext";

    static Object entryToObject(LDAPEntry entry, LdapContextImpl ctx) throws NamingException {
        Object obj = ObjectMapper.entryToObject(entry);
        if (obj == null) {
            obj = new LdapContextImpl(entry.getDN(), ctx);
        }
        try {
            String relName = LdapNameParser.getRelativeName(ctx.m_ctxDN, entry.getDN());
            Name nameObj = LdapNameParser.getParser().parse(relName);
            AttributesImpl attrs = new AttributesImpl(entry.getAttributeSet(), ctx.m_ctxEnv.getUserDefBinaryAttrs());
            obj = DirectoryManager.getObjectInstance(obj, nameObj, ctx, ctx.getEnvironment(), attrs);
        }
        catch (Exception ex) {
            if (ex instanceof NamingException) {
                throw (NamingException)ex;
            }
            NamingException nameEx = new NamingException("NamingManager.getObjectInstance failed");
            nameEx.setRootCause(ex);
            throw nameEx;
        }
        return obj;
    }

    static Object entryToObject(LDAPEntry entry) throws NamingException {
        try {
            LDAPAttributeSet attrs = entry.getAttributeSet();
            LDAPAttribute attr = null;
            attr = attrs.getAttribute(AT_SERIALDATA);
            if (attr != null) {
                byte[] serdata = (byte[])attr.getByteValues().nextElement();
                return ObjectMapper.deserializeObject(serdata);
            }
            attr = attrs.getAttribute(AT_REFADDR);
            if (attr != null) {
                return ObjectMapper.decodeRefObj(attrs);
            }
            return null;
        }
        catch (Exception ex) {
            if (ex instanceof NamingException) {
                throw (NamingException)ex;
            }
            NamingException nameEx = new NamingException("NamingManager.getStateToStore failed");
            nameEx.setRootCause(ex);
            throw nameEx;
        }
    }

    static String getClassName(LDAPEntry entry) {
        LDAPAttributeSet attrs = entry.getAttributeSet();
        LDAPAttribute attrClass = attrs.getAttribute(AT_CLASSNAME);
        if (attrClass != null) {
            String className = (String)attrClass.getStringValues().nextElement();
            return className;
        }
        return DEFAULT_OBJCLASS;
    }

    static LDAPAttributeSet objectToAttrSet(Object obj, String name, LdapContextImpl ctx, Attributes attrs) throws NamingException {
        Attribute objectclass;
        try {
            Name nameObj = LdapNameParser.getParser().parse(name);
            DirStateFactory.Result stb = DirectoryManager.getStateToBind(obj, nameObj, ctx, ctx.getEnvironment(), attrs);
            obj = stb.getObject();
            attrs = stb.getAttributes();
        }
        catch (Exception ex) {
            if (ex instanceof NamingException) {
                throw (NamingException)ex;
            }
            NamingException nameEx = new NamingException("NamingManager.getStateToStore failed");
            nameEx.setRootCause(ex);
            throw nameEx;
        }
        if (obj == null) {
            return AttributesImpl.jndiAttrsToLdapAttrSet(attrs);
        }
        if (attrs == null) {
            attrs = new BasicAttributes(true);
        }
        if ((objectclass = attrs.get("objectClass")) == null) {
            objectclass = attrs.get("objectclass");
        }
        if (objectclass == null) {
            objectclass = new BasicAttribute("objectClass", "top");
            objectclass.add(OC_CONTAINER);
            attrs.put(objectclass);
        }
        objectclass.add(OC_JAVAOBJECT);
        if (obj instanceof Reference) {
            objectclass.add(OC_REFERENCE);
            char delimChar = ctx.m_ctxEnv.getRefSeparator();
            attrs = ObjectMapper.encodeRefObj(delimChar, (Reference)obj, attrs);
        } else if (obj instanceof Referenceable) {
            objectclass.add(OC_REFERENCE);
            char delimChar = ctx.m_ctxEnv.getRefSeparator();
            attrs = ObjectMapper.encodeRefObj(delimChar, ((Referenceable)obj).getReference(), attrs);
        } else if (obj instanceof Serializable) {
            if (!objectclass.contains(OC_MARSHALOBJ) && !objectclass.contains(OC_MARSHALOBJ.toLowerCase())) {
                objectclass.add(OC_SERIALOBJ);
            }
            attrs = ObjectMapper.encodeSerialObj((Serializable)obj, attrs);
        } else if (obj instanceof DirContext) {
            attrs = ObjectMapper.encodeDirCtxObj((DirContext)obj, attrs);
        } else {
            throw new NamingException("Can not bind object of type " + obj.getClass().getName());
        }
        return AttributesImpl.jndiAttrsToLdapAttrSet(attrs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserializeObject(byte[] byteBuf) throws NamingException {
        ByteArrayInputStream bis = null;
        ObjectInputStream objis = null;
        try {
            try {
                bis = new ByteArrayInputStream(byteBuf);
                objis = new ObjectInputStream(bis);
                Object object = objis.readObject();
                Object var5_4 = null;
                try {
                    if (objis != null) {
                        objis.close();
                    }
                    if (bis == null) return object;
                    bis.close();
                    return object;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return object;
            }
            catch (Exception ex) {
                NamingException nameEx = new NamingException("Failed to deserialize object");
                nameEx.setRootCause(ex);
                throw nameEx;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (objis != null) {
                objis.close();
            }
            if (bis == null) throw throwable;
            bis.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] serializeObject(Object obj) throws NamingException {
        ByteArrayOutputStream bos = null;
        ObjectOutputStream objos = null;
        try {
            try {
                bos = new ByteArrayOutputStream();
                objos = new ObjectOutputStream(bos);
                objos.writeObject(obj);
                objos.flush();
                byte[] byArray = bos.toByteArray();
                Object var5_4 = null;
                try {
                    if (objos != null) {
                        objos.close();
                    }
                    if (bos == null) return byArray;
                    bos.close();
                    return byArray;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return byArray;
            }
            catch (Exception ex) {
                NamingException nameEx = new NamingException("Failed to serialize object");
                nameEx.setRootCause(ex);
                throw nameEx;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (objos != null) {
                objos.close();
            }
            if (bos == null) throw throwable;
            bos.close();
            throw throwable;
        }
    }

    private static Reference decodeRefObj(LDAPAttributeSet attrs) throws NamingException {
        try {
            LDAPAttribute attr = null;
            String className = null;
            String factory = null;
            String factoryLoc = null;
            attr = attrs.getAttribute(AT_CLASSNAME);
            if (attr == null) {
                throw new NamingException("Bad Reference encoding, no attribute javaClassName");
            }
            className = (String)attr.getStringValues().nextElement();
            attr = attrs.getAttribute(AT_OBJFACTORY);
            if (attr != null) {
                factory = (String)attr.getStringValues().nextElement();
            }
            if ((attr = attrs.getAttribute(AT_CODEBASE)) != null) {
                factoryLoc = (String)attr.getStringValues().nextElement();
            }
            Reference ref = new Reference(className, factory, factoryLoc);
            attr = attrs.getAttribute(AT_REFADDR);
            if (attr == null) {
                return ref;
            }
            Enumeration e = attr.getStringValues();
            while (e.hasMoreElements()) {
                ObjectMapper.decodeRefAddr((String)e.nextElement(), ref);
            }
            return ref;
        }
        catch (Exception ex) {
            if (ex instanceof NamingException) {
                throw (NamingException)ex;
            }
            NamingException nameEx = new NamingException("NamingManager.getStateToStore failed");
            nameEx.setRootCause(ex);
            throw nameEx;
        }
    }

    private static void decodeRefAddr(String enc, Reference ref) throws NamingException {
        if (enc.length() == 0) {
            throw new NamingException("Bad Reference encoding, empty refAddr");
        }
        String delimChar = enc.substring(0, 1);
        StringTokenizer tok = new StringTokenizer(enc, delimChar);
        int tokCount = tok.countTokens();
        if (tokCount != 3 && tokCount != 4) {
            Debug.println(3, "enc=" + enc + " delimChar=" + delimChar + " tokCount=" + tokCount);
            throw new NamingException("Bad Reference encoding");
        }
        String type = null;
        int posn = -1;
        int i = 0;
        while (i < tokCount) {
            String s = tok.nextToken();
            if (i == 0) {
                try {
                    posn = Integer.parseInt(s);
                }
                catch (Exception e) {
                    throw new NamingException("Bad Reference encoding, refAddr position not an initger");
                }
            } else if (i == 1) {
                if (s.length() == 0) {
                    throw new NamingException("Bad Reference encoding, empty refAddr type");
                }
                type = s;
            } else if (i == 2) {
                if (s.length() == 0 && tokCount != 4) {
                    throw new NamingException("Bad Reference encoding, empty refAddr string value");
                }
                ref.add(posn, new StringRefAddr(type, s));
            } else {
                if (s.length() == 0) {
                    throw new NamingException("Bad Reference encoding, empty refAddr binary value");
                }
                MimeBase64Decoder base64Dec = new MimeBase64Decoder();
                ByteBuf in = new ByteBuf(s);
                ByteBuf out = new ByteBuf();
                base64Dec.translate(in, out);
                base64Dec.eof(out);
                ref.add(posn, (RefAddr)ObjectMapper.deserializeObject(out.toBytes()));
            }
            ++i;
        }
    }

    private static Attributes encodeRefObj(char delimChar, Reference ref, Attributes attrs) throws NamingException {
        if (ref.getClassName() != null) {
            attrs.put(new BasicAttribute(AT_CLASSNAME, ref.getClassName()));
        }
        if (ref.getFactoryClassName() != null) {
            attrs.put(new BasicAttribute(AT_OBJFACTORY, ref.getFactoryClassName()));
        }
        if (ref.getFactoryClassLocation() != null) {
            attrs.put(new BasicAttribute(AT_CODEBASE, ref.getFactoryClassLocation()));
        }
        if (ref.size() > 0) {
            BasicAttribute refAttr = new BasicAttribute(AT_REFADDR);
            int i = 0;
            while (i < ref.size()) {
                refAttr.add(ObjectMapper.encodeRefAddr(delimChar, i, ref.get(i)));
                ++i;
            }
            attrs.put(refAttr);
        }
        return attrs;
    }

    private static String encodeRefAddr(char delimChar, int idx, RefAddr refAddr) throws NamingException {
        if (refAddr instanceof StringRefAddr) {
            String content = (String)refAddr.getContent();
            if (content != null && content.length() > 0 && content.charAt(0) == delimChar) {
                throw new NamingException("Can not encode StringRefAddr, value starts with the delimiter character " + delimChar);
            }
            return String.valueOf(delimChar + idx + delimChar) + refAddr.getType() + delimChar + content;
        }
        byte[] serialRefAddr = ObjectMapper.serializeObject(refAddr);
        MimeBase64Encoder base64 = new MimeBase64Encoder();
        ByteBuf in = new ByteBuf();
        ByteBuf out = new ByteBuf();
        in.append(serialRefAddr);
        base64.translate(in, out);
        base64.eof(out);
        return String.valueOf(delimChar + idx + delimChar) + refAddr.getType() + delimChar + delimChar + out.toString();
    }

    static Attributes encodeSerialObj(Serializable obj, Attributes attrs) throws NamingException {
        if (attrs.get(AT_CLASSNAME) == null) {
            attrs.put(new BasicAttribute(AT_CLASSNAME, obj.getClass().getName()));
        }
        attrs.put(new BasicAttribute(AT_SERIALDATA, ObjectMapper.serializeObject(obj)));
        return attrs;
    }

    static Attributes encodeDirCtxObj(DirContext obj, Attributes attrs) throws NamingException {
        Attributes ctxAttrs = obj.getAttributes("");
        NamingEnumeration<? extends Attribute> namingEnumeration = ctxAttrs.getAll();
        while (namingEnumeration.hasMore()) {
            attrs.put(namingEnumeration.next());
        }
        return attrs;
    }

    public static void main(String[] args) {
        byte[] serialRefAddr = new byte[]{97, 48, 65, 16, 127, -86};
        MimeBase64Encoder base64 = new MimeBase64Encoder();
        MimeBase64Decoder base64Dec = new MimeBase64Decoder();
        ByteBuf in = new ByteBuf();
        ByteBuf out = new ByteBuf();
        in.append(serialRefAddr);
        base64.translate(in, out);
        base64.eof(out);
        System.err.println("in=" + in);
        System.err.println("out=" + out);
        in = new ByteBuf(out.toString());
        out = new ByteBuf();
        base64Dec.translate(in, out);
        base64Dec.eof(out);
        System.err.println("in=" + in);
        System.err.println("out=" + out);
    }
}

