/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.BaseSearchEnum;
import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.SearchResultWithControls;
import com.netscape.jndi.ldap.controls.NetscapeControlFactory;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;

class SearchResultEnum
extends BaseSearchEnum {
    boolean m_returnObjs;
    String[] m_userBinaryAttrs;

    public SearchResultEnum(LDAPSearchResults res, boolean returnObjs, LdapContextImpl ctx) throws NamingException {
        super(res, ctx);
        this.m_returnObjs = returnObjs;
        this.m_userBinaryAttrs = ctx.m_ctxEnv.getUserDefBinaryAttrs();
    }

    public Object next() throws NamingException {
        LDAPEntry entry = this.nextLDAPEntry();
        String name = LdapNameParser.getRelativeName(this.m_ctxName, entry.getDN());
        Object obj = this.m_returnObjs ? ObjectMapper.entryToObject(entry, this.m_ctx) : null;
        AttributesImpl attrs = new AttributesImpl(entry.getAttributeSet(), this.m_userBinaryAttrs);
        LDAPControl[] ldapCtls = this.m_res.getResponseControls();
        if (ldapCtls != null) {
            Control[] ctls = new Control[ldapCtls.length];
            int i = 0;
            while (i < ldapCtls.length) {
                ctls[i] = NetscapeControlFactory.getControlInstance(ldapCtls[i]);
                if (ctls[i] == null) {
                    throw new NamingException("Unsupported control " + ldapCtls[i].getID());
                }
                ++i;
            }
            SearchResultWithControls searchRes = new SearchResultWithControls(name, obj, attrs);
            searchRes.setControls(ctls);
            return searchRes;
        }
        return new SearchResult(name, obj, attrs);
    }
}

