/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.common;

import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;

public class ExceptionMapper {
    public static NamingException getNamingException(Exception origException) {
        if (origException instanceof NamingException) {
            return (NamingException)origException;
        }
        if (origException instanceof LDAPReferralException) {
            return new NamingException("Provider internal error, LDAPReferralException not captured");
        }
        if (origException instanceof LDAPException) {
            LDAPException ldapException = (LDAPException)origException;
            int resCode = ldapException.getLDAPResultCode();
            if (resCode == 1) {
                NamingException nameEx = new NamingException(ldapException.toString());
                nameEx.setRootCause(ldapException);
                return nameEx;
            }
            if (resCode == 2) {
                return new CommunicationException(ldapException.toString());
            }
            if (resCode == 3) {
                return new TimeLimitExceededException(ldapException.toString());
            }
            if (resCode == 4) {
                return new SizeLimitExceededException(ldapException.toString());
            }
            if (resCode == 5) {
                NamingException nameEx = new NamingException(ldapException.toString());
                nameEx.setRootCause(ldapException);
                return nameEx;
            }
            if (resCode == 6) {
                NamingException nameEx = new NamingException(ldapException.toString());
                nameEx.setRootCause(ldapException);
                return nameEx;
            }
            if (resCode == 7) {
                return new AuthenticationNotSupportedException(ldapException.toString());
            }
            if (resCode == 8) {
                return new AuthenticationNotSupportedException(ldapException.toString());
            }
            if (resCode == 9) {
                return new PartialResultException(ldapException.toString());
            }
            if (resCode == 10) {
                LDAPReferralException referralEx = (LDAPReferralException)ldapException;
            } else {
                if (resCode == 11) {
                    return new LimitExceededException(ldapException.toString());
                }
                if (resCode == 12) {
                    return new OperationNotSupportedException(ldapException.toString());
                }
                if (resCode == 13) {
                    return new AuthenticationNotSupportedException("A secure connection is required for this operation");
                }
                if (resCode == 14) {
                    NamingException nameEx = new NamingException(ldapException.toString());
                    nameEx.setRootCause(ldapException);
                    return nameEx;
                }
                if (resCode == 16) {
                    return new NoSuchAttributeException(ldapException.toString());
                }
                if (resCode == 17) {
                    return new InvalidAttributeIdentifierException(ldapException.toString());
                }
                if (resCode == 18) {
                    return new InvalidSearchFilterException(ldapException.toString());
                }
                if (resCode == 19) {
                    return new InvalidSearchControlsException(ldapException.toString());
                }
                if (resCode == 20) {
                    return new AttributeInUseException(ldapException.toString());
                }
                if (resCode == 21) {
                    return new InvalidAttributeValueException(ldapException.toString());
                }
                if (resCode == 32) {
                    return new NameNotFoundException(ldapException.toString());
                }
                if (resCode == 33) {
                    return new NamingException(ldapException.toString());
                }
                if (resCode == 34) {
                    return new InvalidNameException(ldapException.toString());
                }
                if (resCode == 35) {
                    NamingException nameEx = new NamingException(ldapException.toString());
                    nameEx.setRootCause(ldapException);
                    return nameEx;
                }
                if (resCode == 36) {
                    NamingException nameEx = new NamingException(ldapException.toString());
                    nameEx.setRootCause(ldapException);
                    return nameEx;
                }
                if (resCode == 48) {
                    return new AuthenticationException(ldapException.toString());
                }
                if (resCode == 49) {
                    return new AuthenticationException(ldapException.toString());
                }
                if (resCode == 50) {
                    return new NoPermissionException(ldapException.toString());
                }
                if (resCode == 51) {
                    return new ServiceUnavailableException(ldapException.toString());
                }
                if (resCode == 52) {
                    return new ServiceUnavailableException(ldapException.toString());
                }
                if (resCode == 53) {
                    return new OperationNotSupportedException(ldapException.toString());
                }
                if (resCode == 54) {
                    NamingException nameEx = new NamingException(ldapException.toString());
                    nameEx.setRootCause(ldapException);
                    return nameEx;
                }
                if (resCode == 64) {
                    return new InvalidNameException(ldapException.toString());
                }
                if (resCode == 65) {
                    return new SchemaViolationException(ldapException.toString());
                }
                if (resCode == 66) {
                    return new ContextNotEmptyException(ldapException.toString());
                }
                if (resCode == 67) {
                    return new SchemaViolationException(ldapException.toString());
                }
                if (resCode == 68) {
                    return new NameAlreadyBoundException(ldapException.toString());
                }
                if (resCode == 69) {
                    return new SchemaViolationException(ldapException.toString());
                }
                if (resCode == 81) {
                    return new CommunicationException(ldapException.toString());
                }
                if (resCode == 91) {
                    return new CommunicationException(ldapException.toString());
                }
                NamingException nameEx = new NamingException(ldapException.toString());
                nameEx.setRootCause(ldapException);
                return nameEx;
            }
        }
        NamingException nameEx = new NamingException(origException.toString());
        nameEx.setRootCause(origException);
        return nameEx;
    }
}

