/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.controls;

import com.netscape.jndi.ldap.common.ExceptionMapper;
import com.netscape.jndi.ldap.controls.LdapEntryChangeControl;
import com.netscape.jndi.ldap.controls.LdapPasswordExpiredControl;
import com.netscape.jndi.ldap.controls.LdapPasswordExpiringControl;
import com.netscape.jndi.ldap.controls.LdapSortResponseControl;
import com.netscape.jndi.ldap.controls.LdapVirtualListResponseControl;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ControlFactory;
import netscape.ldap.LDAPControl;

public class NetscapeControlFactory
extends ControlFactory {
    static final String REQ_SORT = "1.2.840.113556.1.4.473";
    static final String RSP_SORT = "1.2.840.113556.1.4.474";
    static final String REQ_MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    static final String REQ_PERSISTENTSEARCH = "2.16.840.1.113730.3.4.3";
    static final String RSP_PWDEXPIRED = "2.16.840.1.113730.3.4.4";
    static final String RSP_PWDEXPIRING = "2.16.840.1.113730.3.4.5";
    static final String RSP_ENTRYCHANGED = "2.16.840.1.113730.3.4.7";
    static final String REQ_VIRTUALLIST = "2.16.840.1.113730.3.4.9";
    static final String RSP_VIRTUALLIST = "2.16.840.1.113730.3.4.10";
    static final String REQ_PROXIEDAUTH = "2.16.840.1.113730.3.4.12";

    public Control getControlInstance(Control ctrl) throws NamingException {
        if (ctrl == null) {
            return null;
        }
        LDAPControl rawCtrl = new LDAPControl(ctrl.getID(), ctrl.isCritical(), ctrl.getEncodedValue());
        return NetscapeControlFactory.getControlInstance(rawCtrl);
    }

    public static Control getControlInstance(LDAPControl rawCtrl) throws NamingException {
        if (rawCtrl == null) {
            return null;
        }
        try {
            String ctrlID = rawCtrl.getID();
            if (ctrlID.equals(RSP_ENTRYCHANGED)) {
                return new LdapEntryChangeControl(rawCtrl.isCritical(), rawCtrl.getValue());
            }
            if (ctrlID.equals(RSP_PWDEXPIRED)) {
                return new LdapPasswordExpiredControl(rawCtrl.isCritical(), rawCtrl.getValue());
            }
            if (ctrlID.equals(RSP_PWDEXPIRING)) {
                return new LdapPasswordExpiringControl(rawCtrl.isCritical(), rawCtrl.getValue());
            }
            if (ctrlID.equals(RSP_SORT)) {
                return new LdapSortResponseControl(rawCtrl.isCritical(), rawCtrl.getValue());
            }
            if (ctrlID.equals(RSP_VIRTUALLIST)) {
                return new LdapVirtualListResponseControl(rawCtrl.isCritical(), rawCtrl.getValue());
            }
            return null;
        }
        catch (Exception ex) {
            throw ExceptionMapper.getNamingException(ex);
        }
    }
}

