/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaManager;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import netscape.ldap.LDAPModificationSet;

public class SchemaElement
extends SchemaDirContext {
    SchemaManager m_schemaMgr;
    static final String NUMERICOID = "NUMERICOID";
    static final String NAME = "NAME";
    static final String DESC = "DESC";
    static final String SYNTAX = "SYNTAX";
    static final String SUP = "SUP";
    static final String MUST = "MUST";
    static final String MAY = "MAY";
    static final String SINGLEVALUE = "SINGLE-VALUE";
    static final String OBSOLETE = "OBSOLETE";
    static final String EQUALITY = "EQUALITY";
    static final String ORDERING = "ORDERING";
    static final String SUBSTRING = "SUBSTRING";
    static final String COLLECTIVE = "COLLECTIVE";
    static final String NOUSERMOD = "NO-USER-MODIFICATION";
    static final String USAGE = "USAGE";
    static final String ABSTRACT = "ABSTRACT";
    static final String STRUCTURAL = "STRUCTURAL";
    static final String AUXILIARY = "AUXILIARY";
    static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";

    SchemaElement(SchemaManager schemaMgr) {
        this.m_schemaMgr = schemaMgr;
    }

    static int syntaxStringToInt(String syntax) throws NamingException {
        if (syntax.equals(cisString)) {
            return 1;
        }
        if (syntax.equals(cesString)) {
            return 4;
        }
        if (syntax.equals(telephoneString)) {
            return 3;
        }
        if (syntax.equals(intString)) {
            return 6;
        }
        if (syntax.equals(dnString)) {
            return 5;
        }
        if (syntax.equals(binaryString)) {
            return 2;
        }
        throw new InvalidAttributeValueException(syntax);
    }

    static String syntaxIntToString(int syntax) throws NamingException {
        if (syntax == 1) {
            return cisString;
        }
        if (syntax == 4) {
            return cesString;
        }
        if (syntax == 3) {
            return telephoneString;
        }
        if (syntax == 6) {
            return intString;
        }
        if (syntax == 5) {
            return dnString;
        }
        if (syntax == 2) {
            return binaryString;
        }
        throw new InvalidAttributeValueException("Interanal error, unexpected syntax value " + syntax);
    }

    static String[] vectorToStringAry(Vector v) {
        String[] ary = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            ary[i] = (String)v.elementAt(i);
            ++i;
        }
        return ary;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration(this);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration(this);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration(this);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration(this);
    }

    void modifySchemaElementAttrs(Attributes attrs, ModificationItem[] jndiMods) throws NamingException {
        LDAPModificationSet mods = new LDAPModificationSet();
        int i = 0;
        while (i < jndiMods.length) {
            int modop = jndiMods[i].getModificationOp();
            Attribute attr = jndiMods[i].getAttribute();
            BasicAttributes modAttrs = new BasicAttributes(true);
            modAttrs.put(attr);
            this.modifySchemaElementAttrs(attrs, modop, modAttrs);
            ++i;
        }
    }

    void modifySchemaElementAttrs(Attributes attrs, int modop, Attributes modAttrs) throws NamingException {
        LDAPModificationSet mods = new LDAPModificationSet();
        NamingEnumeration<? extends Attribute> attrEnum = modAttrs.getAll();
        while (attrEnum.hasMore()) {
            NamingEnumeration<?> vals;
            Attribute curAttr;
            Attribute attr = attrEnum.next();
            if (modop == 1) {
                curAttr = attrs.get(attr.getID());
                if (curAttr == null) {
                    attrs.put(attr);
                    continue;
                }
                vals = attr.getAll();
                while (vals.hasMore()) {
                    curAttr.add(vals.nextElement());
                }
                continue;
            }
            if (modop == 2) {
                attrs.put(attr);
                continue;
            }
            if (modop == 3) {
                curAttr = attrs.get(attr.getID());
                if (curAttr == null) {
                    throw new NoSuchAttributeException(attr.getID());
                }
                if (attr.size() == 0) {
                    attrs.remove(attr.getID());
                    continue;
                }
                vals = attr.getAll();
                while (vals.hasMore()) {
                    String val = (String)vals.nextElement();
                    curAttr.remove(val);
                    curAttr.remove(val.toLowerCase());
                }
                if (curAttr.size() != 0) continue;
                attrs.remove(attr.getID());
                continue;
            }
            throw new IllegalArgumentException("Illegal Attribute Modification Operation");
        }
    }

    static boolean parseTrueFalseValue(Attribute attr) throws NamingException {
        NamingEnumeration<?> valEnum = attr.getAll();
        if (valEnum.hasMore()) {
            String flag = (String)valEnum.nextElement();
            if (flag.equals("true")) {
                return true;
            }
            if (flag.equals("false")) {
                return false;
            }
            throw new InvalidAttributeValueException(String.valueOf(attr.getID()) + " value must be \"true\", \"false\" or absent");
        }
        return false;
    }

    static String getSchemaAttrValue(Attribute attr) throws NamingException {
        NamingEnumeration<?> valEnum = attr.getAll();
        if (valEnum.hasMoreElements()) {
            return (String)valEnum.nextElement();
        }
        throw new InvalidAttributeValueException(String.valueOf(attr.getID()) + " must have a value");
    }
}

