/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaManager;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;

public abstract class SchemaElementContainer
extends SchemaDirContext {
    SchemaManager m_schemaMgr;

    public SchemaElementContainer(SchemaManager schemaMgr, String path) throws NamingException {
        this.m_schemaMgr = schemaMgr;
        this.m_path = path;
    }

    abstract DirContext createSchemaElement(String var1, Attributes var2) throws NamingException;

    abstract void removeSchemaElement(String var1) throws NamingException;

    abstract NamingEnumeration getNameList(String var1) throws NamingException;

    abstract NamingEnumeration getBindingsList(String var1) throws NamingException;

    abstract Object lookupSchemaElement(String var1) throws NamingException;

    public Attributes getAttributes(String name) throws NamingException {
        SchemaDirContext schemaElement = (SchemaDirContext)this.lookup(name);
        if (schemaElement == this) {
            throw new OperationNotSupportedException("No Attributes for " + this.m_path);
        }
        return schemaElement.getAttributes("");
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        SchemaDirContext schemaElement = (SchemaDirContext)this.lookup(name);
        if (schemaElement == this) {
            throw new OperationNotSupportedException("No Attributes for " + this.m_path);
        }
        return schemaElement.getAttributes("", attrIds);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        SchemaDirContext schemaElement = (SchemaDirContext)this.lookup(name);
        if (schemaElement == this) {
            throw new OperationNotSupportedException("No Attributes for " + this.m_path);
        }
        schemaElement.modifyAttributes("", mod_op, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        SchemaDirContext schemaElement = (SchemaDirContext)this.lookup(name);
        if (schemaElement == this) {
            throw new OperationNotSupportedException("No Attributes for " + this.m_path);
        }
        schemaElement.modifyAttributes("", mods);
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSchemaElement(name, attrs);
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.removeSchemaElement(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (!(obj instanceof DirContext)) {
            throw new IllegalArgumentException("Can not bind this type of object");
        }
        this.createSubcontext(name, ((DirContext)obj).getAttributes(""));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(String name) throws NamingException {
        this.destroySubcontext(name);
    }

    public void unbind(Name name) throws NamingException {
        this.destroySubcontext(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.getNameList(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.getBindingsList(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        return this.lookupSchemaElement(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }
}

