/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.sasl;

import com.netscape.sasl.SaslClient;
import com.netscape.sasl.SaslClientFactory;
import com.netscape.sasl.SaslException;
import java.util.Hashtable;
import javax.security.auth.callback.CallbackHandler;

public class ClientFactory
implements SaslClientFactory {
    private final String PACKAGENAME = "com.netscape.sasl.mechanisms";
    private final String[] _mechanismNames = new String[]{"EXTERNAL"};
    private final String[] _mechanismClasses = new String[]{"SaslExternal"};
    private Hashtable _mechanismTable = new Hashtable();

    public ClientFactory() {
        int i = 0;
        while (i < this._mechanismNames.length) {
            this._mechanismTable.put(this._mechanismNames[i].toLowerCase(), "com.netscape.sasl.mechanisms." + this._mechanismClasses[i]);
            ++i;
        }
    }

    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Hashtable props, CallbackHandler cbh) throws SaslException {
        String mechName = null;
        int i = 0;
        while (mechName == null && i < mechanisms.length) {
            mechName = (String)this._mechanismTable.get(mechanisms[i].toLowerCase());
            ++i;
        }
        if (mechName != null) {
            try {
                Class<?> c = Class.forName(mechName);
                SaslClient client = (SaslClient)c.newInstance();
                return client;
            }
            catch (Exception e) {
                System.err.println("ClientFactory.createSaslClient: " + e);
            }
        }
        return null;
    }

    public String[] getMechanismNames() {
        return this._mechanismNames;
    }
}

