/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPDITContentRuleSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -8588488481097270056L;
    public static final String AUX = "AUX";
    public static final String MUST = "MUST";
    public static final String MAY = "MAY";
    public static final String NOT = "NOT";
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private Vector aux = new Vector();
    private Vector not = new Vector();

    static {
        int i = 0;
        while (i < NOVALS.length) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
            ++i;
        }
        IGNOREVALS = new String[]{"OBSOLETE", AUX, MUST, MAY, NOT};
    }

    protected LDAPDITContentRuleSchema() {
    }

    public LDAPDITContentRuleSchema(String name, String oid, String description, boolean obsolete, String[] auxiliary, String[] required, String[] optional, String[] precluded) {
        super(name, oid, description, null);
        int i;
        if (required != null) {
            i = 0;
            while (i < required.length) {
                this.must.addElement(required[i]);
                ++i;
            }
        }
        if (optional != null) {
            i = 0;
            while (i < optional.length) {
                this.may.addElement(optional[i]);
                ++i;
            }
        }
        if (auxiliary != null) {
            i = 0;
            while (i < auxiliary.length) {
                this.aux.addElement(auxiliary[i]);
                ++i;
            }
        }
        if (precluded != null) {
            i = 0;
            while (i < precluded.length) {
                this.not.addElement(precluded[i]);
                ++i;
            }
        }
        if (obsolete) {
            this.setQualifier("OBSOLETE", "");
        }
    }

    public LDAPDITContentRuleSchema(String raw) {
        this.attrName = "ditContentRules";
        this.parseValue(raw);
        Object o = this.properties.get(MAY);
        if (o != null) {
            if (o instanceof Vector) {
                this.may = (Vector)o;
            } else {
                this.may.addElement(o);
            }
        }
        if ((o = this.properties.get(MUST)) != null) {
            if (o instanceof Vector) {
                this.must = (Vector)o;
            } else {
                this.must.addElement(o);
            }
        }
        if ((o = this.properties.get(NOT)) != null) {
            if (o instanceof Vector) {
                this.not = (Vector)o;
            } else {
                this.not.addElement(o);
            }
        }
        if ((o = this.properties.get(AUX)) != null) {
            if (o instanceof Vector) {
                this.aux = (Vector)o;
            } else {
                this.aux.addElement(o);
            }
        }
    }

    public String[] getRequiredAttributes() {
        Object[] vals = new String[this.must.size()];
        this.must.copyInto(vals);
        return vals;
    }

    public String[] getOptionalAttributes() {
        Object[] vals = new String[this.may.size()];
        this.may.copyInto(vals);
        return vals;
    }

    public String[] getPrecludedAttributes() {
        Object[] vals = new String[this.not.size()];
        this.not.copyInto(vals);
        return vals;
    }

    public String[] getAuxiliaryClasses() {
        Object[] vals = new String[this.aux.size()];
        this.aux.copyInto(vals);
        return vals;
    }

    public String getValue() {
        String s = this.getValuePrefix();
        String val = this.getOptionalValues(NOVALS);
        if (val.length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if (this.aux.size() > 0) {
            s = String.valueOf(s) + "AUX " + this.vectorToList(this.aux);
            s = String.valueOf(s) + ' ';
        }
        if (this.must.size() > 0) {
            s = String.valueOf(s) + "MUST " + this.vectorToList(this.must);
            s = String.valueOf(s) + ' ';
        }
        if (this.may.size() > 0) {
            s = String.valueOf(s) + "MAY " + this.vectorToList(this.may);
            s = String.valueOf(s) + ' ';
        }
        if (this.not.size() > 0) {
            s = String.valueOf(s) + "NOT " + this.vectorToList(this.not);
            s = String.valueOf(s) + ' ';
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    protected String vectorToList(Vector vals) {
        String val = "( ";
        int i = 0;
        while (i < vals.size()) {
            val = String.valueOf(val) + (String)vals.elementAt(i) + ' ';
            if (i < vals.size() - 1) {
                val = String.valueOf(val) + "$ ";
            }
            ++i;
        }
        val = String.valueOf(val) + ')';
        return val;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid;
        s = String.valueOf(s) + "; Description: " + this.description + "; Required: ";
        int i = 0;
        Enumeration e = this.must.elements();
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        s = String.valueOf(s) + "; Optional: ";
        e = this.may.elements();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        s = String.valueOf(s) + "; Auxiliary: ";
        e = this.aux.elements();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        s = String.valueOf(s) + "; Precluded: ";
        e = this.not.elements();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        if (this.isObsolete()) {
            s = String.valueOf(s) + "; OBSOLETE";
        }
        s = String.valueOf(s) + this.getQualifierString(IGNOREVALS);
        return s;
    }
}

