/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPNameFormSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = 1665316286199590403L;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private String objectClass = null;
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;

    static {
        int i = 0;
        while (i < NOVALS.length) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
            ++i;
        }
        IGNOREVALS = new String[]{"MUST", "MAY", "OBJECTCLASS", "OBSOLETE"};
    }

    public LDAPNameFormSchema(String name, String oid, String description, boolean obsolete, String objectClass, String[] required, String[] optional) {
        super(name, oid, description, null);
        int i;
        this.attrName = "nameforms";
        if (obsolete) {
            this.setQualifier("OBSOLETE", "");
        }
        this.objectClass = objectClass;
        if (required != null) {
            i = 0;
            while (i < required.length) {
                this.must.addElement(required[i]);
                ++i;
            }
        }
        if (optional != null) {
            i = 0;
            while (i < optional.length) {
                this.may.addElement(optional[i]);
                ++i;
            }
        }
    }

    public LDAPNameFormSchema(String raw) {
        this.attrName = "objectclasses";
        this.parseValue(raw);
        Object o = this.properties.get("MAY");
        if (o != null) {
            if (o instanceof Vector) {
                this.may = (Vector)o;
            } else {
                this.may.addElement(o);
            }
        }
        if ((o = this.properties.get("MUST")) != null) {
            if (o instanceof Vector) {
                this.must = (Vector)o;
            } else {
                this.must.addElement(o);
            }
        }
        if ((o = this.properties.get("OC")) != null) {
            this.objectClass = (String)o;
        }
    }

    public String[] getRequiredNamingAttributes() {
        Object[] vals = new String[this.must.size()];
        this.must.copyInto(vals);
        return vals;
    }

    public String[] getOptionalNamingAttributes() {
        Object[] vals = new String[this.may.size()];
        this.may.copyInto(vals);
        return vals;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    String getValue(boolean quotingBug) {
        String s = this.getValuePrefix();
        String val = this.getOptionalValues(NOVALS);
        if (val.length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        s = String.valueOf(s) + "OC " + this.objectClass + ' ';
        if (this.must.size() > 0) {
            s = String.valueOf(s) + "MUST " + this.vectorToList(this.must);
            s = String.valueOf(s) + ' ';
        }
        if (this.may.size() > 0) {
            s = String.valueOf(s) + "MAY " + this.vectorToList(this.may);
            s = String.valueOf(s) + ' ';
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid;
        s = String.valueOf(s) + "; Description: " + this.description + "; Required: ";
        String[] vals = this.getRequiredNamingAttributes();
        int i = 0;
        while (i < vals.length) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + vals[i];
            ++i;
        }
        s = String.valueOf(s) + "; Optional: ";
        vals = this.getOptionalNamingAttributes();
        i = 0;
        while (i < vals.length) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + vals[i];
            ++i;
        }
        if (this.isObsolete()) {
            s = String.valueOf(s) + "; OBSOLETE";
        }
        s = String.valueOf(s) + this.getQualifierString(IGNOREVALS);
        return s;
    }

    protected String vectorToList(Vector vals) {
        String val = "( ";
        int i = 0;
        while (i < vals.size()) {
            val = String.valueOf(val) + (String)vals.elementAt(i) + ' ';
            if (i < vals.size() - 1) {
                val = String.valueOf(val) + "$ ";
            }
            ++i;
        }
        val = String.valueOf(val) + ')';
        return val;
    }
}

