/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import netscape.ldap.DynamicInvoker;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSSLSocketFactoryExt;

public class LDAPSSLSocketFactory
implements LDAPSSLSocketFactoryExt,
Serializable {
    static final long serialVersionUID = -3331456736649381427L;
    private boolean m_clientAuth = false;
    private String m_packageName = "netscape.net.SSLSocket";
    private Object m_cipherSuites = null;

    public LDAPSSLSocketFactory() {
    }

    public LDAPSSLSocketFactory(boolean clientAuth) {
        this.m_clientAuth = clientAuth;
    }

    public LDAPSSLSocketFactory(String className) {
        this.m_packageName = new String(className);
    }

    public LDAPSSLSocketFactory(String className, boolean clientAuth) {
        this.m_packageName = new String(className);
        this.m_clientAuth = clientAuth;
    }

    public LDAPSSLSocketFactory(String className, Object cipherSuites) {
        this.m_packageName = new String(className);
        this.m_cipherSuites = cipherSuites;
    }

    public LDAPSSLSocketFactory(String className, Object cipherSuites, boolean clientAuth) {
        this.m_packageName = new String(className);
        this.m_cipherSuites = cipherSuites;
        this.m_clientAuth = clientAuth;
    }

    public void enableClientAuth() {
        this.m_clientAuth = true;
    }

    public void enableClientAuth(String certdb, String keydb, String keypwd, String certnickname, String keynickname) throws LDAPException {
        throw new LDAPException("Client auth not supported now");
    }

    public boolean isClientAuth() {
        return this.m_clientAuth;
    }

    public String getSSLSocketImpl() {
        return this.m_packageName;
    }

    public Object getCipherSuites() {
        return this.m_cipherSuites;
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        Socket s = null;
        if (this.m_clientAuth) {
            try {
                String[] types = new String[]{"java.lang.String"};
                Method m = DynamicInvoker.getMethod("netscape.security.PrivilegeManager", "enablePrivilege", types);
                if (m != null) {
                    Object[] args = new Object[]{new String("ClientAuth")};
                    m.invoke(null, args);
                }
            }
            catch (Exception e) {
                String msg = "LDAPSSLSocketFactory.makeSocket: invoking enablePrivilege: " + e.toString();
                throw new LDAPException(msg, 89);
            }
        }
        try {
            String cipherClassName = null;
            if (this.m_cipherSuites != null) {
                cipherClassName = this.m_cipherSuites.getClass().getName();
            }
            Class<?> c = Class.forName(this.m_packageName);
            Constructor<?>[] m = c.getConstructors();
            int i = 0;
            while (i < m.length) {
                Class<?>[] params = m[i].getParameterTypes();
                if (this.m_cipherSuites == null && params.length == 2 && params[0].getName().equals("java.lang.String") && params[1].getName().equals("int")) {
                    Object[] args = new Object[]{host, new Integer(port)};
                    s = (Socket)m[i].newInstance(args);
                    return s;
                }
                if (this.m_cipherSuites != null && params.length == 3 && params[0].getName().equals("java.lang.String") && params[1].getName().equals("int") && params[2].getName().equals(cipherClassName)) {
                    Object[] args = new Object[]{host, new Integer(port), this.m_cipherSuites};
                    s = (Socket)m[i].newInstance(args);
                    return s;
                }
                ++i;
            }
            throw new LDAPException("No appropriate constructor in " + this.m_packageName, 89);
        }
        catch (ClassNotFoundException e) {
            throw new LDAPException("Class " + this.m_packageName + " not found", 89);
        }
        catch (Exception e) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }
}

