/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSSLSocket;
import netscape.ldap.LDAPSSLSocketFactoryExt;

public class LDAPSSLSocketWrapFactory
implements LDAPSSLSocketFactoryExt,
Serializable {
    static final long serialVersionUID = -4171548771815037740L;
    private boolean m_clientAuth = false;
    private String m_packageName = null;
    private Object m_cipherSuites = null;

    public LDAPSSLSocketWrapFactory(String className) {
        this.m_packageName = new String(className);
    }

    public LDAPSSLSocketWrapFactory(String className, Object cipherSuites) {
        this.m_packageName = new String(className);
        this.m_cipherSuites = cipherSuites;
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        LDAPSSLSocket s = null;
        try {
            s = this.m_cipherSuites == null ? new LDAPSSLSocket(host, port, this.m_packageName) : new LDAPSSLSocket(host, port, this.m_packageName, this.m_cipherSuites);
            return s;
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.toString());
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    public boolean isClientAuth() {
        return this.m_clientAuth;
    }

    public void enableClientAuth() throws LDAPException {
        throw new LDAPException("Client Authentication is not implemented yet.");
    }

    public String getSSLSocketImpl() {
        return this.m_packageName;
    }

    public Object getCipherSuites() {
        return this.m_cipherSuites;
    }
}

