/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;

public class LDAPSearchListener
extends LDAPMessageQueue {
    static final long serialVersionUID = -7163312406176592277L;
    private Long m_key = null;
    private LDAPSearchConstraints m_constraints;

    LDAPSearchListener(boolean asynchOp, LDAPSearchConstraints cons) {
        super(asynchOp);
        this.m_constraints = cons;
    }

    LDAPResponse completeSearchOperation() throws LDAPException {
        return this.completeRequest();
    }

    public LDAPMessage getResponse() throws LDAPException {
        return this.nextMessage();
    }

    LDAPMessage nextMessage() throws LDAPException {
        LDAPConnThread connThread;
        LDAPMessage result = super.nextMessage();
        if ((result instanceof LDAPSearchResult || result instanceof LDAPSearchResultReference) && (connThread = this.getConnThread(result.getMessageID())) != null) {
            connThread.resultRetrieved();
        }
        return result;
    }

    public void merge(LDAPSearchListener listener2) {
        super.merge(listener2);
    }

    public boolean isResponseReceived() {
        return super.isMessageReceived();
    }

    public int[] getMessageIDs() {
        return super.getMessageIDs();
    }

    LDAPSearchConstraints getSearchConstraints() {
        return this.m_constraints;
    }

    void setSearchConstraints(LDAPSearchConstraints cons) {
        this.m_constraints = cons;
    }

    void reset() {
        super.reset();
        this.m_constraints = null;
    }

    void setKey(Long key) {
        this.m_key = key;
    }

    Long getKey() {
        return this.m_key;
    }
}

