/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;

public abstract class BERIntegral
extends BERElement {
    private int m_value;

    public BERIntegral(int value) {
        this.m_value = value;
    }

    public BERIntegral(InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        if (contents_length > 0) {
            boolean negative = false;
            int octet = stream.read();
            bytes_read[0] = bytes_read[0] + 1;
            if ((octet & 0x80) > 0) {
                negative = true;
            }
            int i = 0;
            while (i < contents_length) {
                if (i > 0) {
                    octet = stream.read();
                    bytes_read[0] = bytes_read[0] + 1;
                }
                this.m_value = negative ? (this.m_value << 8) + (octet ^ 0xFF) & 0xFF : (this.m_value << 8) + (octet & 0xFF);
                ++i;
            }
            if (negative) {
                this.m_value = (this.m_value + 1) * -1;
            }
        }
    }

    public void write(OutputStream stream) throws IOException {
        int binary_value = this.m_value;
        int num_content_octets = 0;
        int offset = 1;
        byte[] content_octets = new byte[10];
        byte[] net_octets = new byte[10];
        if (this.m_value == 0) {
            num_content_octets = 1;
            content_octets[offset] = 0;
            net_octets[offset] = 0;
        } else {
            if (this.m_value < 0) {
                binary_value = this.m_value * -1 - 1;
            }
            do {
                content_octets[num_content_octets + offset] = this.m_value < 0 ? (byte)((binary_value ^ 0xFF) & 0xFF) : (byte)(binary_value & 0xFF);
                ++num_content_octets;
            } while ((binary_value >>= 8) > 0);
            int i = 0;
            while (i < num_content_octets) {
                net_octets[offset + num_content_octets - 1 - i] = content_octets[offset + i];
                ++i;
            }
            byte lead = net_octets[offset];
            if (this.m_value > 0 && (lead & 0x80) > 0) {
                offset = 0;
                net_octets[offset] = 0;
                ++num_content_octets;
            }
        }
        stream.write(this.getType());
        BERIntegral.sendDefiniteLength(stream, num_content_octets);
        stream.write(net_octets, offset, num_content_octets);
    }

    public int getValue() {
        return this.m_value;
    }

    public abstract int getType();

    public abstract String toString();
}

