/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPBindRequest
implements JDAPProtocolOp {
    protected int m_version;
    protected String m_name = null;
    protected String m_password = null;
    protected String m_mechanism = null;
    protected byte[] m_credentials = null;

    public JDAPBindRequest(int version, String name, String password) {
        this.m_version = version;
        this.m_name = name;
        this.m_password = password;
    }

    public JDAPBindRequest(int version, String name, String mechanism, byte[] credentials) {
        this.m_version = version;
        this.m_name = name;
        this.m_mechanism = mechanism;
        this.m_credentials = credentials;
    }

    public int getType() {
        return 0;
    }

    public BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BERInteger(this.m_version));
        seq.addElement(new BEROctetString(this.m_name));
        BERTag auth = null;
        if (this.m_mechanism == null) {
            auth = new BERTag(128, new BEROctetString(this.m_password), true);
        } else {
            BERSequence sasl = new BERSequence();
            sasl.addElement(new BEROctetString(this.m_mechanism));
            if (this.m_credentials == null) {
                sasl.addElement(new BEROctetString(null));
            } else {
                sasl.addElement(new BEROctetString(this.m_credentials, 0, this.m_credentials.length));
            }
            auth = new BERTag(163, sasl, true);
        }
        seq.addElement(auth);
        BERTag element = new BERTag(96, seq, true);
        return element;
    }

    public String getParamString() {
        return "{version=" + this.m_version + ", name=" + this.m_name + ", authentication=" + (this.m_password == null ? this.m_password : "********") + "}";
    }

    public String toString() {
        return "BindRequest " + this.getParamString();
    }
}

