/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;

public class JDAPExtendedResponse
extends JDAPResult
implements JDAPProtocolOp {
    protected String m_oid = null;
    protected byte[] m_value = null;

    public JDAPExtendedResponse(BERElement element) throws IOException {
        super(((BERTag)element).getValue());
        BERSequence seq = (BERSequence)((BERTag)element).getValue();
        int i = 0;
        while (i < seq.size()) {
            block9: {
                try {
                    BERElement el = seq.elementAt(i);
                    if (el.getType() != -1) break block9;
                    BERTag t = (BERTag)el;
                    switch (t.getTag() & 0xF) {
                        case 10: {
                            BEROctetString oid = (BEROctetString)t.getValue();
                            try {
                                this.m_oid = new String(oid.getValue(), "UTF8");
                            }
                            catch (Throwable throwable) {}
                            break;
                        }
                        case 11: {
                            BEROctetString value = (BEROctetString)t.getValue();
                            this.m_value = value.getValue();
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public int getType() {
        return 24;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public String getID() {
        return this.m_oid;
    }

    public String toString() {
        return "ExtendedResponse " + super.getParamString();
    }
}

