/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public final class ByteBuf
implements Serializable {
    static final long serialVersionUID = -786393456618166871L;
    private byte[] value;
    private int count;

    public ByteBuf() {
        this(16);
    }

    public ByteBuf(int length) {
        this.value = new byte[length];
    }

    public ByteBuf(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public ByteBuf(byte[] bytes, int offset, int length) {
        this.value = new byte[length];
        System.arraycopy(bytes, offset, this.value, 0, length);
        this.count = length;
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        int maxCapacity = this.value.length;
        if (minimumCapacity > maxCapacity) {
            int newCapacity = (maxCapacity + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            byte[] newValue = new byte[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (this.count < newLength) {
            this.ensureCapacity(newLength);
            while (this.count < newLength) {
                this.value[this.count] = 0;
                ++this.count;
            }
        }
        this.count = newLength;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin >= this.count) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public void setByteAt(int index, byte b) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = b;
    }

    public ByteBuf append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public ByteBuf append(String str) {
        if (str == null) {
            str = String.valueOf(str);
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        int i = 0;
        while (i < len) {
            this.value[this.count++] = (byte)str.charAt(i);
            ++i;
        }
        return this;
    }

    public ByteBuf append(byte[] str) {
        int len = str.length;
        this.ensureCapacity(this.count + len);
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public ByteBuf append(byte[] str, int offset, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public ByteBuf append(ByteBuf buf) {
        this.append(buf.toBytes(), 0, buf.length());
        return this;
    }

    public ByteBuf append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public ByteBuf append(byte b) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = b;
        return this;
    }

    public ByteBuf append(int i) {
        return this.append(String.valueOf(i));
    }

    public ByteBuf append(long l) {
        return this.append(String.valueOf(l));
    }

    public ByteBuf append(float f) {
        return this.append(String.valueOf(f));
    }

    public ByteBuf append(double d) {
        return this.append(String.valueOf(d));
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public byte[] toBytes() {
        byte[] b = new byte[this.count];
        System.arraycopy(this.value, 0, b, 0, this.count);
        return b;
    }

    public int read(InputStream file, int max_bytes) throws IOException {
        this.ensureCapacity(this.count + max_bytes);
        int i = file.read(this.value, this.count, max_bytes);
        if (i > 0) {
            this.count += i;
        }
        return i;
    }

    public int read(RandomAccessFile file, int max_bytes) throws IOException {
        this.ensureCapacity(this.count + max_bytes);
        int i = file.read(this.value, this.count, max_bytes);
        if (i > 0) {
            this.count += i;
        }
        return i;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.value, 0, this.count);
    }

    public void write(RandomAccessFile out) throws IOException {
        out.write(this.value, 0, this.count);
    }
}

