/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.Date;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class ConnectionPool {
    private int poolSize;
    private int poolMax;
    private String host;
    private int port;
    private String authdn;
    private String authpw;
    private LDAPConnection ldc = null;
    private Vector pool;
    private boolean debugMode;

    public ConnectionPool(int min, int max, String host, int port, String authdn, String authpw) throws LDAPException {
        this(min, max, host, port, authdn, authpw, null);
    }

    public ConnectionPool(int min, int max, String host, int port) throws LDAPException {
        this(min, max, host, port, "", "");
    }

    public ConnectionPool(String host, int port) throws LDAPException {
        this(10, 20, host, port, "", "");
    }

    public ConnectionPool(int min, int max, LDAPConnection ldc) throws LDAPException {
        this(min, max, ldc.getHost(), ldc.getPort(), ldc.getAuthenticationDN(), ldc.getAuthenticationPassword(), (LDAPConnection)ldc.clone());
    }

    private ConnectionPool(int min, int max, String host, int port, String authdn, String authpw, LDAPConnection ldc) throws LDAPException {
        this.poolSize = min;
        this.poolMax = max;
        this.host = host;
        this.port = port;
        this.authdn = authdn;
        this.authpw = authpw;
        this.ldc = ldc;
        this.debugMode = false;
        this.createPool();
    }

    public void destroy() {
        int i = 0;
        while (i < this.pool.size()) {
            this.disconnect((LDAPConnectionObject)this.pool.elementAt(i));
            ++i;
        }
        this.pool.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnection() {
        LDAPConnection con;
        while ((con = this.getConnFromPool()) == null) {
            Vector vector = this.pool;
            synchronized (vector) {
                try {
                    this.pool.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnection(int timeout) {
        LDAPConnection con;
        while ((con = this.getConnFromPool()) == null) {
            long t0 = System.currentTimeMillis();
            if (timeout <= 0) {
                return con;
            }
            Vector vector = this.pool;
            synchronized (vector) {
                try {
                    this.pool.wait(timeout);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            long t1 = System.currentTimeMillis();
            timeout = (int)((long)timeout - (t1 - t0));
        }
        return con;
    }

    protected synchronized LDAPConnection getConnFromPool() {
        LDAPConnection con = null;
        LDAPConnectionObject ldapconnobj = null;
        int pSize = this.pool.size();
        int i = 0;
        while (i < pSize) {
            LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(i);
            if (co.isAvailable()) {
                ldapconnobj = co;
                break;
            }
            ++i;
        }
        if (ldapconnobj == null) {
            if (this.poolMax < 0 || this.poolMax > 0 && pSize < this.poolMax) {
                i = this.addConnection();
                if (i >= 0) {
                    ldapconnobj = (LDAPConnectionObject)this.pool.elementAt(i);
                }
            } else {
                this.debug("All pool connections in use");
            }
        }
        if (ldapconnobj != null) {
            ldapconnobj.setInUse(true);
            con = ldapconnobj.getLDAPConn();
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(LDAPConnection ld) {
        int index = this.find(ld);
        if (index != -1) {
            LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(index);
            if (this.ldc == null || !this.ldc.getAuthenticationMethod().equals("sasl")) {
                boolean reauth = false;
                if (ld.getAuthenticationDN() == null) {
                    reauth = this.authdn != null;
                } else if (!ld.getAuthenticationDN().equalsIgnoreCase(this.authdn)) {
                    reauth = true;
                }
                if (reauth) {
                    try {
                        this.debug("user changed credentials-resetting");
                        ld.bind(this.authdn, this.authpw);
                    }
                    catch (LDAPException e) {
                        this.debug("unable to reauth during close as " + this.authdn);
                        this.debug(e.toString());
                    }
                }
            }
            co.setInUse(false);
            Vector vector = this.pool;
            synchronized (vector) {
                this.pool.notifyAll();
            }
        }
    }

    public void printPool() {
        System.out.println("--ConnectionPool--");
        int i = 0;
        while (i < this.pool.size()) {
            LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(i);
            System.out.println(i + "=" + co);
            ++i;
        }
    }

    private void disconnect(LDAPConnectionObject ldapconnObject) {
        if (ldapconnObject != null && ldapconnObject.isAvailable()) {
            LDAPConnection ld = ldapconnObject.getLDAPConn();
            if (ld != null && ld.isConnected()) {
                try {
                    ld.disconnect();
                }
                catch (LDAPException e) {
                    this.debug("disconnect: " + e.toString());
                }
            }
            ldapconnObject.setLDAPConn(null);
        }
    }

    private void createPool() throws LDAPException {
        if (this.poolSize <= 0) {
            throw new LDAPException("ConnectionPoolSize invalid");
        }
        if (this.poolMax < this.poolSize) {
            this.debug("ConnectionPoolMax is invalid, set to " + this.poolSize);
            this.poolMax = this.poolSize;
        }
        this.debug("****Initializing LDAP Pool****");
        this.debug("LDAP host = " + this.host + " on port " + this.port);
        this.debug("Number of connections=" + this.poolSize);
        this.debug("Maximum number of connections=" + this.poolMax);
        this.debug("******");
        this.pool = new Vector();
        this.setUpPool(this.poolSize);
    }

    private int addConnection() {
        int index = -1;
        this.debug("adding a connection to pool...");
        try {
            int size = this.pool.size() + 1;
            this.setUpPool(size);
            if (size == this.pool.size()) {
                index = size - 1;
            }
        }
        catch (Exception ex) {
            this.debug("Adding a connection: " + ex.toString());
        }
        return index;
    }

    private synchronized void setUpPool(int size) throws LDAPException {
        while (this.pool.size() < size) {
            LDAPConnectionObject co;
            block7: {
                co = new LDAPConnectionObject();
                LDAPConnection newConn = this.ldc != null ? (LDAPConnection)this.ldc.clone() : new LDAPConnection();
                co.setLDAPConn(newConn);
                try {
                    if (newConn.isConnected()) {
                        newConn.reconnect();
                        break block7;
                    }
                    try {
                        newConn.connect(3, this.host, this.port, this.authdn, this.authpw);
                    }
                    catch (LDAPException connEx) {
                        if (connEx.getLDAPResultCode() == 2) {
                            newConn.connect(2, this.host, this.port, this.authdn, this.authpw);
                            break block7;
                        }
                        throw connEx;
                    }
                }
                catch (LDAPException le) {
                    this.debug("Creating pool:" + le.toString());
                    this.debug("aborting....");
                    throw le;
                }
            }
            co.setInUse(false);
            this.pool.addElement(co);
        }
    }

    private int find(LDAPConnection con) {
        if (con != null) {
            int i = 0;
            while (i < this.pool.size()) {
                LDAPConnectionObject co = (LDAPConnectionObject)this.pool.elementAt(i);
                if (co.getLDAPConn() == con) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public synchronized void setDebug(boolean mode) {
        this.debugMode = mode;
    }

    public boolean getDebug() {
        return this.debugMode;
    }

    private void debug(String s) {
        if (this.debugMode) {
            System.out.println("ConnectionPool (" + new Date() + ") : " + s);
        }
    }

    private void debug(String s, boolean severe) {
        if (this.debugMode || severe) {
            System.out.println("ConnectionPool (" + new Date() + ") : " + s);
        }
    }

    class LDAPConnectionObject {
        private LDAPConnection ld;
        private boolean inUse;

        LDAPConnectionObject() {
        }

        LDAPConnection getLDAPConn() {
            return this.ld;
        }

        void setLDAPConn(LDAPConnection ld) {
            this.ld = ld;
        }

        void setInUse(boolean inUse) {
            this.inUse = inUse;
        }

        boolean isAvailable() {
            return !this.inUse;
        }

        public String toString() {
            return "LDAPConnection=" + this.ld + ",inUse=" + this.inUse;
        }
    }
}

