/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.extend.ContentFunction;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;

public class ContentFunctionFactory {
    private List _functions = new ArrayList();

    public ContentFunctionFactory() {
        this._functions.add(new PageCounterFunction());
        this._functions.add(new PagesCounterFunction());
        this._functions.add(new FSCurrentPageFunction());
        this._functions.add(new FSPageRangeFunction());
    }

    public ContentFunction lookupFunction(LayoutContext c, String declaration) {
        Iterator i = this._functions.iterator();
        while (i.hasNext()) {
            ContentFunction function = (ContentFunction)i.next();
            if (!function.canHandle(c, declaration)) continue;
            return function;
        }
        return null;
    }

    public void registerFunction(ContentFunction function) {
        this._functions.add(function);
    }

    private static class FSPageRangeFunction
    extends PageNumberFunction
    implements ContentFunction {
        private FSPageRangeFunction() {
        }

        public String calculate(RenderingContext c, String declaration, InlineText text) {
            String id = declaration.substring("-fs-page-range(".length(), declaration.length() - 1).trim();
            Box b = c.getIDBox(id);
            if (b == null) {
                return "";
            }
            Layer root = text.getParent().getContainingLayer().findRoot();
            PageBox first = root.getFirstPage(c, b);
            PageBox last = root.getLastPage(c, b);
            return Integer.toString(last.getPageNo() - first.getPageNo() + 1);
        }

        public boolean canHandle(LayoutContext c, String declaration) {
            return c.isPrint() && declaration.startsWith("-fs-page-range(");
        }
    }

    private static class FSCurrentPageFunction
    extends PageNumberFunction
    implements ContentFunction {
        private FSCurrentPageFunction() {
        }

        public String calculate(RenderingContext c, String declaration, InlineText text) {
            String id = declaration.substring("-fs-current-page(".length(), declaration.length() - 1).trim();
            Box b = c.getIDBox(id);
            if (b == null) {
                return "";
            }
            Layer root = text.getParent().getContainingLayer().findRoot();
            PageBox pageBox = root.getFirstPage(c, b);
            return Integer.toString(c.getPageNo() - pageBox.getPageNo() + 1);
        }

        public boolean canHandle(LayoutContext c, String declaration) {
            return c.isPrint() && declaration.startsWith("-fs-current-page(");
        }
    }

    private static class PagesCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PagesCounterFunction() {
        }

        public String calculate(RenderingContext c, String declaration, InlineText text) {
            return Integer.toString(c.getPageCount());
        }

        public boolean canHandle(LayoutContext c, String declaration) {
            return c.isPrint() && declaration.equals("counter(pages)");
        }
    }

    private static class PageCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PageCounterFunction() {
        }

        public String calculate(RenderingContext c, String declaration, InlineText text) {
            return Integer.toString(c.getPageNo() + 1);
        }

        public boolean canHandle(LayoutContext c, String declaration) {
            return c.isPrint() && declaration.equals("counter(page)");
        }
    }

    private static abstract class PageNumberFunction
    implements ContentFunction {
        private PageNumberFunction() {
        }

        public boolean isStatic() {
            return false;
        }

        public String calculate(LayoutContext c, String declaration) {
            return null;
        }

        public String getLayoutReplacementText() {
            return "999";
        }
    }
}

