/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.newmatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;

public class CascadedStyle {
    private Map cascadedProperties = new HashMap();
    private String fingerprint;
    public static final CascadedStyle emptyCascadedStyle = new CascadedStyle();

    CascadedStyle(Iterator iter) {
        this();
        int i;
        List[] buckets = new List[6];
        for (i = 0; i < buckets.length; ++i) {
            buckets[i] = new LinkedList();
        }
        while (iter.hasNext()) {
            PropertyDeclaration prop = (PropertyDeclaration)iter.next();
            buckets[prop.getImportanceAndOrigin()].add(prop);
        }
        for (i = 0; i < buckets.length; ++i) {
            Iterator it = buckets[i].iterator();
            while (it.hasNext()) {
                PropertyDeclaration prop = (PropertyDeclaration)it.next();
                this.cascadedProperties.put(prop.getCSSName(), prop);
            }
        }
    }

    private CascadedStyle() {
    }

    public boolean hasProperty(CSSName cssName) {
        return this.cascadedProperties.get(cssName) != null;
    }

    public PropertyDeclaration propertyByName(CSSName cssName) {
        PropertyDeclaration prop = (PropertyDeclaration)this.cascadedProperties.get(cssName);
        return prop;
    }

    public IdentValue getIdent(CSSName cssName) {
        PropertyDeclaration pd = this.propertyByName(cssName);
        return pd == null ? null : pd.asIdentValue();
    }

    public Iterator getCascadedPropertyDeclarations() {
        ArrayList list = new ArrayList(this.cascadedProperties.size());
        Iterator iter = this.cascadedProperties.values().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list.iterator();
    }

    public int countAssigned() {
        return this.cascadedProperties.size();
    }

    public String getFingerprint() {
        if (this.fingerprint == null) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = this.cascadedProperties.values().iterator();
            while (iter.hasNext()) {
                sb.append(((PropertyDeclaration)iter.next()).getDeclarationStandardText());
            }
            this.fingerprint = sb.toString();
        }
        return this.fingerprint;
    }
}

