/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.newmatch;

import java.util.ArrayList;
import org.xhtmlrenderer.css.extend.AttributeResolver;
import org.xhtmlrenderer.css.extend.TreeResolver;

abstract class Condition {
    Condition() {
    }

    abstract boolean matches(Object var1, AttributeResolver var2, TreeResolver var3);

    static Condition createAttributeExistsCondition(String name) {
        return new AttributeExistsCondition(name);
    }

    static Condition createAttributeEqualsCondition(String name, String value) {
        return new AttributeEqualsCondition(name, value);
    }

    static Condition createAttributeMatchesListCondition(String name, String value) {
        return new AttributeMatchesListCondition(name, value);
    }

    static Condition createAttributeMatchesFirstPartCondition(String name, String value) {
        return new AttributeMatchesFirstPartCondition(name, value);
    }

    static Condition createClassCondition(String className) {
        return new ClassCondition(className);
    }

    static Condition createIDCondition(String id) {
        return new IDCondition(id);
    }

    static Condition createLangCondition(String lang) {
        return new LangCondition(lang);
    }

    static Condition createFirstChildCondition() {
        return new FirstChildCondition();
    }

    static Condition createLinkCondition() {
        return new LinkCondition();
    }

    static Condition createUnsupportedCondition() {
        return new UnsupportedCondition();
    }

    private static String[] split(String s, char ch) {
        if (s.indexOf(ch) == -1) {
            return new String[]{s};
        }
        ArrayList<String> result = new ArrayList<String>();
        int last = 0;
        int next = 0;
        while ((next = s.indexOf(ch, last)) != -1) {
            if (next != last) {
                result.add(s.substring(last, next));
            }
            last = next + 1;
        }
        if (last != s.length()) {
            result.add(s.substring(last));
        }
        return result.toArray(new String[result.size()]);
    }

    private static class UnsupportedCondition
    extends Condition {
        UnsupportedCondition() {
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            return false;
        }
    }

    private static class LinkCondition
    extends Condition {
        LinkCondition() {
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            return attRes.isLink(e);
        }
    }

    private static class FirstChildCondition
    extends Condition {
        FirstChildCondition() {
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            return treeRes.isFirstChildElement(e);
        }
    }

    private static class LangCondition
    extends Condition {
        private String _lang;

        LangCondition(String lang) {
            this._lang = lang;
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            if (attRes == null) {
                return false;
            }
            String lang = attRes.getLang(e);
            if (lang == null) {
                return false;
            }
            String[] ca = Condition.split(lang, '-');
            return this._lang.equals(ca[0]);
        }
    }

    private static class IDCondition
    extends Condition {
        private String _id;

        IDCondition(String id) {
            this._id = id;
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            if (attRes == null) {
                return false;
            }
            return this._id.equals(attRes.getID(e));
        }
    }

    private static class ClassCondition
    extends Condition {
        private String _className;

        ClassCondition(String className) {
            this._className = className;
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            if (attRes == null) {
                return false;
            }
            String c = attRes.getClass(e);
            if (c == null) {
                return false;
            }
            String[] ca = Condition.split(c, ' ');
            boolean matched = false;
            for (int j = 0; j < ca.length; ++j) {
                if (!this._className.equals(ca[j])) continue;
                matched = true;
            }
            return matched;
        }
    }

    private static class AttributeMatchesFirstPartCondition
    extends Condition {
        private String _name;
        private String _value;

        AttributeMatchesFirstPartCondition(String name, String value) {
            this._name = name;
            this._value = value;
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            if (attRes == null) {
                return false;
            }
            String val = attRes.getAttributeValue(e, this._name);
            if (val == null) {
                return false;
            }
            String[] ca = Condition.split(val, '-');
            return this._value.equals(ca[0]);
        }
    }

    private static class AttributeMatchesListCondition
    extends Condition {
        private String _name;
        private String _value;

        AttributeMatchesListCondition(String name, String value) {
            this._name = name;
            this._value = value;
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            if (attRes == null) {
                return false;
            }
            String val = attRes.getAttributeValue(e, this._name);
            if (val == null) {
                return false;
            }
            String[] ca = Condition.split(val, ' ');
            boolean matched = false;
            for (int j = 0; j < ca.length; ++j) {
                if (!this._value.equals(ca[j])) continue;
                matched = true;
            }
            return matched;
        }
    }

    private static class AttributeEqualsCondition
    extends Condition {
        private String _name;
        private String _value;

        AttributeEqualsCondition(String name, String value) {
            this._name = name;
            this._value = value;
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            if (attRes == null) {
                return false;
            }
            String val = attRes.getAttributeValue(e, this._name);
            if (val == null) {
                return false;
            }
            return val.equals(this._value);
        }
    }

    private static class AttributeExistsCondition
    extends Condition {
        private String _name;

        AttributeExistsCondition(String name) {
            this._name = name;
        }

        boolean matches(Object e, AttributeResolver attRes, TreeResolver treeRes) {
            if (attRes == null) {
                return false;
            }
            return attRes.getAttributeValue(e, this._name) != null;
        }
    }
}

