/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.newmatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.PositionalCondition;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.xhtmlrenderer.css.extend.AttributeResolver;
import org.xhtmlrenderer.css.extend.StylesheetFactory;
import org.xhtmlrenderer.css.extend.TreeResolver;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.newmatch.Selector;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.Stylesheet;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.util.XRLog;

public class Matcher {
    Mapper docMapper;
    private AttributeResolver _attRes;
    private TreeResolver _treeRes;
    private StylesheetFactory _styleFactory;
    private Map _map;
    private Set _hoverElements;
    private Set _activeElements;
    private Set _focusElements;
    private Set _visitElements;
    private List _pageRules;

    public Matcher(TreeResolver tr, AttributeResolver ar, StylesheetFactory factory, List stylesheets, String media) {
        this.newMaps();
        this._treeRes = tr;
        this._attRes = ar;
        this._styleFactory = factory;
        this.docMapper = this.createDocumentMapper(stylesheets.iterator(), media);
        this._pageRules = new ArrayList();
        this.collectPageRules(stylesheets, this._pageRules, media);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CascadedStyle getCascadedStyle(Object e, boolean restyle) {
        Object object = e;
        synchronized (object) {
            Mapper em = !restyle ? this.getMapper(e) : this.matchElement(e);
            return em.getCascadedStyle(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CascadedStyle getPECascadedStyle(Object e, String pseudoElement) {
        Object object = e;
        synchronized (object) {
            Mapper em = this.getMapper(e);
            return em.getPECascadedStyle(e, pseudoElement);
        }
    }

    public CascadedStyle getPageCascadedStyle() {
        return this.getPageCascadedStyle(null);
    }

    public CascadedStyle getPageCascadedStyle(String pseudoPage) {
        ArrayList props = new ArrayList();
        if (pseudoPage == null) {
            this.addPageRules(props, null);
        } else if (pseudoPage.equals("left") || pseudoPage.equals("right")) {
            this.addPageRules(props, null);
            this.addPageRules(props, pseudoPage);
        } else if (pseudoPage.equals("first")) {
            this.addPageRules(props, null);
            this.addPageRules(props, "left");
            this.addPageRules(props, "first");
        }
        if (props.isEmpty()) {
            return CascadedStyle.emptyCascadedStyle;
        }
        return new CascadedStyle(props.iterator());
    }

    private void addPageRules(List props, String pseudoPage) {
        Iterator i = this._pageRules.iterator();
        while (i.hasNext()) {
            Ruleset r = (Ruleset)i.next();
            boolean matches = pseudoPage == null && (r.getSelectorText() == null || r.getSelectorText().trim().equals("")) || r.getSelectorText() != null && r.getSelectorText().trim().equals(":" + pseudoPage);
            if (!matches) continue;
            props.addAll(r.getPropertyDeclarations());
        }
    }

    public boolean isVisitedStyled(Object e) {
        return this._visitElements.contains(e);
    }

    public boolean isHoverStyled(Object e) {
        return this._hoverElements.contains(e);
    }

    public boolean isActiveStyled(Object e) {
        return this._activeElements.contains(e);
    }

    public boolean isFocusStyled(Object e) {
        return this._focusElements.contains(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mapper matchElement(Object e) {
        Object object = e;
        synchronized (object) {
            Mapper child;
            Object parent = this._treeRes.getParentElement(e);
            if (parent != null) {
                Mapper m = this.getMapper(parent);
                child = m.mapChild(e);
            } else {
                child = this.docMapper.mapChild(e);
            }
            return child;
        }
    }

    Mapper createDocumentMapper(Iterator stylesheets, String media) {
        int count = 0;
        TreeMap sorter = new TreeMap();
        while (stylesheets.hasNext()) {
            count = this.appendStylesheet((StylesheetInfo)stylesheets.next(), count, sorter, media);
        }
        XRLog.match("Matcher created with " + sorter.size() + " selectors");
        return new Mapper(sorter.values());
    }

    private void link(Object e, Mapper m) {
        this._map.put(e, m);
    }

    private void newMaps() {
        this._map = Collections.synchronizedMap(new HashMap());
        this._hoverElements = Collections.synchronizedSet(new HashSet());
        this._activeElements = Collections.synchronizedSet(new HashSet());
        this._focusElements = Collections.synchronizedSet(new HashSet());
        this._visitElements = Collections.synchronizedSet(new HashSet());
    }

    private void collectPageRules(List infos, List pageRulesets, String media) {
        Iterator i = infos.iterator();
        while (i.hasNext()) {
            StylesheetInfo si = (StylesheetInfo)i.next();
            this.collectPageRules(si, pageRulesets, media);
        }
    }

    private void collectPageRules(StylesheetInfo si, List pageRulesets, String media) {
        if (!si.appliesToMedia(media)) {
            return;
        }
        Stylesheet ss = si.getStylesheet();
        if (ss == null) {
            ss = this._styleFactory.getStylesheet(si);
            si.setStylesheet(ss);
        }
        if (ss == null) {
            return;
        }
        pageRulesets.addAll(ss.getPageRulesets());
        Iterator rulesets = ss.getRulesets();
        while (rulesets.hasNext()) {
            Object obj = rulesets.next();
            if (!(obj instanceof StylesheetInfo)) continue;
            this.collectPageRules((StylesheetInfo)obj, pageRulesets, media);
        }
    }

    private int appendStylesheet(StylesheetInfo si, int count, TreeMap sorter, String media) {
        if (!si.appliesToMedia(media)) {
            return count;
        }
        Stylesheet ss = si.getStylesheet();
        if (ss == null) {
            ss = this._styleFactory.getStylesheet(si);
            si.setStylesheet(ss);
        }
        if (ss == null) {
            return count;
        }
        Iterator rulesets = ss.getRulesets();
        while (rulesets.hasNext()) {
            Object obj = rulesets.next();
            if (obj instanceof StylesheetInfo) {
                count = this.appendStylesheet((StylesheetInfo)obj, count, sorter, media);
                continue;
            }
            Ruleset r = (Ruleset)obj;
            SelectorList selector_list = r.getSelectorList();
            for (int i = 0; i < selector_list.getLength(); ++i) {
                org.w3c.css.sac.Selector selector = selector_list.item(i);
                Selector s = this.addSelector(count++, r, selector);
                sorter.put(s.getOrder(), s);
            }
        }
        return count;
    }

    private Selector addSelector(int pos, Ruleset rs, org.w3c.css.sac.Selector selector) {
        Selector s = null;
        if (selector.getSelectorType() == 12) {
            s = this.addSiblingSelector(pos, rs, selector);
        } else if (selector.getSelectorType() == 11) {
            s = this.addSelector(pos, rs, ((DescendantSelector)selector).getAncestorSelector());
            this.addChainedSelector(s, selector);
        } else if (selector.getSelectorType() == 10) {
            s = this.addSelector(pos, rs, ((DescendantSelector)selector).getAncestorSelector());
            this.addChainedSelector(s, selector);
        } else if (selector.getSelectorType() == 0) {
            Condition cond = ((ConditionalSelector)selector).getCondition();
            s = this.addSelector(pos, rs, (org.w3c.css.sac.Selector)((ConditionalSelector)selector).getSimpleSelector());
            this.addConditions(s, cond);
        } else if (selector.getSelectorType() == 4) {
            s = new Selector(pos, rs, 0, ((ElementSelector)selector).getLocalName());
        } else {
            XRLog.exception("unsupported selector in addSelector: " + selector.getSelectorType());
        }
        return s;
    }

    private void addChainedSelector(Selector s, org.w3c.css.sac.Selector selector) {
        int axis = 0;
        SimpleSelector simple = null;
        switch (selector.getSelectorType()) {
            case 11: {
                axis = 1;
                simple = ((DescendantSelector)selector).getSimpleSelector();
                break;
            }
            case 10: {
                axis = 0;
                simple = ((DescendantSelector)selector).getSimpleSelector();
                break;
            }
            default: {
                System.err.println("Bad selector in addChainedSelector");
            }
        }
        Condition cond = null;
        if (simple.getSelectorType() == 0) {
            cond = ((ConditionalSelector)simple).getCondition();
            simple = ((ConditionalSelector)simple).getSimpleSelector();
        }
        if (simple.getSelectorType() == 4) {
            s = s.appendChainedSelector(axis, ((ElementSelector)simple).getLocalName());
        }
        if (cond != null) {
            this.addConditions(s, cond);
        }
    }

    private Selector addSiblingSelector(int pos, Ruleset rs, org.w3c.css.sac.Selector siblingSelector) {
        Selector s;
        int axis = 0;
        SimpleSelector simple = null;
        org.w3c.css.sac.Selector sib = null;
        switch (siblingSelector.getSelectorType()) {
            case 12: {
                simple = ((SiblingSelector)siblingSelector).getSiblingSelector();
                sib = ((SiblingSelector)siblingSelector).getSelector();
                break;
            }
            default: {
                XRLog.exception("Bad selector in addSiblingSelector");
            }
        }
        Selector ancestor = null;
        Selector current = null;
        org.w3c.css.sac.Selector pa = sib;
        while (pa.getSelectorType() == 12) {
            pa = ((SiblingSelector)pa).getSelector();
        }
        if (pa.getSelectorType() == 11) {
            ancestor = this.addSelector(pos, rs, ((DescendantSelector)pa).getAncestorSelector());
            axis = 1;
        } else if (pa.getSelectorType() == 10) {
            ancestor = this.addSelector(pos, rs, ((DescendantSelector)pa).getAncestorSelector());
        } else if (pa.getSelectorType() != 0 && pa.getSelectorType() != 4) {
            XRLog.exception("unsupported selector in addSiblingSelector: " + pa.getSelectorType());
        }
        Condition cond = null;
        if (simple.getSelectorType() == 0) {
            cond = ((ConditionalSelector)simple).getCondition();
            simple = ((ConditionalSelector)simple).getSimpleSelector();
        }
        if (simple.getSelectorType() == 4) {
            if (ancestor == null) {
                ancestor = current = new Selector(pos, rs, 0, ((ElementSelector)simple).getLocalName());
            } else {
                current = ancestor.appendChainedSelector(axis, ((ElementSelector)simple).getLocalName());
            }
        }
        if (cond != null) {
            this.addConditions(current, cond);
        }
        while (sib.getSelectorType() == 12) {
            simple = ((SiblingSelector)sib).getSiblingSelector();
            cond = null;
            s = null;
            if (simple.getSelectorType() == 0) {
                cond = ((ConditionalSelector)simple).getCondition();
                simple = ((ConditionalSelector)simple).getSimpleSelector();
            }
            if (simple.getSelectorType() == 4) {
                s = current.appendSiblingSelector(2, ((ElementSelector)simple).getLocalName());
            }
            if (cond != null) {
                this.addConditions(s, cond);
            }
            sib = ((SiblingSelector)sib).getSelector();
        }
        simple = null;
        switch (sib.getSelectorType()) {
            case 11: {
                simple = ((DescendantSelector)sib).getSimpleSelector();
                break;
            }
            case 10: {
                simple = ((DescendantSelector)sib).getSimpleSelector();
                break;
            }
            default: {
                simple = (SimpleSelector)sib;
            }
        }
        cond = null;
        s = null;
        if (simple.getSelectorType() == 0) {
            cond = ((ConditionalSelector)simple).getCondition();
            simple = ((ConditionalSelector)simple).getSimpleSelector();
        }
        if (simple.getSelectorType() == 4) {
            s = current.appendSiblingSelector(2, ((ElementSelector)simple).getLocalName());
        }
        if (cond != null) {
            this.addConditions(s, cond);
        }
        return ancestor;
    }

    private void addConditions(Selector s, Condition cond) {
        switch (cond.getConditionType()) {
            case 0: {
                CombinatorCondition comb = (CombinatorCondition)cond;
                this.addConditions(s, comb.getFirstCondition());
                this.addConditions(s, comb.getSecondCondition());
                break;
            }
            case 4: {
                AttributeCondition attr = (AttributeCondition)cond;
                if (attr.getSpecified()) {
                    s.addAttributeEqualsCondition(attr.getLocalName(), attr.getValue());
                    break;
                }
                s.addAttributeExistsCondition(attr.getLocalName());
                break;
            }
            case 8: {
                AttributeCondition attr = (AttributeCondition)cond;
                s.addAttributeMatchesFirstPartCondition(attr.getLocalName(), attr.getValue());
                break;
            }
            case 9: {
                AttributeCondition attr = (AttributeCondition)cond;
                s.addClassCondition(attr.getValue());
                break;
            }
            case 5: {
                AttributeCondition attr = (AttributeCondition)cond;
                s.addIDCondition(attr.getValue());
                break;
            }
            case 6: {
                LangCondition lang = (LangCondition)cond;
                s.addLangCondition(lang.getLang());
                break;
            }
            case 7: {
                AttributeCondition attr = (AttributeCondition)cond;
                s.addAttributeMatchesListCondition(attr.getLocalName(), attr.getValue());
                break;
            }
            case 3: {
                PositionalCondition pos = (PositionalCondition)cond;
                if (pos.getPosition() == 0) {
                    s.addFirstChildCondition();
                    break;
                }
                s.addUnsupportedCondition();
                break;
            }
            case 10: {
                AttributeCondition attr = (AttributeCondition)cond;
                if (attr.getValue().equals("link")) {
                    s.addLinkCondition();
                    break;
                }
                if (attr.getValue().equals("visited")) {
                    s.setPseudoClass(2);
                    break;
                }
                if (attr.getValue().equals("hover")) {
                    s.setPseudoClass(4);
                    break;
                }
                if (attr.getValue().equals("active")) {
                    s.setPseudoClass(8);
                    break;
                }
                if (attr.getValue().equals("focus")) {
                    s.setPseudoClass(16);
                    break;
                }
                if (attr.getValue().equals("first-child")) {
                    s.addFirstChildCondition();
                    break;
                }
                s.setPseudoElement(attr.getValue());
                break;
            }
            default: {
                System.err.println("Bad condition");
            }
        }
    }

    private Mapper getMapper(Object e) {
        Mapper m = (Mapper)this._map.get(e);
        if (m != null) {
            return m;
        }
        m = this.matchElement(e);
        return m;
    }

    private static Iterator getMatchedRulesets(final List mappedSelectors) {
        return new Iterator(){
            Iterator selectors;
            {
                this.selectors = mappedSelectors.iterator();
            }

            public boolean hasNext() {
                return this.selectors.hasNext();
            }

            public Object next() {
                if (this.hasNext()) {
                    return ((Selector)this.selectors.next()).getRuleset();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator getSelectedRulesets(List selectorList) {
        final List sl = selectorList;
        return new Iterator(){
            Iterator selectors;
            {
                this.selectors = sl.iterator();
            }

            public boolean hasNext() {
                return this.selectors.hasNext();
            }

            public Object next() {
                if (this.hasNext()) {
                    return ((Selector)this.selectors.next()).getRuleset();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ruleset getElementStyle(Object e) {
        Object object = e;
        synchronized (object) {
            if (this._attRes == null || this._styleFactory == null) {
                return null;
            }
            String style = this._attRes.getElementStyling(e);
            if (style == null || style.equals("")) {
                return null;
            }
            return this._styleFactory.parseStyleDeclaration(2, style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ruleset getNonCssStyle(Object e) {
        Object object = e;
        synchronized (object) {
            if (this._attRes == null || this._styleFactory == null) {
                return null;
            }
            String style = this._attRes.getNonCssStyling(e);
            if (style == null || style.equals("")) {
                return null;
            }
            return this._styleFactory.parseStyleDeclaration(2, style);
        }
    }

    class Mapper {
        List axes;
        private HashMap pseudoSelectors;
        private List mappedSelectors;
        private HashMap children;

        Mapper(Collection selectors) {
            this.axes = new ArrayList();
            this.axes.addAll(selectors);
        }

        private Mapper() {
        }

        Mapper mapChild(Object e) {
            Mapper childMapper;
            ArrayList<Selector> childAxes = new ArrayList<Selector>();
            HashMap<String, LinkedList<Selector>> pseudoSelectors = new HashMap<String, LinkedList<Selector>>();
            LinkedList<Selector> mappedSelectors = new LinkedList<Selector>();
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < this.axes.size(); ++i) {
                Selector sel = (Selector)this.axes.get(i);
                if (sel.getAxis() == 0) {
                    childAxes.add(sel);
                } else if (sel.getAxis() == 2) {
                    throw new RuntimeException();
                }
                if (!sel.matches(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                String pseudoElement = sel.getPseudoElement();
                if (pseudoElement != null) {
                    LinkedList<Selector> l = (LinkedList<Selector>)pseudoSelectors.get(pseudoElement);
                    if (l == null) {
                        l = new LinkedList<Selector>();
                        pseudoSelectors.put(pseudoElement, l);
                    }
                    l.add(sel);
                    key.append(sel.getSelectorID()).append(":");
                    continue;
                }
                if (sel.isPseudoClass(2)) {
                    Matcher.this._visitElements.add(e);
                }
                if (sel.isPseudoClass(8)) {
                    Matcher.this._activeElements.add(e);
                }
                if (sel.isPseudoClass(4)) {
                    Matcher.this._hoverElements.add(e);
                }
                if (sel.isPseudoClass(16)) {
                    Matcher.this._focusElements.add(e);
                }
                if (!sel.matchesDynamic(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                key.append(sel.getSelectorID()).append(":");
                Selector chain = sel.getChainedSelector();
                if (chain == null) {
                    mappedSelectors.add(sel);
                    continue;
                }
                if (chain.getAxis() == 2) {
                    throw new RuntimeException();
                }
                childAxes.add(chain);
            }
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((childMapper = (Mapper)this.children.get(key.toString())) == null) {
                childMapper = new Mapper();
                childMapper.axes = childAxes;
                childMapper.pseudoSelectors = pseudoSelectors;
                childMapper.mappedSelectors = mappedSelectors;
                this.children.put(key.toString(), childMapper);
            }
            Matcher.this.link(e, childMapper);
            return childMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CascadedStyle getCascadedStyle(Object e) {
            CascadedStyle result;
            Object object = e;
            synchronized (object) {
                CascadedStyle cs = null;
                Ruleset elementStyling = Matcher.this.getElementStyle(e);
                Ruleset nonCssStyling = Matcher.this.getNonCssStyle(e);
                LinkedList propList = new LinkedList();
                if (nonCssStyling != null) {
                    propList.addAll(nonCssStyling.getPropertyDeclarations());
                }
                Iterator i = Matcher.getMatchedRulesets(this.mappedSelectors);
                while (i.hasNext()) {
                    Ruleset rs = (Ruleset)i.next();
                    propList.addAll(rs.getPropertyDeclarations());
                }
                if (elementStyling != null) {
                    propList.addAll(elementStyling.getPropertyDeclarations());
                }
                cs = propList.size() == 0 ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(propList.iterator());
                result = cs;
            }
            return result;
        }

        public CascadedStyle getPECascadedStyle(Object e, String pseudoElement) {
            Iterator si = this.pseudoSelectors.entrySet().iterator();
            if (!si.hasNext()) {
                return null;
            }
            CascadedStyle cs = null;
            List pe = (List)this.pseudoSelectors.get(pseudoElement);
            if (pe == null) {
                return null;
            }
            LinkedList propList = new LinkedList();
            Iterator i = Matcher.getSelectedRulesets(pe);
            while (i.hasNext()) {
                Ruleset rs = (Ruleset)i.next();
                propList.addAll(rs.getPropertyDeclarations());
            }
            cs = propList.size() == 0 ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(propList.iterator());
            return cs;
        }
    }
}

