/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet;

import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.xhtmlrenderer.context.CSSPageRuleAdapter;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class Ruleset {
    private int _origin;
    private List _props;
    private SelectorList sacSelectorList;
    private String _selectorText;
    private static final CSSOMParser CSOM_PARSER;

    public Ruleset(CSSStyleRule rule, int orig) {
        this(orig);
        this._selectorText = rule.getSelectorText();
        this.pullPropertiesFromDOMRule(rule);
        this.pullSelectorsFromDOMRule(rule);
    }

    public Ruleset(SelectorList selectorList, List propertyDeclarations, int orig) {
        this(orig);
        this.sacSelectorList = selectorList;
        this._props.addAll(propertyDeclarations);
    }

    private Ruleset(int orig) {
        this._origin = orig;
        this._props = new LinkedList();
    }

    public List getPropertyDeclarations() {
        return Collections.unmodifiableList(this._props);
    }

    public SelectorList getSelectorList() {
        return this.sacSelectorList;
    }

    private void pullSelectorsFromDOMRule(CSSStyleRule sacRule) {
        if (sacRule instanceof CSSPageRuleAdapter) {
            return;
        }
        this.sacSelectorList = ((CSSStyleRuleImpl)sacRule).getSelectorList();
    }

    private void pullPropertiesFromDOMRule(CSSStyleRule sacRule) {
        CSSStyleDeclaration decl = sacRule.getStyle();
        for (int i = 0; i < decl.getLength(); ++i) {
            String propName = decl.item(i);
            CSSName cssName = CSSName.getByPropertyName(propName);
            if (cssName == null) {
                XRLog.cascade("Unknown property in stylesheet: " + propName + ", skipping it.");
                continue;
            }
            try {
                Iterator iter = PropertyDeclaration.newFactory(cssName).buildDeclarations(decl, cssName, this._origin);
                while (iter.hasNext()) {
                    this._props.add((PropertyDeclaration)iter.next());
                }
                continue;
            }
            catch (Exception ex) {
                XRLog.cascade(Level.WARNING, "Property " + cssName + " could not be parsed while creating PropertyDeclarations. " + "Assigned value might be: " + decl.getPropertyValue(cssName.toString()) + ". " + "Exception was " + ex + ". Property is being IGNORED and skipped.");
            }
        }
    }

    public String getSelectorText() {
        return this._selectorText;
    }

    static {
        try {
            Object obj = Class.forName("com.steadystate.css.parser.SACParser").newInstance();
            Parser psr = (Parser)obj;
            CSOM_PARSER = new CSSOMParser(psr);
        }
        catch (Exception ex) {
            throw new XRRuntimeException("Bad!  Couldn't load the CSS parser. Everything after this will fail.");
        }
    }
}

