/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.Iterator;
import java.util.List;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;

public abstract class AbstractPropertyDeclarationFactory
implements PropertyDeclarationFactory {
    public final Iterator buildDeclarations(CSSStyleDeclaration style, CSSName cssName, int origin) {
        Object[] attr = this.extractStyleAttributes(style, cssName);
        CSSValue cssValue = (CSSValue)attr[0];
        boolean important = (Boolean)attr[1];
        CSSPrimitiveValue[] pvalues = null;
        if (cssValue.getCssValueType() == 1) {
            pvalues = new CSSPrimitiveValue[]{(CSSPrimitiveValue)cssValue};
        } else {
            CSSValueList list = (CSSValueList)cssValue;
            pvalues = new CSSPrimitiveValue[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                CSSPrimitiveValue pvalue;
                pvalues[i] = pvalue = (CSSPrimitiveValue)list.item(i);
            }
        }
        return this.doBuildDeclarations(pvalues, important, cssName, origin);
    }

    public final Iterator buildDeclarations(CSSValue cssValue, CSSName cssName, int origin, boolean important) {
        CSSPrimitiveValue[] pvalues = null;
        if (cssValue.getCssValueType() == 1) {
            pvalues = new CSSPrimitiveValue[]{(CSSPrimitiveValue)cssValue};
        } else {
            CSSValueList list = (CSSValueList)cssValue;
            pvalues = new CSSPrimitiveValue[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                CSSPrimitiveValue pvalue;
                pvalues[i] = pvalue = (CSSPrimitiveValue)list.item(i);
            }
        }
        return this.doBuildDeclarations(pvalues, important, cssName, origin);
    }

    protected abstract Iterator doBuildDeclarations(CSSPrimitiveValue[] var1, boolean var2, CSSName var3, int var4);

    protected PropertyDeclaration newPropertyDeclaration(CSSName cssName, CSSPrimitiveValue primitive, int origin, boolean important) {
        return new PropertyDeclaration(cssName, primitive, important, origin);
    }

    protected void addProperties(List declarations, CSSPrimitiveValue[] primitives, CSSName[] cssNames, int origin, boolean important) {
        for (int i = 0; i < primitives.length; ++i) {
            declarations.add(this.newPropertyDeclaration(cssNames[i], primitives[i], origin, important));
        }
    }

    protected Object[] extractStyleAttributes(CSSStyleDeclaration style, CSSName cssName) {
        CSSValue cssValue = style.getPropertyCSSValue(cssName.toString());
        Boolean important = style.getPropertyPriority(cssName.toString()).compareToIgnoreCase("important") == 0;
        return new Object[]{cssValue, important};
    }
}

