/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.css.value.FSCssValue;

public class BackgroundPositionPropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static BackgroundPositionPropertyDeclarationFactory _instance;

    private BackgroundPositionPropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        StringBuffer pos = new StringBuffer();
        for (int i = 0; i < primVals.length; ++i) {
            CSSPrimitiveValue primVal = primVals[i];
            pos.append(primVal.getCssText().trim() + " ");
        }
        pos.deleteCharAt(pos.length() - 1);
        String val = pos.toString().trim();
        val = BackgroundPositionPropertyDeclarationFactory.canonicalizeValue(val);
        FSCssValue fsCssValue = new FSCssValue(primVals[0], val);
        ArrayList<PropertyDeclaration> declarations = new ArrayList<PropertyDeclaration>(1);
        declarations.add(this.newPropertyDeclaration(cssName, fsCssValue, origin, important));
        return declarations.iterator();
    }

    static String canonicalizeValue(String val) {
        String[] vals;
        if (val.indexOf(" ") == -1) {
            val = Idents.looksLikeALength(val) ? val + " 50%" : val + " center";
        }
        if ((vals = val.split(" "))[0].equals("top") || vals[0].equals("bottom") || vals[1].equals("left") || vals[1].equals("right")) {
            val = vals[0];
            vals[0] = vals[1];
            vals[1] = val;
        }
        if (vals[0].equals("left")) {
            vals[0] = "0%";
        } else if (vals[0].equals("center")) {
            vals[0] = "50%";
        } else if (vals[0].equals("right")) {
            vals[0] = "100%";
        }
        if (vals[1].equals("top")) {
            vals[1] = "0%";
        } else if (vals[1].equals("center")) {
            vals[1] = "50%";
        } else if (vals[1].equals("bottom")) {
            vals[1] = "100%";
        }
        return vals[0] + " " + vals[1];
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new BackgroundPositionPropertyDeclarationFactory();
        }
        return _instance;
    }
}

