/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;

public class BorderPropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static BorderPropertyDeclarationFactory _instance;
    private static final CSSName[] WIDTH_PRP;
    private static final CSSName[] STYLE_PRP;
    private static final CSSName[] COLOR_PRP;
    private static final CSSName[][] LISTS;
    private static final int WIDTH_IDX;
    private static final int STYLE_IDX;
    private static final int COLOR_IDX;

    private BorderPropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        ArrayList declarations = new ArrayList();
        CSSPrimitiveValue primitive = null;
        CSSPrimitiveValue[] primitives = new CSSPrimitiveValue[4];
        CSSName[] sides = null;
        int len = primVals.length;
        for (int i = 0; i < len; ++i) {
            primitive = primVals[i];
            String val = primitive.getCssText();
            sides = Idents.looksLikeAColor(val) ? LISTS[COLOR_IDX] : (Idents.looksLikeABorderStyle(val) ? LISTS[STYLE_IDX] : LISTS[WIDTH_IDX]);
            primitives[0] = primitive;
            primitives[1] = primitive;
            primitives[2] = primitive;
            primitives[3] = primitive;
            this.addProperties(declarations, primitives, sides, origin, important);
        }
        return declarations.iterator();
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new BorderPropertyDeclarationFactory();
        }
        return _instance;
    }

    static {
        WIDTH_PRP = new CSSName[]{CSSName.BORDER_WIDTH_TOP, CSSName.BORDER_WIDTH_RIGHT, CSSName.BORDER_WIDTH_BOTTOM, CSSName.BORDER_WIDTH_LEFT};
        STYLE_PRP = new CSSName[]{CSSName.BORDER_STYLE_TOP, CSSName.BORDER_STYLE_RIGHT, CSSName.BORDER_STYLE_BOTTOM, CSSName.BORDER_STYLE_LEFT};
        COLOR_PRP = new CSSName[]{CSSName.BORDER_COLOR_TOP, CSSName.BORDER_COLOR_RIGHT, CSSName.BORDER_COLOR_BOTTOM, CSSName.BORDER_COLOR_LEFT};
        WIDTH_IDX = 0;
        STYLE_IDX = 1;
        COLOR_IDX = 2;
        LISTS = new CSSName[3][];
        BorderPropertyDeclarationFactory.LISTS[BorderPropertyDeclarationFactory.WIDTH_IDX] = WIDTH_PRP;
        BorderPropertyDeclarationFactory.LISTS[BorderPropertyDeclarationFactory.STYLE_IDX] = STYLE_PRP;
        BorderPropertyDeclarationFactory.LISTS[BorderPropertyDeclarationFactory.COLOR_IDX] = COLOR_PRP;
    }
}

