/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.css.value.FSCssValue;
import org.xhtmlrenderer.util.XRRuntimeException;

public class BorderSidePropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static BorderSidePropertyDeclarationFactory _instance;
    private static final Map PROP_EXPLODE;
    private static final int WIDTH_IDX;
    private static final int STYLE_IDX;
    private static final int COLOR_IDX;

    private BorderSidePropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        ArrayList declarations = new ArrayList();
        CSSName[] explodes = (CSSName[])PROP_EXPLODE.get(cssName);
        CSSPrimitiveValue[] primitives = null;
        CSSName[] names = null;
        if (explodes == null) {
            throw new XRRuntimeException("Found no mapping for border side property named '" + cssName + "'.");
        }
        for (int i = 0; i < primVals.length; ++i) {
            CSSPrimitiveValue primitive = primVals[i];
            String val = primitive.getCssText().trim();
            CSSName matchedProp = this.matchPropName(val, explodes);
            primitives = new CSSPrimitiveValue[]{new FSCssValue(primitive)};
            names = new CSSName[]{matchedProp};
            this.addProperties(declarations, primitives, names, origin, important);
        }
        return declarations.iterator();
    }

    private CSSName matchPropName(String val, CSSName[] explodeTo) {
        CSSName cssName = null;
        cssName = Idents.looksLikeAColor(val) ? explodeTo[COLOR_IDX] : (Idents.looksLikeABorderStyle(val) ? explodeTo[STYLE_IDX] : explodeTo[WIDTH_IDX]);
        return cssName;
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new BorderSidePropertyDeclarationFactory();
        }
        return _instance;
    }

    static {
        WIDTH_IDX = 0;
        STYLE_IDX = 1;
        COLOR_IDX = 2;
        PROP_EXPLODE = new HashMap();
        CSSName[] top = new CSSName[]{CSSName.BORDER_WIDTH_TOP, CSSName.BORDER_STYLE_TOP, CSSName.BORDER_COLOR_TOP};
        CSSName[] right = new CSSName[]{CSSName.BORDER_WIDTH_RIGHT, CSSName.BORDER_STYLE_RIGHT, CSSName.BORDER_COLOR_RIGHT};
        CSSName[] bottom = new CSSName[]{CSSName.BORDER_WIDTH_BOTTOM, CSSName.BORDER_STYLE_BOTTOM, CSSName.BORDER_COLOR_BOTTOM};
        CSSName[] left = new CSSName[]{CSSName.BORDER_WIDTH_LEFT, CSSName.BORDER_STYLE_LEFT, CSSName.BORDER_COLOR_LEFT};
        PROP_EXPLODE.put(CSSName.BORDER_TOP_SHORTHAND, top);
        PROP_EXPLODE.put(CSSName.BORDER_RIGHT_SHORTHAND, right);
        PROP_EXPLODE.put(CSSName.BORDER_BOTTOM_SHORTHAND, bottom);
        PROP_EXPLODE.put(CSSName.BORDER_LEFT_SHORTHAND, left);
    }
}

