/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet.factory;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.sheet.factory.AbstractPropertyDeclarationFactory;
import org.xhtmlrenderer.css.sheet.factory.PropertyDeclarationFactory;
import org.xhtmlrenderer.css.value.FSCssValue;

public class OutlinePropertyDeclarationFactory
extends AbstractPropertyDeclarationFactory {
    private static OutlinePropertyDeclarationFactory _instance;

    private OutlinePropertyDeclarationFactory() {
    }

    protected Iterator doBuildDeclarations(CSSPrimitiveValue[] primVals, boolean important, CSSName cssName, int origin) {
        ArrayList declarations = new ArrayList();
        CSSPrimitiveValue primitive = null;
        CSSPrimitiveValue[] primitives = new CSSPrimitiveValue[1];
        CSSName[] names = new CSSName[1];
        for (int i = 0; i < primVals.length; ++i) {
            primitive = primVals[i];
            String val = primitive.getCssText().trim();
            CSSName expPropName = null;
            if (Idents.looksLikeAColor(val)) {
                expPropName = CSSName.OUTLINE_COLOR;
                primitive = new FSCssValue(primitive);
            } else {
                expPropName = Idents.looksLikeABorderStyle(val) ? CSSName.OUTLINE_STYLE : CSSName.OUTLINE_WIDTH;
            }
            names[0] = expPropName;
            primitives[0] = primitive;
            this.addProperties(declarations, primitives, names, origin, important);
        }
        return declarations.iterator();
    }

    public static synchronized PropertyDeclarationFactory instance() {
        if (_instance == null) {
            _instance = new OutlinePropertyDeclarationFactory();
        }
        return _instance;
    }
}

