/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import java.awt.Color;
import org.w3c.dom.css.RGBColor;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.DerivedValue;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.util.ConversionUtil;
import org.xhtmlrenderer.util.XRRuntimeException;

public class ColorValue
extends DerivedValue {
    private static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    private static final String TRANSPARENT = "transparent";
    private Color _derivedColor;

    public ColorValue(CalculatedStyle style, CSSName name, short cssSACUnitType, String cssText, String cssStringValue, RGBColor rgbColor) {
        super(style, name, cssSACUnitType, cssText, cssStringValue);
        this._derivedColor = this.deriveColor(name, rgbColor);
    }

    private ColorValue(CalculatedStyle style, CSSName name, short cssSACUnitType, String cssText, String cssStringValue, Color color) {
        super(style, name, cssSACUnitType, cssText, cssStringValue);
        this._derivedColor = color;
    }

    public FSDerivedValue copyOf(CSSName cssName) {
        return new ColorValue(this.getStyle(), cssName, this.getCssSacUnitType(), this.getStringValue(), this.getStringValue(), this._derivedColor);
    }

    public Color asColor() {
        return this._derivedColor;
    }

    private Color deriveColor(CSSName cssName, RGBColor rgbColor) {
        Color color = null;
        String str = this.getStringValue();
        try {
            color = TRANSPARENT.equals(str) ? COLOR_TRANSPARENT : (this.getCssSacUnitType() == 25 && rgbColor != null ? ConversionUtil.rgbToColor(rgbColor) : Color.decode(str));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new XRRuntimeException("Could not return '" + cssName + "' in a DerivedValue as a Color (value '" + str + "'). ", ex);
        }
        return color;
    }
}

