/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.css.RGBColor;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.ColorValue;
import org.xhtmlrenderer.css.style.derived.InheritedLength;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.NumberValue;
import org.xhtmlrenderer.css.style.derived.PointValue;
import org.xhtmlrenderer.css.style.derived.StringValue;

public class DerivedValueFactory {
    private static final List COLOR_PROPERTIES;
    private static final List STRING_PROPERTIES;
    private static final List IDENT_PROPERTIES;
    private static final Map CACHED_COLORS;

    public static FSDerivedValue newDerivedValue(CalculatedStyle style, CSSName cssName, short cssSACUnitType, String cssText, String cssStringValue, RGBColor rgbColor) {
        FSDerivedValue val = null;
        boolean declaredInherit = cssText.equals("inherit");
        if (declaredInherit) {
            val = style.getParent().isLengthValue(cssName) ? new InheritedLength((LengthValue)style.getParent().valueByName(cssName)) : style.getParent().copyOf(cssName);
        } else if (cssName == CSSName.BACKGROUND_POSITION) {
            val = new PointValue(style, cssName, cssSACUnitType, cssText, cssStringValue);
        } else if (COLOR_PROPERTIES.contains(cssName)) {
            val = DerivedValueFactory.newColor(style, cssName, cssSACUnitType, cssText, cssStringValue, rgbColor);
        } else if (STRING_PROPERTIES.contains(cssName)) {
            val = new StringValue(style, cssName, cssSACUnitType, cssText, cssStringValue);
        } else if (cssName != CSSName.FONT_WEIGHT && Idents.looksLikeALength(cssText)) {
            val = new LengthValue(style, cssName, cssSACUnitType, cssText, cssStringValue);
        } else if (cssName != CSSName.FONT_WEIGHT && Idents.looksLikeANumber(cssText)) {
            val = new NumberValue(style, cssName, cssSACUnitType, cssText, cssStringValue);
        } else if (IDENT_PROPERTIES.contains(cssName) || IdentValue.looksLikeIdent(cssText)) {
            val = IdentValue.getByIdentString(cssText);
        } else {
            throw new RuntimeException("Can't determine the dervived value type to use for property named '" + cssName + "' with value " + cssText);
        }
        return val;
    }

    private static FSDerivedValue newColor(CalculatedStyle style, CSSName cssName, short cssSACUnitType, String cssText, String cssStringValue, RGBColor rgbColor) {
        FSDerivedValue val;
        if (rgbColor == null) {
            val = (FSDerivedValue)CACHED_COLORS.get(cssText);
            if (val == null) {
                val = new ColorValue(style, cssName, cssSACUnitType, cssText, cssStringValue, rgbColor);
                CACHED_COLORS.put(cssText, val);
            }
        } else {
            val = new ColorValue(style, cssName, cssSACUnitType, cssText, cssStringValue, rgbColor);
        }
        return val;
    }

    static {
        CACHED_COLORS = new HashMap();
        COLOR_PROPERTIES = new ArrayList();
        COLOR_PROPERTIES.add(CSSName.COLOR);
        COLOR_PROPERTIES.add(CSSName.BACKGROUND_COLOR);
        COLOR_PROPERTIES.add(CSSName.OUTLINE_COLOR);
        COLOR_PROPERTIES.add(CSSName.BORDER_COLOR_TOP);
        COLOR_PROPERTIES.add(CSSName.BORDER_COLOR_RIGHT);
        COLOR_PROPERTIES.add(CSSName.BORDER_COLOR_BOTTOM);
        COLOR_PROPERTIES.add(CSSName.BORDER_COLOR_LEFT);
        STRING_PROPERTIES = new ArrayList();
        STRING_PROPERTIES.add(CSSName.FONT_FAMILY);
        STRING_PROPERTIES.add(CSSName.BACKGROUND_IMAGE);
        STRING_PROPERTIES.add(CSSName.LIST_STYLE_IMAGE);
        STRING_PROPERTIES.add(CSSName.CONTENT);
        STRING_PROPERTIES.add(CSSName.FS_MOVE_TO_FLOW);
        STRING_PROPERTIES.add(CSSName.FS_FLOW_TOP);
        STRING_PROPERTIES.add(CSSName.FS_FLOW_RIGHT);
        STRING_PROPERTIES.add(CSSName.FS_FLOW_BOTTOM);
        STRING_PROPERTIES.add(CSSName.FS_FLOW_LEFT);
        IDENT_PROPERTIES = new ArrayList();
        IDENT_PROPERTIES.add(CSSName.BACKGROUND_ATTACHMENT);
        IDENT_PROPERTIES.add(CSSName.BACKGROUND_REPEAT);
        IDENT_PROPERTIES.add(CSSName.BORDER_COLLAPSE);
        IDENT_PROPERTIES.add(CSSName.BORDER_STYLE_BOTTOM);
        IDENT_PROPERTIES.add(CSSName.BORDER_STYLE_LEFT);
        IDENT_PROPERTIES.add(CSSName.BORDER_STYLE_RIGHT);
        IDENT_PROPERTIES.add(CSSName.BORDER_STYLE_TOP);
        IDENT_PROPERTIES.add(CSSName.DISPLAY);
        IDENT_PROPERTIES.add(CSSName.FLOAT);
        IDENT_PROPERTIES.add(CSSName.FONT_STYLE);
        IDENT_PROPERTIES.add(CSSName.FONT_VARIANT);
        IDENT_PROPERTIES.add(CSSName.FONT_WEIGHT);
        IDENT_PROPERTIES.add(CSSName.LIST_STYLE_TYPE);
        IDENT_PROPERTIES.add(CSSName.POSITION);
        IDENT_PROPERTIES.add(CSSName.TEXT_DECORATION);
        IDENT_PROPERTIES.add(CSSName.TEXT_TRANSFORM);
        IDENT_PROPERTIES.add(CSSName.VERTICAL_ALIGN);
        IDENT_PROPERTIES.add(CSSName.WHITE_SPACE);
    }
}

