/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.ValueConstants;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.DerivedValue;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class LengthValue
extends DerivedValue {
    private static final Pattern CSS_LENGTH_PATTERN = Pattern.compile("(-?\\d{1,10}(\\.?\\d{0,10})?)((em)|(ex)|(px)|(%)|(in)|(cm)|(mm)|(pt)|(pc))?");
    private static final int MM__PER__CM = 10;
    private static final float CM__PER__IN = 2.54f;
    private static final float PT__PER__IN = 0.013888889f;
    private static final float PC__PER__PT = 12.0f;
    private float _lengthAsFloat;
    private short _lengthPrimitiveType;

    protected LengthValue() {
    }

    public LengthValue(CalculatedStyle style, CSSName name, short cssSACUnitType, String cssText, String cssStringValue) {
        super(style, name, cssSACUnitType, cssText, cssStringValue);
        this.pullLengthValueParts(name);
    }

    public float asFloat() {
        return this._lengthAsFloat;
    }

    public FSDerivedValue copyOf(CSSName cssName) {
        return new LengthValue(this.getStyle(), cssName, this.getCssSacUnitType(), this.getStringValue(), this.getStringValue());
    }

    public float getFloatProportionalTo(CSSName cssName, float baseValue, CssContext ctx) {
        return LengthValue.calcFloatProportionalValue(this.getStyle(), cssName, this.getStringValue(), this._lengthAsFloat, this._lengthPrimitiveType, baseValue, ctx);
    }

    protected static Matcher getLengthMatcher(String len) {
        return CSS_LENGTH_PATTERN.matcher(len);
    }

    public boolean hasAbsoluteUnit() {
        return ValueConstants.isAbsoluteUnit(this.getCssSacUnitType());
    }

    private void pullLengthValueParts(CSSName cssName) {
        Matcher m = CSS_LENGTH_PATTERN.matcher(this.getStringValue());
        String lengthAsString = null;
        if (!m.matches()) {
            throw new XRRuntimeException("Could not extract length for " + cssName + " from " + this.getStringValue() + " using " + CSS_LENGTH_PATTERN);
        }
        lengthAsString = m.group(1);
        this._lengthAsFloat = new Float(lengthAsString).floatValue();
        this._lengthPrimitiveType = ValueConstants.sacPrimitiveTypeForString(m.group(3));
        if (lengthAsString == null) {
            throw new XRRuntimeException("Could not extract length for " + cssName + " from " + this.getStringValue() + "; is null, using " + CSS_LENGTH_PATTERN);
        }
    }

    protected static float calcFloatProportionalValue(CalculatedStyle style, CSSName cssName, String stringValue, float relVal, short primitiveType, float baseValue, CssContext ctx) {
        float absVal = Float.MIN_VALUE;
        switch (primitiveType) {
            case 5: {
                absVal = relVal * (float)ctx.getDotsPerPixel();
                break;
            }
            case 8: {
                absVal = relVal * 2.54f * 10.0f / ctx.getMmPerDot();
                break;
            }
            case 6: {
                absVal = relVal * 10.0f / ctx.getMmPerDot();
                break;
            }
            case 7: {
                absVal = relVal / ctx.getMmPerDot();
                break;
            }
            case 9: {
                absVal = relVal * 0.013888889f * 2.54f * 10.0f / ctx.getMmPerDot();
                break;
            }
            case 10: {
                absVal = relVal * 12.0f * 0.013888889f * 2.54f * 10.0f / ctx.getMmPerDot();
                break;
            }
            case 3: {
                FontSpecification parentFont;
                if (cssName == CSSName.FONT_SIZE) {
                    parentFont = style.getParent().getFont(ctx);
                    absVal = relVal * parentFont.size;
                    break;
                }
                absVal = relVal * style.getFont((CssContext)ctx).size;
                break;
            }
            case 4: {
                FontSpecification parentFont;
                if (cssName == CSSName.FONT_SIZE) {
                    parentFont = style.getParent().getFont(ctx);
                    float xHeight = ctx.getXHeight(parentFont);
                    xHeight = relVal * xHeight;
                    absVal = LengthValue.getFontSizeForXHeight(style, ctx, xHeight);
                    break;
                }
                FontSpecification font = style.getFont(ctx);
                float xHeight = ctx.getXHeight(font);
                absVal = relVal * xHeight;
                break;
            }
            case 2: {
                FontSpecification font;
                FontSpecification parentFont;
                if (cssName == CSSName.VERTICAL_ALIGN) {
                    relVal = style.getParent().getLineHeight(ctx);
                } else if (cssName == CSSName.FONT_SIZE) {
                    parentFont = style.getParent().getFont(ctx);
                    baseValue = ctx.getFontSize2D(parentFont);
                } else if (cssName == CSSName.LINE_HEIGHT) {
                    font = style.getFont(ctx);
                    baseValue = ctx.getFontSize2D(font);
                }
                absVal = relVal / 100.0f * baseValue;
                break;
            }
            default: {
                XRLog.cascade(Level.SEVERE, "Asked to convert " + cssName + " from relative to absolute, " + " don't recognize the datatype " + "'" + ValueConstants.stringForSACPrimitiveType(primitiveType) + "' " + primitiveType + "(" + stringValue + ")");
            }
        }
        if (cssName == CSSName.FONT_SIZE) {
            XRLog.cascade(Level.FINEST, cssName + ", relative= " + relVal + " (" + stringValue + "), absolute= " + absVal);
        } else {
            XRLog.cascade(Level.FINEST, cssName + ", relative= " + relVal + " (" + stringValue + "), absolute= " + absVal + " using base=" + baseValue);
        }
        double d = Math.round((double)absVal);
        absVal = new Float(d).floatValue();
        return absVal;
    }

    private static float getFontSizeForXHeight(CalculatedStyle style, CssContext ctx, float xHeight) {
        FontSpecification f = new FontSpecification();
        f.fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
        f.families = style.asStringArray(CSSName.FONT_FAMILY);
        f.fontStyle = style.getIdent(CSSName.FONT_STYLE);
        f.variant = style.getIdent(CSSName.FONT_VARIANT);
        return ctx.getFontSizeForXHeight(style.getParent().getFont(ctx), f, xHeight);
    }
}

