/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import java.awt.Point;
import java.util.regex.Matcher;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.ValueConstants;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.DerivedValue;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.util.XRRuntimeException;

public class PointValue
extends DerivedValue {
    private float _xPos;
    private short _xType;
    private float _yPos;
    private short _yType;
    private boolean _isAbsolute;
    private Point _point;

    public PointValue(CalculatedStyle style, CSSName name, short cssSACUnitType, String cssText, String cssStringValue) {
        super(style, name, cssSACUnitType, cssText, cssStringValue);
        if (name == CSSName.BACKGROUND_POSITION) {
            this.pullPointValuesForBGPos(cssText);
        }
    }

    public FSDerivedValue copyOf(CSSName cssName) {
        return new PointValue(this.getStyle(), cssName, this.getCssSacUnitType(), this.getStringValue(), this.getStringValue());
    }

    public Point asPoint(CSSName cssName, float parentWidth, float parentHeight, CssContext ctx) {
        Point pt = null;
        if (this._isAbsolute) {
            if (this._point == null) {
                this._point = new Point();
                float xF = LengthValue.calcFloatProportionalValue(this.getStyle(), cssName, this.getStringValue(), this._xPos, this._xType, parentWidth, ctx);
                float yF = LengthValue.calcFloatProportionalValue(this.getStyle(), cssName, this.getStringValue(), this._yPos, this._yType, parentHeight, ctx);
                this._point.setLocation(xF, yF);
            }
            pt = this._point;
        } else {
            pt = new Point();
            float xF = LengthValue.calcFloatProportionalValue(this.getStyle(), cssName, this.getStringValue(), this._xPos, this._xType, parentWidth, ctx);
            float yF = LengthValue.calcFloatProportionalValue(this.getStyle(), cssName, this.getStringValue(), this._yPos, this._yType, parentHeight, ctx);
            pt.setLocation(xF, yF);
        }
        return pt;
    }

    private void pullPointValuesForBGPos(String cssText) {
        String[] pos = cssText.split(" ");
        try {
            Matcher m = LengthValue.getLengthMatcher(pos[0]);
            m.matches();
            String xAsString = m.group(1);
            this._xPos = new Float(xAsString).floatValue();
            this._xType = ValueConstants.sacPrimitiveTypeForString(m.group(3));
            m = LengthValue.getLengthMatcher(pos[1]);
            m.matches();
            String yAsString = m.group(1);
            this._yPos = new Float(yAsString).floatValue();
            this._yType = ValueConstants.sacPrimitiveTypeForString(m.group(3));
            this._isAbsolute = ValueConstants.isAbsoluteUnit(this._xType) && ValueConstants.isAbsoluteUnit(this._yType);
        }
        catch (Exception ex) {
            StringBuffer msg = new StringBuffer();
            msg.append("background-position: failed to convert '" + cssText + "' into a Point. ");
            msg.append("Property value (as text) was split into " + pos.length + " values for positioning. ");
            if (pos.length >= 1) {
                msg.append(" background-position x-pos is " + pos[0]);
            }
            if (pos.length == 2) {
                msg.append(" background-position y-pos is " + pos[1]);
            }
            throw new XRRuntimeException(msg.toString());
        }
    }
}

