/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LineBreakContext;
import org.xhtmlrenderer.render.FSFont;

public class Breaker {
    public static void breakFirstLetter(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c);
        context.setEnd(Breaker.getFirstLetterEnd(context.getMaster(), context.getStart()));
        context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
        if (context.getWidth() > avail) {
            context.setNeedsNewLine(true);
            context.setUnbreakable(true);
        }
    }

    private static int getFirstLetterEnd(String text, int start) {
        char c;
        int type;
        int i;
        for (i = start; i < text.length() && ((type = Character.getType(c = text.charAt(i))) == 21 || type == 22 || type == 29 || type == 30 || type == 24); ++i) {
        }
        if (i < text.length()) {
            ++i;
        }
        return i;
    }

    public static void breakText(LayoutContext c, LineBreakContext context, int avail, IdentValue whitespace, CalculatedStyle style) {
        int graphicsLength;
        FSFont font = style.getFSFont(c);
        if (whitespace == IdentValue.NOWRAP) {
            context.setEnd(context.getLast());
            context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            return;
        }
        if (whitespace == IdentValue.PRE || whitespace == IdentValue.PRE_WRAP || whitespace == IdentValue.PRE_LINE) {
            int n = context.getStartSubstring().indexOf("\n");
            if (n > -1) {
                context.setEnd(context.getStart() + n + 1);
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
                context.setNeedsNewLine(true);
            } else if (whitespace == IdentValue.PRE) {
                context.setEnd(context.getLast());
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            }
        }
        if (whitespace == IdentValue.PRE) {
            return;
        }
        String currentString = context.getStartSubstring();
        int left = 0;
        int right = currentString.indexOf(" ", left + 1);
        int lastWrap = 0;
        int lastGraphicsLength = 0;
        for (graphicsLength = 0; right > 0 && graphicsLength <= avail; graphicsLength += c.getTextRenderer().getWidth(c.getFontContext(), font, currentString.substring(left, right))) {
            lastGraphicsLength = graphicsLength;
            lastWrap = left;
            left = right;
            right = currentString.indexOf(" ", left + 1);
        }
        if (graphicsLength <= avail) {
            lastWrap = left;
            lastGraphicsLength = graphicsLength;
            graphicsLength += c.getTextRenderer().getWidth(c.getFontContext(), font, currentString.substring(left));
        }
        if (graphicsLength <= avail) {
            context.setWidth(graphicsLength);
            context.setEnd(context.getMaster().length());
            return;
        }
        context.setNeedsNewLine(true);
        if (lastWrap != 0) {
            context.setEnd(context.getStart() + lastWrap);
            context.setWidth(lastGraphicsLength);
        } else {
            if (left == 0) {
                left = currentString.length();
            }
            context.setEnd(context.getStart() + left);
            context.setUnbreakable(true);
            if (left == 0) {
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            } else {
                context.setWidth(graphicsLength);
            }
        }
    }
}

