/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Rectangle;
import java.util.Stack;
import java.util.logging.Level;
import org.xhtmlrenderer.context.ContentFunctionFactory;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.EmptyStyle;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutState;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.layout.StyleTracker;
import org.xhtmlrenderer.layout.content.Content;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.RenderQueue;
import org.xhtmlrenderer.swing.RootPanel;
import org.xhtmlrenderer.util.XRLog;

public class LayoutContext
implements CssContext {
    private SharedContext sharedContext;
    private RenderQueue renderQueue;
    private boolean shrinkWrap = false;
    private Layer rootLayer;
    private StyleTracker firstLines;
    private StyleTracker firstLetters;
    private MarkerData currentMarkerData;
    private Stack styleStack;
    private Content parentContent;
    private Stack bfcs;
    private Stack layers;
    private Rectangle extents;
    int renderIndex = 0;
    private boolean shouldStop = false;
    private boolean layingOutTable = false;
    private ReplacedElementFactory replacedElementFactory;
    private FontContext fontContext;
    private ContentFunctionFactory contentFunctionFactory = new ContentFunctionFactory();

    public TextRenderer getTextRenderer() {
        return this.sharedContext.getTextRenderer();
    }

    public StyleReference getCss() {
        return this.sharedContext.getCss();
    }

    public RootPanel getCanvas() {
        return this.sharedContext.getCanvas();
    }

    public Rectangle getFixedRectangle() {
        return this.sharedContext.getFixedRectangle();
    }

    public NamespaceHandler getNamespaceHandler() {
        return this.sharedContext.getNamespaceHandler();
    }

    public boolean shrinkWrap() {
        return this.shrinkWrap;
    }

    public void setShrinkWrap() {
        this.shrinkWrap = true;
    }

    public void unsetShrinkWrap() {
        this.shrinkWrap = false;
    }

    LayoutContext(SharedContext sharedContext, Rectangle extents) {
        this.sharedContext = sharedContext;
        this.bfcs = new Stack();
        this.layers = new Stack();
        this.styleStack = new Stack();
        this.styleStack.push(new EmptyStyle());
        this.setExtents(extents);
        this.firstLines = new StyleTracker();
        this.firstLetters = new StyleTracker();
    }

    public void reInit(CalculatedStyle currentStyle) {
        this.firstLines = new StyleTracker();
        this.firstLetters = new StyleTracker();
        this.currentMarkerData = null;
        this.styleStack = new Stack();
        this.styleStack.push(new EmptyStyle());
        this.styleStack.push(currentStyle);
        this.parentContent = null;
        this.bfcs = new Stack();
        this.extents = null;
    }

    public LayoutState captureLayoutState() {
        LayoutState result = new LayoutState();
        result.setFirstLines(this.firstLines);
        result.setFirstLetters(this.firstLetters);
        result.setCurrentMarkerData(this.currentMarkerData);
        result.setStyleStack(this.styleStack);
        result.setParentContent(this.parentContent);
        result.setBFCs(this.bfcs);
        result.setExtents(this.extents);
        return result;
    }

    public void restoreLayoutState(LayoutState layoutState) {
        this.firstLines = layoutState.getFirstLines();
        this.firstLetters = layoutState.getFirstLetters();
        this.currentMarkerData = layoutState.getCurrentMarkerData();
        this.styleStack = layoutState.getStyleStack();
        this.parentContent = layoutState.getParentContent();
        this.bfcs = layoutState.getBFCs();
        this.extents = layoutState.getExtents();
    }

    public LayoutState copyStateForRelayout() {
        LayoutState result = new LayoutState();
        result.setFirstLetters(this.firstLetters.copyOf());
        result.setFirstLines(this.firstLines.copyOf());
        result.setCurrentMarkerData(this.currentMarkerData);
        return result;
    }

    public void restoreStateForRelayout(LayoutState layoutState) {
        this.firstLines = layoutState.getFirstLines();
        this.firstLetters = layoutState.getFirstLetters();
        this.currentMarkerData = layoutState.getCurrentMarkerData();
    }

    public void pushStyle(CascadedStyle s) {
        CalculatedStyle parent = (CalculatedStyle)this.styleStack.peek();
        CalculatedStyle derived = parent.deriveStyle(s);
        this.styleStack.push(derived);
    }

    public void popStyle() {
        if (this.isStylesAllPopped()) {
            XRLog.general(Level.SEVERE, "Trying to pop base empty style");
        } else {
            this.styleStack.pop();
        }
    }

    public CalculatedStyle getCurrentStyle() {
        return (CalculatedStyle)this.styleStack.peek();
    }

    public boolean isStylesAllPopped() {
        return this.styleStack.size() == 1;
    }

    public BlockFormattingContext getBlockFormattingContext() {
        return (BlockFormattingContext)this.bfcs.peek();
    }

    public void pushBFC(BlockFormattingContext bfc) {
        this.bfcs.push(bfc);
    }

    public void popBFC() {
        this.bfcs.pop();
    }

    public void pushLayer(Box master) {
        Layer layer = null;
        if (this.rootLayer == null) {
            this.rootLayer = layer = new Layer(master);
        } else {
            Layer parent = this.getLayer();
            if (master.getStyle().isFixed() || master.getStyle().isAlternateFlow()) {
                while (parent.getParent() != null) {
                    parent = parent.getParent();
                }
            }
            layer = new Layer(parent, master);
            parent.addChild(layer);
        }
        this.pushLayer(layer);
    }

    public void pushLayer(Layer layer) {
        this.layers.push(layer);
    }

    public void popLayer() {
        Layer layer = this.getLayer();
        layer.finish(this);
        this.layers.pop();
    }

    public Layer getLayer() {
        return (Layer)this.layers.peek();
    }

    public Layer getRootLayer() {
        return this.rootLayer;
    }

    public void setExtents(Rectangle rect) {
        this.extents = rect;
        if (this.extents.width < 1) {
            XRLog.exception("width < 1");
            this.extents.width = 1;
        }
    }

    public Rectangle getExtents() {
        return this.extents;
    }

    public Rectangle shrinkExtents(int dw, int dh) {
        Rectangle result = this.getExtents();
        Rectangle rect = new Rectangle(0, 0, this.getExtents().width - dw, this.getExtents().height - dh);
        this.setExtents(rect);
        return result;
    }

    public void translate(int x, int y) {
        this.getBlockFormattingContext().translate(x, y);
    }

    public boolean shouldStop() {
        return this.shouldStop;
    }

    public void stopRendering() {
        this.shouldStop = true;
    }

    public String toString() {
        return "Context: extents = (" + this.extents.x + "," + this.extents.y + ") -> (" + this.extents.width + "x" + this.extents.height + ")";
    }

    public void addIDBox(String id, Box box) {
        this.sharedContext.addIDBox(id, box);
    }

    public void addNamedAnchor(String name, Box box) {
        this.sharedContext.addNamedAnchor(name, box);
    }

    public void removeNamedAnchor(String name) {
        this.sharedContext.removeNamedAnchor(name);
    }

    public boolean isInteractive() {
        return this.sharedContext.isInteractive();
    }

    public Content getParentContent() {
        return this.parentContent;
    }

    public void setParentContent(Content parent) {
        this.parentContent = parent;
    }

    public RenderQueue getRenderQueue() {
        return this.renderQueue;
    }

    public void setRenderQueue(RenderQueue renderQueue) {
        this.renderQueue = renderQueue;
    }

    public boolean isRenderQueueAvailable() {
        return this.renderQueue != null;
    }

    public int getNewRenderIndex() {
        return this.renderIndex++;
    }

    public float getMmPerDot() {
        return this.sharedContext.getMmPerPx();
    }

    public int getDotsPerPixel() {
        return this.sharedContext.getDotsPerPixel();
    }

    public float getFontSize2D(FontSpecification font) {
        return this.sharedContext.getFont(font).getSize2D();
    }

    public float getXHeight(FontSpecification parentFont) {
        return this.sharedContext.getXHeight(this.getFontContext(), parentFont);
    }

    public float getFontSizeForXHeight(FontSpecification parent, FontSpecification desired, float xHeight) {
        return this.sharedContext.getFontSizeForXHeight(this.getFontContext(), parent, desired, xHeight);
    }

    public FSFont getFont(FontSpecification font) {
        return this.sharedContext.getFont(font);
    }

    public UserAgentCallback getUac() {
        return this.sharedContext.getUac();
    }

    public boolean isPrint() {
        return this.sharedContext.isPrint();
    }

    public StyleTracker getFirstLinesTracker() {
        return this.firstLines;
    }

    public StyleTracker getFirstLettersTracker() {
        return this.firstLetters;
    }

    public MarkerData getCurrentMarkerData() {
        return this.currentMarkerData;
    }

    public void setCurrentMarkerData(MarkerData currentMarkerData) {
        this.currentMarkerData = currentMarkerData;
    }

    public boolean isLayingOutTable() {
        return this.layingOutTable;
    }

    public void setLayingOutTable(boolean layingOutTable) {
        this.layingOutTable = layingOutTable;
    }

    public ReplacedElementFactory getReplacedElementFactory() {
        return this.replacedElementFactory;
    }

    public void setReplacedElementFactory(ReplacedElementFactory replacedElementFactory) {
        this.replacedElementFactory = replacedElementFactory;
    }

    public FontContext getFontContext() {
        return this.fontContext;
    }

    public void setFontContext(FontContext fontContext) {
        this.fontContext = fontContext;
    }

    public void initializeStyles(CalculatedStyle c) {
        this.styleStack = new Stack();
        this.styleStack.push(c);
    }

    public ContentFunctionFactory getContentFunctionFactory() {
        return this.contentFunctionFactory;
    }
}

