/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.content.AbsolutelyPositionedContent;
import org.xhtmlrenderer.layout.content.AnonymousBlockContent;
import org.xhtmlrenderer.layout.content.BlockContent;
import org.xhtmlrenderer.layout.content.CachingContent;
import org.xhtmlrenderer.layout.content.CollapsableContent;
import org.xhtmlrenderer.layout.content.Content;
import org.xhtmlrenderer.layout.content.ContentUtil;
import org.xhtmlrenderer.layout.content.FloatedBlockContent;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.Style;

public class VerticalMarginCollapser {
    private static final int DIR_DOWN = 1;
    private static final int DIR_UP = 2;

    public static void collapseVerticalMargins(LayoutContext c, Box block, Content content, float parentWidth) {
        if (content instanceof CollapsableContent) {
            boolean returnImmediately;
            List adjoining;
            Element elem = content.getElement();
            if (elem.getParentNode().getNodeType() == 9 || elem.getParentNode().getParentNode().getNodeType() == 9) {
                return;
            }
            CollapsableContent collapsableContent = (CollapsableContent)content;
            if (!collapsableContent.isCollapsed() && (adjoining = VerticalMarginCollapser.areMarginsAdjoining(c, collapsableContent, parentWidth)) != null && (returnImmediately = VerticalMarginCollapser.collapseInBetweenAdjoining(c, block, collapsableContent, adjoining))) {
                return;
            }
            Style style = block.getStyle();
            if (collapsableContent.isTopMarginCollapsed()) {
                style.setMarginTopOverride(0.0f);
            } else if (VerticalMarginCollapser.mayCollapseInto(c, collapsableContent)) {
                Float collapsedTopMargin = VerticalMarginCollapser.collapseTopMargin(c, collapsableContent, parentWidth);
                if (collapsedTopMargin != null) {
                    style.setMarginTopOverride(collapsedTopMargin.intValue());
                }
            } else {
                Float collapsedTopMargin = VerticalMarginCollapser.calculateCollapsedTop(c, content, parentWidth);
                style.setMarginTopOverride(collapsedTopMargin.intValue());
            }
            if (collapsableContent.isBottomMarginCollapsed()) {
                style.setMarginBottomOverride(0.0f);
            } else if (VerticalMarginCollapser.mayCollapseInto(c, collapsableContent)) {
                Float collapsedBottomMargin = VerticalMarginCollapser.collapseBottomMargin(c, collapsableContent, parentWidth);
                if (collapsedBottomMargin != null) {
                    style.setMarginBottomOverride(collapsedBottomMargin.intValue());
                }
            } else {
                Float collapsedBottomMargin = VerticalMarginCollapser.calculateAdjustedMarginBottom(c, content, parentWidth);
                style.setMarginBottomOverride(collapsedBottomMargin.intValue());
            }
        }
    }

    private static boolean collapseInBetweenAdjoining(LayoutContext c, Box block, CollapsableContent content, List adjoining) {
        CollapsedMarginPair result = VerticalMarginCollapser.collapseAdjoining(content.getMarginToCollapse(), adjoining);
        CachingContent parent = (CachingContent)c.getParentContent();
        Content sibling = parent.getNextInFlowSibling(c, content);
        if (sibling != null && sibling instanceof CollapsableContent) {
            ((CollapsableContent)sibling).setMarginToCollapse(result);
            return false;
        }
        Style style = block.getStyle();
        style.setMarginTopOverride(0.0f);
        style.setMarginBottomOverride(result.getValue());
        return true;
    }

    private static boolean hasTopBorderOrPadding(LayoutContext c, float parentWidth) {
        BorderPropertySet width = c.getCurrentStyle().getBorder(c);
        RectPropertySet padding = c.getCurrentStyle().getPaddingRect(parentWidth, parentWidth, c);
        return (int)width.top() != 0 || (int)padding.top() != 0;
    }

    private static boolean hasBottomBorderOrPadding(LayoutContext c, float parentWidth) {
        BorderPropertySet width = c.getCurrentStyle().getBorder(c);
        RectPropertySet padding = c.getCurrentStyle().getPaddingRect(parentWidth, parentWidth, c);
        return (int)width.bottom() != 0 || (int)padding.bottom() != 0;
    }

    private static Float collapseTopMargin(LayoutContext c, CachingContent content, float parentWidth) {
        if (content instanceof BlockContent) {
            CollapsedMarginPair saved = ((BlockContent)content).getMarginToCollapse();
            if (VerticalMarginCollapser.hasTopBorderOrPadding(c, parentWidth)) {
                return VerticalMarginCollapser.calculateCollapsedTop(c, content, parentWidth);
            }
            ArrayList<CollapsingMargin> collapsed = new ArrayList<CollapsingMargin>();
            VerticalMarginCollapser.collapseTopMarginHelper(c, content, collapsed, parentWidth);
            if (collapsed.size() == 0) {
                return VerticalMarginCollapser.calculateCollapsedTop(c, content, parentWidth);
            }
            Iterator i = collapsed.iterator();
            while (i.hasNext()) {
                CollapsingMargin margin = (CollapsingMargin)i.next();
                margin.content.setTopMarginCollapsed(true);
            }
            CollapsingMargin top = new CollapsingMargin();
            top.content = (CollapsableContent)content;
            top.marginWidth = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_TOP, parentWidth, c);
            collapsed.add(top);
            return new Float(VerticalMarginCollapser.calculateCollapsedMargin(saved, collapsed).getValue());
        }
        return null;
    }

    private static void collapseTopMarginHelper(LayoutContext c, CachingContent content, List collapsed, float parentWidth) {
        List children = content.getChildContent(c);
        Object target = null;
        Iterator i = children.iterator();
        while (i.hasNext() && ContentUtil.isNotInFlow(target = i.next())) {
        }
        if (target instanceof CollapsableContent) {
            CollapsableContent targetContent = target;
            float nextParentWidth = VerticalMarginCollapser.adjustWidth(parentWidth, c);
            targetContent = VerticalMarginCollapser.collapseAdjoiningIntervening(c, content, nextParentWidth, targetContent, collapsed, 1);
            if (targetContent == null) {
                return;
            }
            c.pushStyle(targetContent.getStyle());
            CollapsingMargin margin = new CollapsingMargin();
            margin.content = targetContent;
            margin.marginWidth = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_TOP, nextParentWidth, c);
            collapsed.add(margin);
            if (!VerticalMarginCollapser.hasTopBorderOrPadding(c, nextParentWidth) && VerticalMarginCollapser.mayCollapseInto(c, targetContent)) {
                VerticalMarginCollapser.collapseTopMarginHelper(c, targetContent, collapsed, nextParentWidth);
            }
            c.popStyle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CollapsableContent collapseAdjoiningIntervening(LayoutContext c, CachingContent parent, float parentWidth, CollapsableContent target, List collapsed, int direction) {
        CollapsableContent currentTarget = target;
        while (true) {
            c.pushStyle(currentTarget.getStyle());
            try {
                List adjoining = VerticalMarginCollapser.areMarginsAdjoining(c, currentTarget, parentWidth);
                if (adjoining != null) {
                    CollapsedMarginPair pair = VerticalMarginCollapser.collapseAdjoining(null, adjoining);
                    CollapsingMargin top = new CollapsingMargin();
                    top.content = currentTarget;
                    top.marginWidth = pair.getMaxNegative();
                    collapsed.add(top);
                    CollapsingMargin bottom = new CollapsingMargin();
                    bottom.content = currentTarget;
                    bottom.marginWidth = pair.getMaxPositive();
                    collapsed.add(bottom);
                    Content potentialTarget = null;
                    if (direction == 1) {
                        potentialTarget = parent.getNextInFlowSibling(c, currentTarget);
                    } else if (direction == 2) {
                        potentialTarget = parent.getPreviousInFlowSibling(c, currentTarget);
                    } else {
                        throw new IllegalArgumentException();
                    }
                    if (potentialTarget == null || !(potentialTarget instanceof CollapsableContent)) {
                        CollapsableContent collapsableContent = null;
                        return collapsableContent;
                    }
                    currentTarget = (CollapsableContent)potentialTarget;
                    continue;
                }
                CollapsableContent collapsableContent = currentTarget;
                return collapsableContent;
            }
            finally {
                c.popStyle();
                continue;
            }
            break;
        }
    }

    private static Float collapseBottomMargin(LayoutContext c, CachingContent content, float parentWidth) {
        if (content instanceof BlockContent) {
            if (VerticalMarginCollapser.hasBottomBorderOrPadding(c, parentWidth)) {
                return VerticalMarginCollapser.calculateAdjustedMarginBottom(c, content, parentWidth);
            }
            ArrayList<CollapsingMargin> collapsed = new ArrayList<CollapsingMargin>();
            VerticalMarginCollapser.collapseBottomMarginHelper(c, content, collapsed, parentWidth);
            if (collapsed.size() == 0) {
                return VerticalMarginCollapser.calculateAdjustedMarginBottom(c, content, parentWidth);
            }
            Iterator i = collapsed.iterator();
            while (i.hasNext()) {
                CollapsingMargin margin = (CollapsingMargin)i.next();
                margin.content.setBottomMarginCollapsed(true);
            }
            CollapsingMargin top = new CollapsingMargin();
            top.content = (CollapsableContent)content;
            top.marginWidth = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_BOTTOM, parentWidth, c);
            collapsed.add(top);
            return VerticalMarginCollapser.calculateAdjustedMarginBottom(c, collapsed);
        }
        return null;
    }

    private static Float calculateAdjustedMarginBottom(LayoutContext c, Content topContent, float parentWidth) {
        CollapsingMargin top = new CollapsingMargin();
        top.content = (CollapsableContent)topContent;
        top.marginWidth = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_BOTTOM, parentWidth, c);
        return VerticalMarginCollapser.calculateAdjustedMarginBottom(c, Collections.singletonList(top));
    }

    private static Float calculateAdjustedMarginBottom(LayoutContext c, List collapsed) {
        CachingContent parent = (CachingContent)c.getParentContent();
        CollapsingMargin which = (CollapsingMargin)collapsed.get(collapsed.size() - 1);
        Content inFlowSibling = parent.getNextInFlowSibling(c, which.content);
        CollapsedMarginPair pair = VerticalMarginCollapser.calculateCollapsedMargin(null, collapsed);
        if (inFlowSibling instanceof CollapsableContent) {
            ((CollapsableContent)inFlowSibling).setMarginToCollapse(pair);
            which.content.setBottomMarginCollapsed(true);
            Content sibling = parent.getNextSibling(c, which.content);
            if (sibling instanceof AnonymousBlockContent) {
                VerticalMarginCollapser.provideCollapsedMarginToFloats((AnonymousBlockContent)sibling, pair);
            }
            return new Float(0.0f);
        }
        return new Float(pair.getValue());
    }

    private static void provideCollapsedMarginToFloats(AnonymousBlockContent content, CollapsedMarginPair pair) {
        Iterator i = content.getChildContent(null).iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof AbsolutelyPositionedContent) continue;
            if (!(obj instanceof FloatedBlockContent)) break;
            ((FloatedBlockContent)obj).setMarginFromPrevious((int)pair.getValue());
        }
    }

    private static void collapseBottomMarginHelper(LayoutContext c, CachingContent content, List collapsed, float parentWidth) {
        List children = content.getChildContent(c);
        Object target = null;
        for (int i = children.size() - 1; i >= 0 && ContentUtil.isNotInFlow(target = children.get(i)); --i) {
        }
        if (target instanceof CollapsableContent) {
            CollapsableContent targetContent = target;
            float nextParentWidth = VerticalMarginCollapser.adjustWidth(parentWidth, c);
            targetContent = VerticalMarginCollapser.collapseAdjoiningIntervening(c, content, nextParentWidth, targetContent, collapsed, 2);
            if (targetContent == null) {
                return;
            }
            c.pushStyle(targetContent.getStyle());
            CollapsingMargin margin = new CollapsingMargin();
            margin.content = targetContent;
            margin.marginWidth = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_TOP, nextParentWidth, c);
            collapsed.add(margin);
            if (!VerticalMarginCollapser.hasBottomBorderOrPadding(c, nextParentWidth) && VerticalMarginCollapser.mayCollapseInto(c, targetContent)) {
                VerticalMarginCollapser.collapseBottomMarginHelper(c, targetContent, collapsed, nextParentWidth);
            }
            c.popStyle();
        }
    }

    public static boolean mayCollapseInto(LayoutContext c, CollapsableContent content) {
        return content.mayCollapseInto() && c.getCurrentStyle().isIdent(CSSName.OVERFLOW, IdentValue.VISIBLE);
    }

    private static Float calculateCollapsedTop(LayoutContext c, Content topContent, float parentWidth) {
        CollapsingMargin top = new CollapsingMargin();
        top.content = (CollapsableContent)topContent;
        top.marginWidth = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_TOP, parentWidth, c);
        return new Float(VerticalMarginCollapser.calculateCollapsedMargin(((CollapsableContent)topContent).getMarginToCollapse(), Collections.singletonList(top)).getValue());
    }

    private static CollapsedMarginPair calculateCollapsedMargin(CollapsedMarginPair pair, List collapsed) {
        float maxPositive = 0.0f;
        float maxNegative = 0.0f;
        if (pair != null) {
            maxPositive = pair.getMaxPositive();
            maxNegative = pair.getMaxNegative();
        }
        Iterator i = collapsed.iterator();
        while (i.hasNext()) {
            CollapsingMargin margin = (CollapsingMargin)i.next();
            if (margin.marginWidth > 0.0f && margin.marginWidth > maxPositive) {
                maxPositive = margin.marginWidth;
                continue;
            }
            if (!(margin.marginWidth < 0.0f) || !(margin.marginWidth < maxNegative)) continue;
            maxNegative = margin.marginWidth;
        }
        return new CollapsedMarginPair(maxNegative, maxPositive);
    }

    private static CollapsedMarginPair collapseAdjoining(CollapsedMarginPair pair, List nodes) {
        float maxPositive = 0.0f;
        float maxNegative = 0.0f;
        if (pair != null) {
            maxPositive = pair.getMaxPositive();
            maxNegative = pair.getMaxNegative();
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            CollapsingNode node = (CollapsingNode)i.next();
            node.content.setBottomMarginCollapsed(true);
            node.content.setTopMarginCollapsed(true);
            node.content.setCollapsed(true);
            if (node.marginTop > 0.0f && node.marginTop > maxPositive) {
                maxPositive = node.marginTop;
            } else if (node.marginTop < 0.0f && node.marginTop < maxNegative) {
                maxNegative = node.marginTop;
            }
            if (node.marginBottom > 0.0f && node.marginBottom > maxPositive) {
                maxPositive = node.marginBottom;
                continue;
            }
            if (!(node.marginBottom < 0.0f) || !(node.marginBottom < maxNegative)) continue;
            maxNegative = node.marginBottom;
        }
        return new CollapsedMarginPair(maxNegative, maxPositive);
    }

    private static float adjustWidth(float parentWidth, LayoutContext c) {
        boolean hasSpecifiedWidth;
        CalculatedStyle style = c.getCurrentStyle();
        boolean bl = hasSpecifiedWidth = !style.isIdent(CSSName.WIDTH, IdentValue.AUTO);
        if (hasSpecifiedWidth) {
            return style.getFloatPropertyProportionalWidth(CSSName.WIDTH, parentWidth, c);
        }
        RectPropertySet margin = style.getMarginRect(parentWidth, parentWidth, c);
        RectPropertySet padding = style.getPaddingRect(parentWidth, parentWidth, c);
        BorderPropertySet borderWidth = style.getBorder(c);
        return parentWidth - margin.left() - (float)((int)borderWidth.left()) - (float)((int)padding.left()) - (float)((int)padding.right()) - (float)((int)borderWidth.right()) - margin.right();
    }

    private static List areMarginsAdjoining(LayoutContext c, CollapsableContent content, float parentWidth) {
        return VerticalMarginCollapser.areMarginsAdjoiningHelper(c, content, parentWidth, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List areMarginsAdjoiningHelper(LayoutContext c, CollapsableContent content, float parentWidth, List adjoining) {
        if (content.isMarginsAdjoiningCalculated() && !content.isMarginsAdjoining()) {
            return null;
        }
        List children = content.getChildContent(c);
        boolean b = VerticalMarginCollapser.hasNoBordersPaddingOrHeight(c, parentWidth);
        CollapsingNode n = new CollapsingNode();
        n.content = content;
        n.marginTop = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_TOP, parentWidth, c);
        n.marginBottom = c.getCurrentStyle().getFloatPropertyProportionalWidth(CSSName.MARGIN_BOTTOM, parentWidth, c);
        adjoining.add(n);
        if (!b) {
            return VerticalMarginCollapser.returnWithSave(content, null);
        }
        if (children.size() == 0) {
            return VerticalMarginCollapser.returnWithSave(content, adjoining);
        }
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (ContentUtil.isNotInFlow(obj)) continue;
            if (!(obj instanceof CollapsableContent)) {
                return VerticalMarginCollapser.returnWithSave(content, null);
            }
            CollapsableContent childContent = (CollapsableContent)obj;
            float width = VerticalMarginCollapser.adjustWidth(parentWidth, c);
            c.pushStyle(childContent.getStyle());
            try {
                if ((adjoining = VerticalMarginCollapser.areMarginsAdjoiningHelper(c, childContent, width, adjoining)) != null) continue;
                List list = VerticalMarginCollapser.returnWithSave(content, null);
                return list;
            }
            finally {
                c.popStyle();
            }
        }
        return VerticalMarginCollapser.returnWithSave(content, adjoining);
    }

    private static List returnWithSave(CollapsableContent content, List result) {
        content.setMarginsAdjoiningCalculated(true);
        content.setMarginsAdjoining(result != null);
        return result;
    }

    private static boolean hasNoBordersPaddingOrHeight(LayoutContext c, float parentWidth) {
        CalculatedStyle style = c.getCurrentStyle();
        BorderPropertySet borderWidth = style.getBorder(c);
        RectPropertySet padding = style.getPaddingRect(parentWidth, parentWidth, c);
        return (int)borderWidth.top() == 0 && (int)borderWidth.bottom() == 0 && (int)padding.top() == 0 && (int)padding.bottom() == 0 && (style.isIdent(CSSName.HEIGHT, IdentValue.AUTO) || style.asFloat(CSSName.HEIGHT) == 0.0f);
    }

    public static class CollapsedMarginPair {
        private float _maxPositive;
        private float _maxNegative;

        public CollapsedMarginPair() {
        }

        public CollapsedMarginPair(float negative, float positive) {
            this._maxNegative = negative;
            this._maxPositive = positive;
        }

        public float getMaxNegative() {
            return this._maxNegative;
        }

        public void setMaxNegative(float maxNegative) {
            this._maxNegative = maxNegative;
        }

        public float getMaxPositive() {
            return this._maxPositive;
        }

        public void setMaxPositive(float maxPositive) {
            this._maxPositive = maxPositive;
        }

        public float getValue() {
            return this._maxPositive + this._maxNegative;
        }
    }

    private static class CollapsingNode {
        CollapsableContent content;
        float marginTop;
        float marginBottom;

        private CollapsingNode() {
        }
    }

    private static class CollapsingMargin {
        CollapsableContent content;
        float marginWidth;

        private CollapsingMargin() {
        }
    }
}

