/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout.content;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.constants.Idents;
import org.xhtmlrenderer.css.extend.ContentFunction;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.content.AbsolutelyPositionedContent;
import org.xhtmlrenderer.layout.content.AnonymousBlockContent;
import org.xhtmlrenderer.layout.content.BlockContent;
import org.xhtmlrenderer.layout.content.Content;
import org.xhtmlrenderer.layout.content.DomToplevelNode;
import org.xhtmlrenderer.layout.content.FirstLetterStyle;
import org.xhtmlrenderer.layout.content.FirstLineStyle;
import org.xhtmlrenderer.layout.content.FloatedBlockContent;
import org.xhtmlrenderer.layout.content.InlineBlockContent;
import org.xhtmlrenderer.layout.content.InlineContent;
import org.xhtmlrenderer.layout.content.RunInContent;
import org.xhtmlrenderer.layout.content.StylePop;
import org.xhtmlrenderer.layout.content.StylePush;
import org.xhtmlrenderer.layout.content.TableCellContent;
import org.xhtmlrenderer.layout.content.TableContent;
import org.xhtmlrenderer.layout.content.TextContent;
import org.xhtmlrenderer.layout.content.WhitespaceStripper;

public class ContentUtil {
    public static boolean mayHaveFirstLetter(CalculatedStyle style) {
        if (style == null) {
            return false;
        }
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        return display != null && (display == IdentValue.BLOCK || display == IdentValue.LIST_ITEM || display == IdentValue.TABLE_CELL || display == IdentValue.TABLE_CAPTION || display == IdentValue.INLINE_BLOCK);
    }

    public static boolean mayHaveFirstLine(CalculatedStyle style) {
        if (style == null) {
            return false;
        }
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        return display != null && (display == IdentValue.BLOCK || display == IdentValue.LIST_ITEM || display == IdentValue.RUN_IN || display == IdentValue.TABLE || display == IdentValue.TABLE_CELL || display == IdentValue.TABLE_CAPTION || display == IdentValue.INLINE_BLOCK);
    }

    public static boolean hasBlockContent(List childContent) {
        Iterator i = childContent.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof TableContent) {
                return true;
            }
            if (o instanceof BlockContent) {
                return true;
            }
            if (o instanceof AnonymousBlockContent) {
                return true;
            }
            if (!(o instanceof RunInContent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockLevel(CalculatedStyle style) {
        if (style == null) {
            return false;
        }
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        return display != null && (display == IdentValue.BLOCK || display == IdentValue.LIST_ITEM || display == IdentValue.TABLE);
    }

    public static boolean isHidden(CalculatedStyle style) {
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        return display != null && display == IdentValue.NONE;
    }

    public static boolean isRunIn(CalculatedStyle style) {
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        return display != null && display == IdentValue.RUN_IN;
    }

    public static boolean isTable(CalculatedStyle style) {
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        return display != null && display == IdentValue.TABLE;
    }

    public static boolean isTableDescendant(CalculatedStyle style) {
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        if (display == null) {
            return false;
        }
        if (display == IdentValue.TABLE) {
            return false;
        }
        return display.toString().startsWith("table");
    }

    public static boolean isAbsoluteOrFixed(CalculatedStyle style) {
        IdentValue position = style.getIdent(CSSName.POSITION);
        return position != null && (position == IdentValue.ABSOLUTE || position == IdentValue.FIXED);
    }

    public static boolean isInlineBlock(CalculatedStyle style) {
        IdentValue display = style.getIdent(CSSName.DISPLAY);
        return display != null && display == IdentValue.INLINE_BLOCK;
    }

    public static boolean isFloated(CalculatedStyle style) {
        if (style == null) {
            return false;
        }
        IdentValue floatVal = style.getIdent(CSSName.FLOAT);
        return floatVal != null && (floatVal == IdentValue.LEFT || floatVal == IdentValue.RIGHT);
    }

    static List resolveBlockContent(List pendingInlines, Element parentElement, LayoutContext c) {
        List inline = new LinkedList();
        LinkedList<AnonymousBlockContent> block = new LinkedList<AnonymousBlockContent>();
        Iterator i = pendingInlines.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof BlockContent || o instanceof RunInContent || o instanceof TableContent || o instanceof FirstLineStyle || o instanceof FirstLetterStyle) {
                if ((inline = WhitespaceStripper.stripInlineContent(c, inline)).size() != 0) {
                    block.add(new AnonymousBlockContent(parentElement, inline));
                    inline = new LinkedList();
                }
                block.add((AnonymousBlockContent)o);
                continue;
            }
            inline.add(o);
        }
        if ((inline = WhitespaceStripper.stripInlineContent(c, inline)).size() != 0) {
            block.add(new AnonymousBlockContent(parentElement, inline));
        }
        return block;
    }

    static List getChildContentList(LayoutContext c, Content parent) {
        String content;
        CascadedStyle after;
        List<TextContent> inlineList = new ArrayList<Object>();
        FirstLineStyle firstLineStyle = null;
        FirstLetterStyle firstLetterStyle = null;
        StringBuffer textContent = null;
        CascadedStyle parentStyle = parent.getStyle();
        Element parentElement = parent.getElement();
        if (parentElement != null) {
            String content2;
            CascadedStyle firstLetter;
            CascadedStyle firstLine;
            c.pushStyle(parentStyle);
            if (ContentUtil.mayHaveFirstLine(c.getCurrentStyle()) && (firstLine = c.getCss().getPseudoElementStyle(parentElement, "first-line")) != null) {
                firstLineStyle = new FirstLineStyle(firstLine);
            }
            if (ContentUtil.mayHaveFirstLetter(c.getCurrentStyle()) && (firstLetter = c.getCss().getPseudoElementStyle(parentElement, "first-letter")) != null) {
                firstLetterStyle = new FirstLetterStyle(firstLetter);
            }
            c.popStyle();
            CascadedStyle before = c.getCss().getPseudoElementStyle(parentElement, "before");
            if (before != null && before.hasProperty(CSSName.CONTENT) && !(content2 = before.propertyByName(CSSName.CONTENT).getValue().getStringValue()).equals("")) {
                inlineList.add((TextContent)((Object)new StylePush("before", parentElement)));
                c.pushStyle(before);
                textContent = new StringBuffer();
                textContent.append(content2.replaceAll("\\\\A", "\n"));
                ContentFunction contentFunction = null;
                if (Idents.looksLikeAFunction(content2) && (contentFunction = c.getContentFunctionFactory().lookupFunction(c, textContent.toString())) != null && contentFunction.isStatic()) {
                    String value = contentFunction.calculate(c, textContent.toString());
                    textContent = new StringBuffer(value);
                    contentFunction = null;
                }
                inlineList.add(new TextContent("before", parentElement, textContent.toString(), contentFunction));
                textContent = null;
                c.popStyle();
                inlineList.add((TextContent)((Object)new StylePop("before", parentElement)));
            }
        }
        Iterator i = ContentUtil.getNodeIterator(parent);
        TableContent anonymousTable = null;
        while (i.hasNext()) {
            Node curr = (Node)i.next();
            if (curr.getNodeType() != 1 && curr.getNodeType() != 3) continue;
            if (curr.getNodeType() == 3) {
                String text = curr.getNodeValue();
                if (textContent == null) {
                    textContent = new StringBuffer();
                }
                textContent.append(text);
                anonymousTable = null;
                continue;
            }
            Element elem = (Element)curr;
            CascadedStyle style = c.getCss().getCascadedStyle(elem, true);
            c.pushStyle(style);
            CalculatedStyle currentStyle = c.getCurrentStyle();
            if (ContentUtil.isTableDescendant(currentStyle)) {
                if (anonymousTable == null) {
                    anonymousTable = new TableContent();
                    inlineList.add((TextContent)((Object)anonymousTable));
                }
                anonymousTable.addChild(elem);
                c.popStyle();
                continue;
            }
            anonymousTable = null;
            if (ContentUtil.isHidden(currentStyle)) {
                c.popStyle();
                continue;
            }
            if (ContentUtil.isAbsoluteOrFixed(currentStyle)) {
                textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
                inlineList.add((TextContent)((Object)new AbsolutelyPositionedContent((Element)curr, style)));
                c.popStyle();
                continue;
            }
            if (ContentUtil.isFloated(currentStyle)) {
                textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
                inlineList.add((TextContent)((Object)new FloatedBlockContent((Element)curr, style)));
                c.popStyle();
                continue;
            }
            if (ContentUtil.isInlineBlock(currentStyle)) {
                textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
                inlineList.add((TextContent)((Object)new InlineBlockContent(elem, style)));
                c.popStyle();
                continue;
            }
            if (ContentUtil.isRunIn(currentStyle)) {
                RunInContent runIn = new RunInContent(elem, style);
                textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
                inlineList.add((TextContent)((Object)runIn));
                c.popStyle();
                continue;
            }
            if (ContentUtil.isTable(currentStyle)) {
                textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
                TableContent table = new TableContent(elem, style);
                inlineList.add((TextContent)((Object)table));
                c.popStyle();
                continue;
            }
            if (ContentUtil.isBlockLevel(currentStyle)) {
                textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
                BlockContent block = new BlockContent(elem, style);
                inlineList.add((TextContent)((Object)block));
                c.popStyle();
                continue;
            }
            textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
            InlineContent inline = new InlineContent(elem, style);
            List childList = inline.getChildContent(c);
            inlineList.add((TextContent)((Object)new StylePush(null, elem)));
            Iterator ci = childList.iterator();
            while (ci.hasNext()) {
                Object o = ci.next();
                if (o instanceof AnonymousBlockContent) {
                    inlineList.addAll(((AnonymousBlockContent)o).getChildContent(c));
                    continue;
                }
                inlineList.add((TextContent)o);
            }
            inlineList.add((TextContent)((Object)new StylePop(null, elem)));
            c.popStyle();
        }
        textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
        if (parentElement != null && (after = c.getCss().getPseudoElementStyle(parentElement, "after")) != null && after.hasProperty(CSSName.CONTENT) && !(content = after.propertyByName(CSSName.CONTENT).getValue().getStringValue()).equals("")) {
            textContent = ContentUtil.saveTextContent(textContent, inlineList, parentElement, parent);
            inlineList.add((TextContent)((Object)new StylePush("after", parentElement)));
            textContent = new StringBuffer();
            textContent.append(content.replaceAll("\\\\A", "\n"));
            ContentFunction contentFunction = null;
            if (Idents.looksLikeAFunction(content) && (contentFunction = c.getContentFunctionFactory().lookupFunction(c, textContent.toString())) != null && contentFunction.isStatic()) {
                String value = contentFunction.calculate(c, textContent.toString());
                textContent = new StringBuffer(value);
                contentFunction = null;
            }
            inlineList.add(new TextContent("after", parentElement, textContent.toString(), contentFunction));
            textContent = null;
            inlineList.add((TextContent)((Object)new StylePop("after", parentElement)));
        }
        LinkedList blockList = null;
        if (firstLetterStyle != null) {
            inlineList.add(0, (TextContent)((Object)firstLetterStyle));
        }
        if (firstLineStyle != null) {
            inlineList.add(0, (TextContent)((Object)firstLineStyle));
        }
        if (ContentUtil.hasBlockContent(inlineList)) {
            blockList = new LinkedList();
            blockList.addAll(ContentUtil.resolveBlockContent(inlineList, parentElement, c));
            return blockList;
        }
        inlineList = WhitespaceStripper.stripInlineContent(c, inlineList);
        return inlineList;
    }

    private static Iterator getNodeIterator(Content parent) {
        Node node;
        if (parent instanceof TableCellContent) {
            if (((TableCellContent)parent).getChildIterator() != null) {
                return ((TableCellContent)parent).getChildIterator();
            }
            node = parent.getElement();
        } else {
            node = parent instanceof DomToplevelNode ? ((DomToplevelNode)parent).getNode() : parent.getElement();
        }
        return new Iterator(){
            NodeList nl;
            int i;
            {
                this.nl = node.getChildNodes();
                this.i = 0;
            }

            public boolean hasNext() {
                return this.i < this.nl.getLength();
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.nl.item(this.i++);
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static StringBuffer saveTextContent(StringBuffer textContent, List inlineList, Element parentElement, Content parent) {
        if (textContent != null) {
            boolean isAnonymousInlineBox;
            boolean bl = isAnonymousInlineBox = !(parent instanceof InlineContent);
            if (isAnonymousInlineBox) {
                inlineList.add(new StylePush(null, null));
            }
            inlineList.add(new TextContent(parentElement, textContent.toString()));
            if (isAnonymousInlineBox) {
                inlineList.add(new StylePop(null, null));
            }
            textContent = null;
        }
        return textContent;
    }

    public static boolean isNotInFlow(Object current) {
        if (current instanceof AnonymousBlockContent) {
            AnonymousBlockContent anon = (AnonymousBlockContent)current;
            Iterator i = anon.getChildContent(null).iterator();
            while (i.hasNext()) {
                Object content = i.next();
                if (content instanceof FloatedBlockContent || content instanceof AbsolutelyPositionedContent) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

