/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout.content;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.content.AbsolutelyPositionedContent;
import org.xhtmlrenderer.layout.content.FloatedBlockContent;
import org.xhtmlrenderer.layout.content.StylePop;
import org.xhtmlrenderer.layout.content.StylePush;
import org.xhtmlrenderer.layout.content.TextContent;

public class WhitespaceStripper {
    public static final String SPACE = " ";
    public static final String EOL = "\n";
    public static final Pattern linefeed_space_collapse = Pattern.compile("\\s+\\n\\s+");
    public static final Pattern linefeed_to_space = Pattern.compile("\\n");
    public static final Pattern tab_to_space = Pattern.compile("\\t");
    public static final Pattern space_collapse = Pattern.compile("( )+");
    public static final Pattern space_before_linefeed_collapse = Pattern.compile("[\\s&&[^\\n]]\\n");

    public static List stripInlineContent(LayoutContext c, List inlineContent) {
        Element e;
        LinkedList stripped = new LinkedList();
        LinkedList pendingStylePushes = new LinkedList();
        boolean collapse = false;
        boolean allWhitespace = true;
        Iterator i = inlineContent.iterator();
        while (i.hasNext()) {
            Element e2;
            Object o = i.next();
            if (o instanceof StylePush) {
                pendingStylePushes.addLast(o);
                StylePush sp = (StylePush)o;
                CascadedStyle style = sp.getElement() == null ? CascadedStyle.emptyCascadedStyle : (sp.getPseudoElement() != null ? c.getCss().getPseudoElementStyle(sp.getElement(), sp.getPseudoElement()) : c.getCss().getCascadedStyle(sp.getElement(), false));
                c.pushStyle(style);
                continue;
            }
            if (o instanceof TextContent) {
                TextContent tc = (TextContent)o;
                CalculatedStyle style = c.getCurrentStyle();
                boolean collapseNext = WhitespaceStripper.stripWhitespace(style, collapse, tc);
                if (!tc.isRemovableWhitespace()) {
                    allWhitespace = false;
                }
                stripped.addAll(pendingStylePushes);
                pendingStylePushes.clear();
                stripped.add(tc);
                collapse = collapseNext;
                continue;
            }
            if (o instanceof StylePop) {
                c.popStyle();
                if (pendingStylePushes.size() != 0) {
                    pendingStylePushes.removeLast();
                    continue;
                }
                stripped.add(o);
                continue;
            }
            if (!WhitespaceStripper.canCollapseThrough(o)) {
                allWhitespace = false;
            }
            if (pendingStylePushes.size() != 0 && (e2 = ((StylePush)pendingStylePushes.getLast()).getElement()) != null) {
                stripped.addAll(pendingStylePushes);
                stripped.addLast(new TextContent(e2, ""));
            }
            pendingStylePushes.clear();
            stripped.add(o);
            if (WhitespaceStripper.canCollapseThrough(o)) continue;
            collapse = false;
        }
        if (pendingStylePushes.size() != 0 && (e = ((StylePush)pendingStylePushes.getLast()).getElement()) != null) {
            stripped.addAll(pendingStylePushes);
            stripped.addLast(new TextContent(e, ""));
        }
        if (allWhitespace) {
            WhitespaceStripper.stripTextContent(stripped);
        }
        return stripped;
    }

    private static boolean canCollapseThrough(Object obj) {
        return obj instanceof FloatedBlockContent || obj instanceof AbsolutelyPositionedContent;
    }

    private static void stripTextContent(LinkedList stripped) {
        Element e;
        LinkedList pendingStylePushes = new LinkedList();
        LinkedList result = new LinkedList();
        Iterator i = stripped.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof TextContent) continue;
            if (o instanceof StylePush) {
                pendingStylePushes.addLast(o);
                continue;
            }
            if (o instanceof StylePop) {
                if (pendingStylePushes.size() > 0) {
                    pendingStylePushes.removeLast();
                    continue;
                }
                result.addLast(o);
                continue;
            }
            result.addAll(pendingStylePushes);
            pendingStylePushes.clear();
            result.addLast(o);
        }
        stripped.clear();
        stripped.addAll(result);
        if (pendingStylePushes.size() != 0 && (e = ((StylePush)pendingStylePushes.getLast()).getElement()) != null) {
            stripped.addAll(pendingStylePushes);
            stripped.addLast(new TextContent(e, ""));
        }
    }

    public static IdentValue getWhitespace(CalculatedStyle style) {
        IdentValue whitespace = style.getIdent(CSSName.WHITE_SPACE);
        return whitespace;
    }

    static boolean stripWhitespace(CalculatedStyle style, boolean collapseLeading, TextContent tc) {
        IdentValue whitespace = style.getIdent(CSSName.WHITE_SPACE);
        String text = tc.getText();
        boolean collapseNext = (text = WhitespaceStripper.collapseWhitespace(whitespace, text, collapseLeading)).endsWith(SPACE) && (whitespace == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP || whitespace == IdentValue.PRE);
        tc.setText(text);
        if (text.trim().equals("")) {
            if (whitespace == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP) {
                tc.setRemovableWhitespace(true);
            } else if (whitespace == IdentValue.PRE) {
                tc.setRemovableWhitespace(false);
            } else if (text.indexOf(EOL) < 0) {
                tc.setRemovableWhitespace(true);
            }
        }
        return text.equals("") ? collapseLeading : collapseNext;
    }

    static String collapseWhitespace(IdentValue whitespace, String text, boolean collapseLeading) {
        if (whitespace == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP) {
            text = linefeed_space_collapse.matcher(text).replaceAll(EOL);
        } else if (whitespace == IdentValue.PRE) {
            text = space_before_linefeed_collapse.matcher(text).replaceAll(EOL);
        }
        if (whitespace == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP) {
            text = linefeed_to_space.matcher(text).replaceAll(SPACE);
            text = tab_to_space.matcher(text).replaceAll(SPACE);
            text = space_collapse.matcher(text).replaceAll(SPACE);
        } else if (whitespace == IdentValue.PRE) {
            text = tab_to_space.matcher(text).replaceAll(SPACE);
        }
        if ((whitespace == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP) && text.startsWith(SPACE) && collapseLeading) {
            text = text.substring(1, text.length());
        }
        return text;
    }
}

