/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.TrueTypeUtil;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.util.XRRuntimeException;

public class ITextFontResolver
implements FontResolver {
    private Map _fontFamilies = ITextFontResolver.createInitialFontMap();
    private Map _fontCache = new HashMap();

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(renderingContext, spec.families, spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
    }

    public void flushCache() {
        this._fontFamilies = ITextFontResolver.createInitialFontMap();
        this._fontCache = new HashMap();
    }

    public void addFontDirectory(String dir, boolean embedded) throws DocumentException, IOException {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files = f.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    String lower = name.toLowerCase();
                    return lower.endsWith(".otf") || lower.endsWith(".ttf");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                this.addFont(files[i].getAbsolutePath(), embedded);
            }
        }
    }

    public void addFont(String path, boolean embedded) throws DocumentException, IOException {
        FontDescription descr;
        FontFamily fontFamily;
        String lower = path.toLowerCase();
        if (lower.endsWith(".otf") || lower.endsWith(".ttf")) {
            BaseFont font = BaseFont.createFont((String)path, (String)"Cp1252", (boolean)embedded);
            String fontFamilyName = TrueTypeUtil.getFamilyName(font);
            fontFamily = (FontFamily)this._fontFamilies.get(fontFamilyName);
            if (fontFamily == null) {
                fontFamily = new FontFamily();
                fontFamily.setName(fontFamilyName);
                this._fontFamilies.put(fontFamilyName, fontFamily);
            }
            descr = new FontDescription(font);
            try {
                TrueTypeUtil.populateDescription(path, font, descr);
            }
            catch (Exception e) {
                throw new XRRuntimeException(e.getMessage(), e);
            }
        } else {
            throw new XRRuntimeException("Unsupported font type");
        }
        fontFamily.addFontDescription(descr);
    }

    private FSFont resolveFont(SharedContext ctx, String[] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        if (families != null) {
            for (int i = 0; i < families.length; ++i) {
                FSFont font = this.resolveFont(ctx, families[i], size, weight, style, variant);
                if (font == null) continue;
                return font;
            }
        }
        return this.resolveFont(ctx, "Serif", size, weight, style, variant);
    }

    private String normalizeFontFamily(String fontFamily) {
        String result = fontFamily;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.equalsIgnoreCase("serif")) {
            result = "Serif";
        } else if (result.equalsIgnoreCase("sans-serif")) {
            result = "SansSerif";
        } else if (result.equalsIgnoreCase("monospace")) {
            result = "Monospaced";
        }
        return result;
    }

    private FSFont resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String normalizedFontFamily = this.normalizeFontFamily(fontFamily);
        String cacheKey = ITextFontResolver.getHashName(normalizedFontFamily, weight, style);
        FontDescription result = (FontDescription)this._fontCache.get(cacheKey);
        if (result != null) {
            return new ITextFSFont(result, size);
        }
        FontFamily family = (FontFamily)this._fontFamilies.get(normalizedFontFamily);
        if (family != null && (result = family.match(this.convertWeightToInt(weight), style)) != null) {
            this._fontCache.put(cacheKey, result);
            return new ITextFSFont(result, size);
        }
        return null;
    }

    private int convertWeightToInt(IdentValue weight) {
        if (weight == IdentValue.NORMAL) {
            return 400;
        }
        if (weight == IdentValue.BOLD) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_100) {
            return 100;
        }
        if (weight == IdentValue.FONT_WEIGHT_200) {
            return 200;
        }
        if (weight == IdentValue.FONT_WEIGHT_300) {
            return 300;
        }
        if (weight == IdentValue.FONT_WEIGHT_400) {
            return 400;
        }
        if (weight == IdentValue.FONT_WEIGHT_500) {
            return 500;
        }
        if (weight == IdentValue.FONT_WEIGHT_600) {
            return 600;
        }
        if (weight == IdentValue.FONT_WEIGHT_700) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_800) {
            return 800;
        }
        if (weight == IdentValue.FONT_WEIGHT_900) {
            return 900;
        }
        if (weight == IdentValue.LIGHTER) {
            return 400;
        }
        if (weight == IdentValue.BOLDER) {
            return 700;
        }
        throw new IllegalArgumentException();
    }

    protected static String getHashName(String name, IdentValue weight, IdentValue style) {
        return name + "-" + weight + "-" + style;
    }

    private static Map createInitialFontMap() {
        HashMap result = new HashMap();
        try {
            ITextFontResolver.addCourier(result);
            ITextFontResolver.addTimes(result);
            ITextFontResolver.addHelvetica(result);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    private static BaseFont createFont(String name) throws DocumentException, IOException {
        return BaseFont.createFont((String)name, (String)"winansi", (boolean)true);
    }

    private static void addCourier(HashMap result) throws DocumentException, IOException {
        FontFamily courier = new FontFamily();
        courier.setName("Courier");
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier-BoldOblique"), IdentValue.OBLIQUE, 700));
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier-Oblique"), IdentValue.OBLIQUE, 400));
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier-Bold"), IdentValue.NORMAL, 700));
        courier.addFontDescription(new FontDescription(ITextFontResolver.createFont("Courier"), IdentValue.NORMAL, 400));
        result.put("DialogInput", courier);
        result.put("Monospaced", courier);
        result.put("Courier", courier);
    }

    private static void addTimes(HashMap result) throws DocumentException, IOException {
        FontFamily times = new FontFamily();
        times.setName("Times");
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-BoldItalic"), IdentValue.ITALIC, 700));
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-Italic"), IdentValue.ITALIC, 400));
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-Bold"), IdentValue.NORMAL, 700));
        times.addFontDescription(new FontDescription(ITextFontResolver.createFont("Times-Roman"), IdentValue.NORMAL, 400));
        result.put("Serif", times);
        result.put("TimesRoman", times);
    }

    private static void addHelvetica(HashMap result) throws DocumentException, IOException {
        FontFamily helvetica = new FontFamily();
        helvetica.setName("Helvetica");
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica-BoldOblique"), IdentValue.OBLIQUE, 700));
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica-Oblique"), IdentValue.OBLIQUE, 400));
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica-Bold"), IdentValue.NORMAL, 700));
        helvetica.addFontDescription(new FontDescription(ITextFontResolver.createFont("Helvetica"), IdentValue.NORMAL, 400));
        result.put("Dialog", helvetica);
        result.put("SansSerif", helvetica);
    }

    public static class FontDescription {
        private IdentValue _style;
        private int _weight;
        private BaseFont _font;
        private float _underlinePosition;
        private float _underlineThickness;
        private float _yStrikeoutSize;
        private float _yStrikeoutPosition;

        public FontDescription() {
        }

        public FontDescription(BaseFont font) {
            this(font, IdentValue.NORMAL, 400);
        }

        public FontDescription(BaseFont font, IdentValue style, int weight) {
            this._font = font;
            this._style = style;
            this._weight = weight;
            this.setMetricDefaults();
        }

        public BaseFont getFont() {
            return this._font;
        }

        public void setFont(BaseFont font) {
            this._font = font;
        }

        public int getWeight() {
            return this._weight;
        }

        public void setWeight(int weight) {
            this._weight = weight;
        }

        public IdentValue getStyle() {
            return this._style;
        }

        public void setStyle(IdentValue style) {
            this._style = style;
        }

        public float getUnderlinePosition() {
            return this._underlinePosition;
        }

        public void setUnderlinePosition(float underlinePosition) {
            this._underlinePosition = underlinePosition;
        }

        public float getUnderlineThickness() {
            return this._underlineThickness;
        }

        public void setUnderlineThickness(float underlineThickness) {
            this._underlineThickness = underlineThickness;
        }

        public float getYStrikeoutPosition() {
            return this._yStrikeoutPosition;
        }

        public void setYStrikeoutPosition(float strikeoutPosition) {
            this._yStrikeoutPosition = strikeoutPosition;
        }

        public float getYStrikeoutSize() {
            return this._yStrikeoutSize;
        }

        public void setYStrikeoutSize(float strikeoutSize) {
            this._yStrikeoutSize = strikeoutSize;
        }

        private void setMetricDefaults() {
            this._underlinePosition = -50.0f;
            this._underlineThickness = 50.0f;
            int[] box = this._font.getCharBBox('x');
            if (box != null) {
                this._yStrikeoutPosition = box[3] / 2 + 50;
                this._yStrikeoutSize = 100.0f;
            } else {
                this._yStrikeoutPosition = this._font.getFontDescriptor(8, 1000.0f) / 3.0f;
            }
        }
    }

    private static class FontFamily {
        private String _name;
        private List _fontDescriptions;
        private static final int SM_EXACT = 1;
        private static final int SM_LIGHTER_OR_DARKER = 2;
        private static final int SM_DARKER_OR_LIGHTER = 3;

        public List getFontDescriptions() {
            return this._fontDescriptions;
        }

        public void addFontDescription(FontDescription descr) {
            if (this._fontDescriptions == null) {
                this._fontDescriptions = new ArrayList();
            }
            this._fontDescriptions.add(descr);
            Collections.sort(this._fontDescriptions, new Comparator(){

                public int compare(Object o1, Object o2) {
                    FontDescription f1 = (FontDescription)o1;
                    FontDescription f2 = (FontDescription)o2;
                    return f1.getWeight() - f2.getWeight();
                }
            });
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public FontDescription match(int desiredWeight, IdentValue style) {
            if (this._fontDescriptions == null) {
                throw new RuntimeException("fontDescriptions is null");
            }
            ArrayList<FontDescription> candidates = new ArrayList<FontDescription>();
            Iterator i = this._fontDescriptions.iterator();
            while (i.hasNext()) {
                FontDescription description = (FontDescription)i.next();
                if (description.getStyle() != style) continue;
                candidates.add(description);
            }
            if (candidates.size() == 0) {
                if (style == IdentValue.ITALIC) {
                    return this.match(desiredWeight, IdentValue.OBLIQUE);
                }
                if (style == IdentValue.OBLIQUE) {
                    return this.match(desiredWeight, IdentValue.NORMAL);
                }
                return null;
            }
            FontDescription[] matches = candidates.toArray(new FontDescription[candidates.size()]);
            FontDescription result = this.findByWeight(matches, desiredWeight, 1);
            if (result != null) {
                return result;
            }
            if (desiredWeight <= 500) {
                return this.findByWeight(matches, desiredWeight, 2);
            }
            return this.findByWeight(matches, desiredWeight, 3);
        }

        private FontDescription findByWeight(FontDescription[] matches, int desiredWeight, int searchMode) {
            if (searchMode == 1) {
                for (int i = 0; i < matches.length; ++i) {
                    FontDescription descr = matches[i];
                    if (descr.getWeight() != desiredWeight) continue;
                    return descr;
                }
                return null;
            }
            if (searchMode == 2) {
                int offset = 0;
                FontDescription descr = null;
                for (offset = 0; offset < matches.length && (descr = matches[offset]).getWeight() <= desiredWeight; ++offset) {
                }
                if (offset > 0 && descr.getWeight() > desiredWeight) {
                    return matches[offset - 1];
                }
                return descr;
            }
            if (searchMode == 3) {
                int offset = 0;
                FontDescription descr = null;
                for (offset = matches.length - 1; offset >= 0 && (descr = matches[offset]).getWeight() >= desiredWeight; --offset) {
                }
                if (offset != matches.length - 1 && descr.getWeight() < desiredWeight) {
                    return matches[offset + 1];
                }
                return descr;
            }
            return null;
        }
    }
}

