/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.Boxing;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.layout.content.DomToplevelNode;
import org.xhtmlrenderer.pdf.ITextFontContext;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextReplacedElementFactory;
import org.xhtmlrenderer.pdf.ITextTextRenderer;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.util.Configuration;

public class ITextRenderer {
    private static final float DEFAULT_DOTS_PER_POINT = 26.666666f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private SharedContext _sharedContext;
    private ITextOutputDevice _outputDevice;
    private org.w3c.dom.Document _doc;
    private Box _root;
    private float _dotsPerPoint;

    public ITextRenderer() {
        this(26.666666f, 20);
    }

    public ITextRenderer(float dotsPerPoint, int dotsPerPixel) {
        this._dotsPerPoint = dotsPerPoint;
        this._outputDevice = new ITextOutputDevice(this._dotsPerPoint);
        ITextUserAgent userAgent = new ITextUserAgent(this._outputDevice);
        this._sharedContext = new SharedContext(userAgent);
        userAgent.setSharedContext(this._sharedContext);
        this._outputDevice.setSharedContext(this._sharedContext);
        ITextFontResolver fontResolver = new ITextFontResolver();
        this._sharedContext.setFontResolver(fontResolver);
        this._sharedContext.setTextRenderer(new ITextTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(dotsPerPixel);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
    }

    public ITextFontResolver getFontResolver() {
        return (ITextFontResolver)this._sharedContext.getFontResolver();
    }

    private org.w3c.dom.Document loadDocument(String uri) {
        return this._sharedContext.getUac().getXMLResource(uri).getDocument();
    }

    public void setDocument(String uri) {
        this.setDocument(this.loadDocument(uri), uri);
    }

    public void setDocument(org.w3c.dom.Document doc, String url) {
        this.setDocument(doc, url, new XhtmlNamespaceHandler());
    }

    public void setDocument(File file) throws IOException {
        File parent = file.getParentFile();
        this.setDocument(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    public void setDocument(org.w3c.dom.Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        if (Configuration.isTrue("xr.cache.stylesheets", true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, new NullUserInterface());
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = Boxing.constructBox(c, new DomToplevelNode(this._doc));
        Boxing.layout(c, root, new DomToplevelNode(this._doc));
        Dimension dim = root.getLayer().getPaintingDimension(c);
        root.getLayer().trimEmptyPages(c, dim.height);
        this._root = root;
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext(new ITextFontContext());
        result.setOutputDevice(this._outputDevice);
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        return result;
    }

    private LayoutContext newLayoutContext() {
        java.awt.Rectangle extents = new java.awt.Rectangle(0, 0, 1, 1);
        LayoutContext result = this._sharedContext.newLayoutContextInstance(extents);
        result.setFontContext(new ITextFontContext());
        result.setReplacedElementFactory(new ITextReplacedElementFactory());
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        if (result.isPrint()) {
            PageBox first = Layer.createPageBox(result, "first");
            extents = new java.awt.Rectangle(0, 0, first.getContentWidth(result), first.getContentHeight(result));
            result.setExtents(extents);
        }
        return result;
    }

    public void createPDF(OutputStream os) throws DocumentException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle firstPageSize = new Rectangle(0.0f, 0.0f, (float)firstPage.getWidth(c) / this._dotsPerPoint, (float)firstPage.getHeight(c) / this._dotsPerPoint);
        Document doc = new Document(firstPageSize, 0.0f, 0.0f, 0.0f, 0.0f);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)os);
        doc.open();
        this._outputDevice.start(this._doc);
        this._outputDevice.setWriter(writer);
        this._outputDevice.initializePage(writer.getDirectContent(), firstPageSize.height());
        this._root.getLayer().assignPagePaintingPositions(c, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = (PageBox)pages.get(i);
            c.setPage(i, currentPage);
            this.paintPage(c, currentPage);
            this._outputDevice.finishPage();
            if (i == pageCount - 1) continue;
            PageBox nextPage = (PageBox)pages.get(i + 1);
            Rectangle nextPageSize = new Rectangle(0.0f, 0.0f, (float)nextPage.getWidth(c) / this._dotsPerPoint, (float)nextPage.getHeight(c) / this._dotsPerPoint);
            doc.setPageSize(nextPageSize);
            doc.newPage();
            this._outputDevice.initializePage(writer.getDirectContent(), nextPageSize.height());
        }
        this._outputDevice.finish(c, this._root);
        doc.close();
    }

    private void paintPage(RenderingContext c, PageBox page) {
        Shape working = this._outputDevice.getClip();
        java.awt.Rectangle content = page.getPrintingClippingBounds(c);
        this._outputDevice.clip(content);
        int top = -page.getPaintingTop() + page.getStyle().getMarginBorderPadding(c, 3);
        int left = page.getStyle().getMarginBorderPadding(c, 1);
        this._outputDevice.translate(left, top);
        this._root.getLayer().paint(c, 0, 0);
        this._outputDevice.translate(-left, -top);
        this._outputDevice.setClip(working);
        page.paintAlternateFlows(c, this._root.getLayer(), (short)2, 0);
        page.paintBorder(c, 0, (short)2);
        this._outputDevice.setClip(working);
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        public boolean isHover(Element e) {
            return false;
        }

        public boolean isActive(Element e) {
            return false;
        }

        public boolean isFocus(Element e) {
            return false;
        }
    }
}

