/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PersistentBFC;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.ListItemPainter;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.Renderable;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.StrutMetrics;

public class BlockBox
extends Box
implements Renderable,
InlinePaintable {
    public static final int POSITION_VERTICALLY = 1;
    public static final int POSITION_HORIZONTALLY = 2;
    public static final int POSITION_BOTH = 3;
    public int renderIndex;
    private List pendingInlineElements;
    private MarkerData markerData;
    private int listCounter;
    private PersistentBFC persistentBFC;
    private Box staticEquivalent;
    private boolean resetMargins;
    private boolean needPageClear;
    private ReplacedElement replacedElement;

    public void expandToMaxChildWidth() {
        int maxChildWidth = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childWidth;
            Box child = this.getChild(i);
            if (child instanceof BlockBox) {
                ((BlockBox)child).expandToMaxChildWidth();
            }
            if ((childWidth = child.getWidth()) <= maxChildWidth) continue;
            maxChildWidth = childWidth;
        }
        if (this.getStyle().isAutoWidth() && maxChildWidth > this.contentWidth) {
            this.contentWidth = maxChildWidth;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BlockBox:");
        sb.append(super.toString());
        if (this.getStyle().isFixed()) {
            sb.append(" position: fixed");
        }
        return sb.toString();
    }

    public int getIndex() {
        return this.renderIndex;
    }

    public double getAbsTop() {
        return this.getAbsY();
    }

    public double getAbsBottom() {
        return this.getAbsY() + this.height;
    }

    public void paintListMarker(RenderingContext c) {
        if (!this.getStyle().isVisible()) {
            return;
        }
        if (this.getStyle().isListItem()) {
            ListItemPainter.paint(c, this);
        }
    }

    public List getPendingInlineElements() {
        return this.pendingInlineElements;
    }

    public void setPendingInlineElements(List pendingInlineElements) {
        this.pendingInlineElements = pendingInlineElements;
    }

    public boolean intersects(CssContext cssCtx, Shape clip) {
        if (!this.getStyle().isListItem()) {
            return super.intersects(cssCtx, clip);
        }
        if (clip == null) {
            return true;
        }
        Rectangle borderEdge = this.getBorderEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        int delta = borderEdge.x;
        borderEdge.x = 0;
        borderEdge.width += delta;
        return clip.intersects(borderEdge);
    }

    public void paintInline(RenderingContext c) {
        if (!this.getStyle().isVisible()) {
            return;
        }
        this.getContainingLayer().paintAsLayer(c, this);
    }

    public boolean isInline() {
        Box parent = this.getParent();
        return parent instanceof LineBox || parent instanceof InlineBox;
    }

    public LineBox getLineBox() {
        if (!this.isInline()) {
            return null;
        }
        Box b = this.getParent();
        while (!(b instanceof LineBox)) {
            b = b.getParent();
        }
        return (LineBox)b;
    }

    public void paintDebugOutline(RenderingContext c) {
        c.getOutputDevice().drawDebugOutline(c, this, Color.RED);
    }

    public MarkerData getMarkerData() {
        return this.markerData;
    }

    public void setMarkerData(MarkerData markerData) {
        this.markerData = markerData;
    }

    public void createMarkerData(LayoutContext c, StrutMetrics strutMetrics) {
        boolean imageMarker = false;
        MarkerData result = new MarkerData();
        result.setStructMetrics(strutMetrics);
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        IdentValue listStyle = style.getIdent(CSSName.LIST_STYLE_TYPE);
        String image = style.getStringProperty(CSSName.LIST_STYLE_IMAGE);
        if (!image.equals("none")) {
            result.setImageMarker(this.makeImageMarker(c, strutMetrics, image));
            boolean bl = imageMarker = result.getImageMarker() != null;
        }
        if (listStyle != IdentValue.NONE && !imageMarker) {
            if (listStyle == IdentValue.CIRCLE || listStyle == IdentValue.SQUARE || listStyle == IdentValue.DISC) {
                result.setGlyphMarker(this.makeGlyphMarker(strutMetrics));
            } else {
                result.setTextMarker(this.makeTextMarker(c, listStyle));
            }
        }
        this.setMarkerData(result);
    }

    private MarkerData.GlyphMarker makeGlyphMarker(StrutMetrics strutMetrics) {
        int diameter = (int)((strutMetrics.getAscent() + strutMetrics.getDescent()) / 3.0f);
        MarkerData.GlyphMarker result = new MarkerData.GlyphMarker();
        result.setDiameter(diameter);
        result.setLayoutWidth(diameter * 3);
        return result;
    }

    private MarkerData.ImageMarker makeImageMarker(LayoutContext c, StrutMetrics structMetrics, String image) {
        FSImage img = null;
        if (!image.equals("none") && (img = c.getUac().getImageResource(image).getImage()) != null) {
            StrutMetrics strutMetrics = structMetrics;
            if ((float)img.getHeight() > strutMetrics.getAscent()) {
                img.scale(-1, (int)strutMetrics.getAscent());
            }
            MarkerData.ImageMarker result = new MarkerData.ImageMarker();
            result.setImage(img);
            result.setLayoutWidth(img.getWidth() * 2);
            return result;
        }
        return null;
    }

    private MarkerData.TextMarker makeTextMarker(LayoutContext c, IdentValue listStyle) {
        String text = "";
        text = listStyle == IdentValue.LOWER_LATIN || listStyle == IdentValue.LOWER_ALPHA ? BlockBox.toLatin(this.getListCounter()).toLowerCase() + "." : (listStyle == IdentValue.UPPER_LATIN || listStyle == IdentValue.UPPER_ALPHA ? BlockBox.toLatin(this.getListCounter()).toUpperCase() + "." : (listStyle == IdentValue.LOWER_ROMAN ? BlockBox.toRoman(this.getListCounter()).toLowerCase() + "." : (listStyle == IdentValue.UPPER_ROMAN ? BlockBox.toRoman(this.getListCounter()).toUpperCase() + "." : this.getListCounter() + ".")));
        text = text + "  ";
        int w = c.getTextRenderer().getWidth(c.getFontContext(), this.getStyle().getCalculatedStyle().getFSFont(c), text);
        MarkerData.TextMarker result = new MarkerData.TextMarker();
        result.setText(text);
        result.setLayoutWidth(w);
        return result;
    }

    private static String toLatin(int val) {
        if (val > 26) {
            int val1 = val % 26;
            int val2 = val / 26;
            return BlockBox.toLatin(val2) + BlockBox.toLatin(val1);
        }
        return (char)(val + 64) + "";
    }

    private static String toRoman(int val) {
        int[] ints = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] nums = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ints.length; ++i) {
            int count = val / ints[i];
            for (int j = 0; j < count; ++j) {
                sb.append(nums[i]);
            }
            val -= ints[i] * count;
        }
        return sb.toString();
    }

    public int getListCounter() {
        return this.listCounter;
    }

    public void setListCounter(int listCounter) {
        this.listCounter = listCounter;
    }

    public PersistentBFC getPersistentBFC() {
        return this.persistentBFC;
    }

    public void setPersistentBFC(PersistentBFC persistentBFC) {
        this.persistentBFC = persistentBFC;
    }

    public Box getStaticEquivalent() {
        return this.staticEquivalent;
    }

    public void setStaticEquivalent(Box staticEquivalent) {
        this.staticEquivalent = staticEquivalent;
    }

    public boolean isReplaced() {
        return this.replacedElement != null;
    }

    public void calcCanvasLocation() {
        LineBox lineBox = this.getLineBox();
        if (lineBox == null) {
            Box cb;
            Box parent = this.getParent();
            if (parent != null) {
                this.setAbsX(parent.getAbsX() + parent.tx + this.x);
                this.setAbsY(parent.getAbsY() + parent.ty + this.y);
            } else if (this.isStyled() && (this.getStyle().isAbsolute() || this.getStyle().isFixed()) && (cb = this.getContainingBlock()) != null) {
                this.setAbsX(cb.getAbsX() + this.x);
                this.setAbsY(cb.getAbsY() + this.y);
            }
        } else {
            this.setAbsX(lineBox.getAbsX() + this.x);
            this.setAbsY(lineBox.getAbsY() + this.y);
        }
        if (this.isReplaced()) {
            Point location = this.getReplacedElement().getLocation();
            if (location.x != this.getAbsX() || location.y != this.getAbsY()) {
                this.getReplacedElement().setLocation(this.getAbsX(), this.getAbsY());
            }
        }
    }

    public void calcChildLocations() {
        super.calcChildLocations();
        if (this.persistentBFC != null) {
            this.persistentBFC.getFloatManager().calcFloatLocations();
        }
    }

    public boolean isResetMargins() {
        return this.resetMargins;
    }

    public void setResetMargins(boolean resetMargins) {
        this.resetMargins = resetMargins;
    }

    public boolean isNeedPageClear() {
        return this.needPageClear;
    }

    public void setNeedPageClear(boolean needPageClear) {
        this.needPageClear = needPageClear;
    }

    private void alignToStaticEquivalent() {
        if (this.staticEquivalent.getAbsY() != this.getAbsY()) {
            this.y = this.staticEquivalent.getAbsY() - this.getAbsY();
            this.setAbsY(this.staticEquivalent.getAbsY());
        }
    }

    public void positionAbsolute(CssContext cssCtx, int direction) {
        CalculatedStyle style = this.getStyle().getCalculatedStyle();
        Rectangle boundingBox = null;
        int cbContentHeight = this.getContainingBlock().getContentAreaEdge((int)0, (int)0, (CssContext)cssCtx).height;
        boundingBox = this.getContainingBlock() instanceof BlockBox ? this.getContainingBlock().getPaddingEdge(0, 0, cssCtx) : this.getContainingBlock().getContentAreaEdge(0, 0, cssCtx);
        if ((direction & 2) != 0) {
            if (!style.isIdent(CSSName.LEFT, IdentValue.AUTO)) {
                this.x = (int)style.getFloatPropertyProportionalWidth(CSSName.LEFT, this.getContainingBlock().getContentWidth(), cssCtx);
            } else if (!style.isIdent(CSSName.RIGHT, IdentValue.AUTO)) {
                this.x = boundingBox.width - (int)style.getFloatPropertyProportionalWidth(CSSName.RIGHT, this.getContainingBlock().getContentWidth(), cssCtx) - this.getWidth();
            }
        }
        if ((direction & 1) != 0) {
            if (!style.isIdent(CSSName.TOP, IdentValue.AUTO)) {
                this.y = (int)style.getFloatPropertyProportionalHeight(CSSName.TOP, cbContentHeight, cssCtx);
            } else if (!style.isIdent(CSSName.BOTTOM, IdentValue.AUTO)) {
                this.y = boundingBox.height - (int)style.getFloatPropertyProportionalWidth(CSSName.BOTTOM, cbContentHeight, cssCtx) - this.getHeight();
            }
        }
        this.x += boundingBox.x;
        this.y += boundingBox.y;
        this.calcCanvasLocation();
        if ((direction & 1) != 0 && this.getStyle().isTopAuto() && this.getStyle().isBottomAuto()) {
            this.alignToStaticEquivalent();
        }
        this.calcChildLocations();
    }

    public void positionAbsoluteOnPage(LayoutContext c) {
        if (c.isPrint() && (this.getStyle().isForcePageBreakBefore() || this.isNeedPageClear())) {
            this.moveToNextPage(c);
            this.calcCanvasLocation();
            this.calcChildLocations();
        }
    }

    public ReplacedElement getReplacedElement() {
        return this.replacedElement;
    }

    public void setReplacedElement(ReplacedElement replacedElement) {
        this.replacedElement = replacedElement;
    }

    public boolean containsLineBoxes() {
        return this.getChildCount() > 0 && this.getChild(0) instanceof LineBox;
    }

    public void detach(LayoutContext c) {
        super.detach(c);
        if (this.isReplaced()) {
            this.getReplacedElement().detach(c);
        }
    }
}

