/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.BasicStroke;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.render.RenderingContext;

public class BorderPainter {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    public static final int ALL = 15;

    public static void paint(Rectangle bounds, int sides, CalculatedStyle style, RenderingContext ctx, int xOffset) {
        BorderPropertySet border = style.getBorder(ctx);
        if ((sides & 1) == 1 && border.noTop()) {
            --sides;
        }
        if ((sides & 2) == 2 && border.noLeft()) {
            sides -= 2;
        }
        if ((sides & 4) == 4 && border.noBottom()) {
            sides -= 4;
        }
        if ((sides & 8) == 8 && border.noRight()) {
            sides -= 8;
        }
        if ((sides & 1) == 1 && !border.topColor().equals(OutputDevice.TRANSPARENT)) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 1, border.topStyle(), xOffset);
        }
        if ((sides & 2) == 2 && !border.leftColor().equals(OutputDevice.TRANSPARENT)) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 2, border.leftStyle(), xOffset);
        }
        if ((sides & 4) == 4 && !border.bottomColor().equals(OutputDevice.TRANSPARENT)) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 4, border.bottomStyle(), xOffset);
        }
        if ((sides & 8) == 8 && !border.rightColor().equals(OutputDevice.TRANSPARENT)) {
            BorderPainter.paintBorderSide(ctx.getOutputDevice(), border, bounds, sides, 8, border.rightStyle(), xOffset);
        }
    }

    private static Rectangle shrinkRect(Rectangle rect, BorderPropertySet border, int sides) {
        Rectangle r2 = new Rectangle();
        r2.x = rect.x + ((sides & 2) == 0 ? 0 : (int)border.left());
        r2.width = rect.width - ((sides & 2) == 0 ? 0 : (int)border.left()) - ((sides & 8) == 0 ? 0 : (int)border.right());
        r2.y = rect.y + ((sides & 1) == 0 ? 0 : (int)border.top());
        r2.height = rect.height - ((sides & 1) == 0 ? 0 : (int)border.top()) - ((sides & 4) == 0 ? 0 : (int)border.bottom());
        return r2;
    }

    private static void paintBorderSide(OutputDevice outputDevice, BorderPropertySet border, Rectangle bounds, int sides, int currentSide, IdentValue borderSideStyle, int xOffset) {
        if (borderSideStyle == IdentValue.RIDGE || borderSideStyle == IdentValue.GROOVE) {
            BorderPropertySet bd2 = new BorderPropertySet((int)(border.top() / 2.0f), (int)(border.right() / 2.0f), (int)(border.bottom() / 2.0f), (int)(border.left() / 2.0f));
            if (borderSideStyle == IdentValue.RIDGE) {
                BorderPainter.paintGoodBevel(outputDevice, bounds, border, border.darker(borderSideStyle), border.brighter(borderSideStyle), sides, currentSide);
                BorderPainter.paintGoodBevel(outputDevice, bounds, bd2, border.brighter(borderSideStyle), border.darker(borderSideStyle), sides, currentSide);
            } else {
                BorderPainter.paintGoodBevel(outputDevice, bounds, border, border.brighter(borderSideStyle), border.darker(borderSideStyle), sides, currentSide);
                BorderPainter.paintGoodBevel(outputDevice, bounds, bd2, border.darker(borderSideStyle), border.brighter(borderSideStyle), sides, currentSide);
            }
            return;
        }
        if (borderSideStyle == IdentValue.OUTSET) {
            BorderPainter.paintGoodBevel(outputDevice, bounds, border, border.brighter(borderSideStyle), border.darker(borderSideStyle), sides, currentSide);
            return;
        }
        if (borderSideStyle == IdentValue.INSET) {
            BorderPainter.paintGoodBevel(outputDevice, bounds, border, border.darker(borderSideStyle), border.brighter(borderSideStyle), sides, currentSide);
            return;
        }
        if (borderSideStyle == IdentValue.SOLID) {
            BorderPainter.paintSolid(outputDevice, bounds, border, border, sides, currentSide);
            return;
        }
        if (borderSideStyle == IdentValue.DOUBLE) {
            BorderPropertySet outer = new BorderPropertySet((int)(border.top() / 3.0f), (int)(border.right() / 3.0f), (int)(border.bottom() / 3.0f), (int)(border.left() / 3.0f));
            BorderPropertySet center = new BorderPropertySet(outer);
            BorderPropertySet inner = new BorderPropertySet(outer);
            if ((int)border.top() == 1) {
                outer.setTop(1.0f);
                center.setTop(0.0f);
            }
            if ((int)border.bottom() == 1) {
                outer.setBottom(1.0f);
                center.setBottom(0.0f);
            }
            if ((int)border.left() == 1) {
                outer.setLeft(1.0f);
                center.setLeft(0.0f);
            }
            if ((int)border.right() == 1) {
                outer.setRight(1.0f);
                center.setRight(0.0f);
            }
            if ((int)border.top() == 2) {
                outer.setTop(1.0f);
                center.setTop(0.0f);
                inner.setTop(1.0f);
            }
            if ((int)border.bottom() == 2) {
                outer.setBottom(1.0f);
                center.setBottom(0.0f);
                inner.setBottom(1.0f);
            }
            if ((int)border.left() == 2) {
                outer.setLeft(1.0f);
                center.setLeft(0.0f);
                inner.setLeft(1.0f);
            }
            if ((int)border.right() == 2) {
                outer.setRight(1.0f);
                center.setRight(0.0f);
                inner.setRight(1.0f);
            }
            Rectangle b2 = BorderPainter.shrinkRect(bounds, outer, sides);
            b2 = BorderPainter.shrinkRect(b2, center, sides);
            BorderPainter.paintSolid(outputDevice, bounds, outer, border, sides, currentSide);
            BorderPainter.paintSolid(outputDevice, b2, inner, border, sides, currentSide);
            return;
        }
        int thickness = 0;
        if (currentSide == 1) {
            thickness = (int)border.top();
        }
        if (currentSide == 4) {
            thickness = (int)border.bottom();
        }
        if (currentSide == 8) {
            thickness = (int)border.right();
        }
        if (currentSide == 2) {
            thickness = (int)border.left();
        }
        if (borderSideStyle == IdentValue.DASHED) {
            outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            BorderPainter.paintPatternedRect(outputDevice, bounds, border, border, new float[]{8.0f + (float)(thickness * 2), 4.0f + (float)thickness}, sides, currentSide, xOffset);
            outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (borderSideStyle == IdentValue.DOTTED) {
            outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            BorderPainter.paintPatternedRect(outputDevice, bounds, border, border, new float[]{thickness, thickness}, sides, currentSide, xOffset);
            outputDevice.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    private static Polygon getBevelledPolygon(Rectangle bounds, BorderPropertySet border, int sides, int currentSide, boolean isClipRegion) {
        int snuggle;
        int adjust;
        if (isClipRegion) {
            adjust = 0;
            snuggle = 1;
        } else {
            adjust = 1;
            snuggle = 0;
        }
        adjust = 0;
        snuggle = 0;
        int rightCorner = (sides & 8) == 8 ? (int)border.right() : adjust;
        int leftCorner = (sides & 2) == 2 ? (int)border.left() - adjust : 0;
        int topCorner = (sides & 1) == 1 ? (int)border.top() - adjust : 0;
        int bottomCorner = (sides & 4) == 4 ? (int)border.bottom() : adjust;
        Polygon poly = null;
        if (currentSide == 1) {
            if ((int)border.top() != 1) {
                poly = new Polygon();
                poly.addPoint(bounds.x, bounds.y);
                poly.addPoint(bounds.x + bounds.width - adjust, bounds.y);
                poly.addPoint(bounds.x + bounds.width - rightCorner, bounds.y + (int)border.top() - adjust);
                poly.addPoint(bounds.x + leftCorner, bounds.y + (int)border.top() - adjust);
            }
        } else if (currentSide == 4) {
            if ((int)border.bottom() != 1) {
                poly = new Polygon();
                poly.addPoint(bounds.x + bounds.width - rightCorner, bounds.y + bounds.height - (int)border.bottom());
                poly.addPoint(bounds.x + leftCorner, bounds.y + bounds.height - (int)border.bottom());
                poly.addPoint(bounds.x, bounds.y + bounds.height - adjust);
                poly.addPoint(bounds.x + bounds.width - adjust, bounds.y + bounds.height - adjust);
            }
        } else if (currentSide == 8) {
            if ((int)border.right() != 1) {
                poly = new Polygon();
                poly.addPoint(bounds.x + bounds.width - adjust, bounds.y);
                poly.addPoint(bounds.x + bounds.width - (int)border.right(), bounds.y + topCorner - snuggle);
                poly.addPoint(bounds.x + bounds.width - (int)border.right(), bounds.y + bounds.height - bottomCorner + snuggle);
                poly.addPoint(bounds.x + bounds.width - adjust, bounds.y + bounds.height - adjust);
            }
        } else if (currentSide == 2 && (int)border.left() != 1) {
            poly = new Polygon();
            poly.addPoint(bounds.x, bounds.y);
            poly.addPoint(bounds.x + (int)border.left() - adjust, bounds.y + topCorner - snuggle);
            poly.addPoint(bounds.x + (int)border.left() - adjust, bounds.y + bounds.height - bottomCorner + snuggle);
            poly.addPoint(bounds.x, bounds.y + bounds.height - adjust);
        }
        return poly;
    }

    private static void paintPatternedRect(OutputDevice outputDevice, Rectangle bounds, BorderPropertySet border, BorderPropertySet color, float[] pattern, int sides, int currentSide, int xOffset) {
        Stroke old_stroke = outputDevice.getStroke();
        if (currentSide == 1) {
            outputDevice.setColor(color.topColor());
            outputDevice.setStroke(new BasicStroke((int)border.top(), 0, 2, 0.0f, pattern, xOffset));
            outputDevice.drawBorderLine(bounds, 1, (int)border.top(), false);
        } else if (currentSide == 2) {
            outputDevice.setColor(color.leftColor());
            outputDevice.setStroke(new BasicStroke((int)border.left(), 0, 2, 0.0f, pattern, 0.0f));
            outputDevice.drawBorderLine(bounds, 2, (int)border.left(), false);
        } else if (currentSide == 8) {
            outputDevice.setColor(color.rightColor());
            outputDevice.setStroke(new BasicStroke((int)border.right(), 0, 2, 0.0f, pattern, 0.0f));
            outputDevice.drawBorderLine(bounds, 8, (int)border.right(), false);
        } else if (currentSide == 4) {
            outputDevice.setColor(color.bottomColor());
            outputDevice.setStroke(new BasicStroke((int)border.bottom(), 0, 2, 0.0f, pattern, xOffset));
            outputDevice.drawBorderLine(bounds, 4, (int)border.bottom(), false);
        }
        outputDevice.setStroke(old_stroke);
    }

    private static void paintGoodBevel(OutputDevice outputDevice, Rectangle bounds, BorderPropertySet border, BorderPropertySet high, BorderPropertySet low, int sides, int currentSide) {
        if (currentSide == 1) {
            BorderPainter.paintSolid(outputDevice, bounds, border, high, sides, currentSide);
        } else if (currentSide == 4) {
            BorderPainter.paintSolid(outputDevice, bounds, border, low, sides, currentSide);
        } else if (currentSide == 8) {
            BorderPainter.paintSolid(outputDevice, bounds, border, low, sides, currentSide);
        } else if (currentSide == 2) {
            BorderPainter.paintSolid(outputDevice, bounds, border, high, sides, currentSide);
        }
    }

    private static void paintSolid(OutputDevice outputDevice, Rectangle bounds, BorderPropertySet border, BorderPropertySet bcolor, int sides, int currentSide) {
        Polygon poly = BorderPainter.getBevelledPolygon(bounds, border, sides, currentSide, true);
        if (currentSide == 1) {
            outputDevice.setColor(bcolor.topColor());
            if ((int)border.top() == 1) {
                outputDevice.drawBorderLine(bounds, 1, (int)border.top(), true);
            } else {
                outputDevice.fill(poly);
            }
        } else if (currentSide == 4) {
            outputDevice.setColor(bcolor.bottomColor());
            if ((int)border.bottom() == 1) {
                outputDevice.drawBorderLine(bounds, 4, (int)border.bottom(), true);
            } else {
                outputDevice.fill(poly);
            }
        } else if (currentSide == 8) {
            outputDevice.setColor(bcolor.rightColor());
            if ((int)border.right() == 1) {
                outputDevice.drawBorderLine(bounds, 8, (int)border.right(), true);
            } else {
                outputDevice.fill(poly);
            }
        } else if (currentSide == 2) {
            outputDevice.setColor(bcolor.leftColor());
            if ((int)border.left() == 1) {
                outputDevice.drawBorderLine(bounds, 2, (int)border.left(), true);
            } else {
                outputDevice.fill(poly);
            }
        }
    }
}

