/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Point;
import org.xhtmlrenderer.layout.FloatManager;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;

public class FloatedBlockBox
extends BlockBox {
    private Layer drawingLayer;
    private FloatManager manager;

    public String toString() {
        return super.toString() + " (floated)";
    }

    public Layer getDrawingLayer() {
        return this.drawingLayer;
    }

    public void setDrawingLayer(Layer drawingLayer) {
        this.drawingLayer = drawingLayer;
    }

    public void detach(LayoutContext c) {
        super.detach(c);
        this.manager.removeFloat(this);
        this.drawingLayer.removeFloat(this);
    }

    public void calcCanvasLocation() {
        Point offset = this.manager.getOffset(this);
        this.setAbsX(this.manager.getMaster().getAbsX() + this.x - offset.x);
        this.setAbsY(this.manager.getMaster().getAbsY() + this.y - offset.y);
        super.calcCanvasLocation();
    }

    public void calcInitialCanvasLocation(LayoutContext c) {
        Point offset = c.getBlockFormattingContext().getOffset();
        FloatManager manager = c.getBlockFormattingContext().getFloatManager();
        this.setAbsX(manager.getMaster().getAbsX() + this.x - offset.x);
        this.setAbsY(manager.getMaster().getAbsY() + this.y - offset.y);
    }

    public FloatManager getManager() {
        return this.manager;
    }

    public void setManager(FloatManager manager) {
        this.manager = manager;
    }

    public void setAbsY(int y) {
        super.setAbsY(y);
    }
}

