/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.render.AWTFSFont;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.Java2DFontContext;
import org.xhtmlrenderer.render.LineMetricsAdapter;
import org.xhtmlrenderer.swing.Java2DOutputDevice;

public class Java2DTextRenderer
implements TextRenderer {
    protected float scale = 1.0f;
    protected float threshold = 25.0f;
    protected int level = 3;

    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        Graphics2D graphics = ((Java2DOutputDevice)outputDevice).getGraphics();
        if ((float)graphics.getFont().getSize() > this.threshold && this.level > 0) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics.drawString(string, (int)x, (int)y);
        if ((float)graphics.getFont().getSize() > this.threshold && this.level > 0) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public void setup(FontContext fontContext) {
        ((Java2DFontContext)fontContext).getGraphics().setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public void setFontScale(float scale) {
        this.scale = scale;
    }

    public void setSmoothingThreshold(float fontsize) {
        this.threshold = fontsize;
    }

    public void setSmoothingLevel(int level) {
        this.level = level;
    }

    public FSFontMetrics getFSFontMetrics(FontContext fc, FSFont font, String string) {
        Graphics2D graphics = ((Java2DFontContext)fc).getGraphics();
        return new LineMetricsAdapter(((AWTFSFont)font).getAWTFont().getLineMetrics(string, graphics.getFontRenderContext()));
    }

    public int getWidth(FontContext fc, FSFont font, String string) {
        Graphics2D graphics = ((Java2DFontContext)fc).getGraphics();
        Font awtFont = ((AWTFSFont)font).getAWTFont();
        return (int)Math.ceil(graphics.getFontMetrics(awtFont).getStringBounds(string, graphics).getWidth());
    }

    public float getFontScale() {
        return this.scale;
    }

    public int getSmoothingLevel() {
        return this.level;
    }
}

