/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FloatDistances;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.Renderable;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.TextDecoration;
import org.xhtmlrenderer.util.XRLog;

public class LineBox
extends Box
implements Renderable,
InlinePaintable {
    public int renderIndex;
    private boolean containsContent;
    private boolean containsBlockLevelContent;
    private FloatDistances floatDistances;
    private TextDecoration textDecoration;
    private int paintingTop;
    private int paintingHeight;
    private List nonFlowContent;
    private MarkerData markerData;
    private boolean containsDynamicFunction;
    private int contentStart;

    public String toString() {
        return "Line: (" + this.x + "," + this.y + ")x(" + this.getWidth() + "," + this.height + ")";
    }

    public int getIndex() {
        return this.renderIndex;
    }

    public double getAbsTop() {
        return this.getAbsY();
    }

    public double getAbsBottom() {
        return this.getAbsY() + this.height;
    }

    public Rectangle getBounds(CssContext cssCtx, int tx, int ty) {
        Rectangle result = new Rectangle(this.x, this.y, this.contentWidth, this.height);
        result.translate(tx, ty);
        return result;
    }

    public void paintInline(RenderingContext c) {
        if (!this.getParent().getStyle().isVisible()) {
            return;
        }
        if (this.isContainsDynamicFunction()) {
            int totalLineWidth;
            this.lookForDynamicFunctions(c);
            this.contentWidth = totalLineWidth = InlineBoxing.positionHorizontally((CssContext)c, this, 0);
            this.calcChildLocations();
            this.align();
        }
        if (this.textDecoration != null) {
            c.getOutputDevice().drawTextDecoration(c, this);
        }
        if (c.debugDrawLineBoxes()) {
            c.getOutputDevice().drawDebugOutline(c, this, Color.GREEN);
        }
    }

    private void lookForDynamicFunctions(RenderingContext c) {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Box b = this.getChild(i);
                if (!(b instanceof InlineBox)) continue;
                ((InlineBox)b).lookForDynamicFunctions(c);
            }
        }
    }

    public boolean isFirstLine() {
        Box parent = this.getParent();
        return parent != null && parent.getChildCount() > 0 && parent.getChild(0) == this;
    }

    public void prunePendingInlineBoxes() {
        if (this.getChildCount() > 0) {
            Box b;
            for (int i = this.getChildCount() - 1; i >= 0 && (b = this.getChild(i)) instanceof InlineBox; --i) {
                InlineBox iB = (InlineBox)b;
                iB.prunePending();
                if (!iB.isPending()) continue;
                this.removeChild(i);
            }
        }
    }

    public boolean isContainsContent() {
        return this.containsContent;
    }

    public void setContainsContent(boolean containsContent) {
        this.containsContent = containsContent;
    }

    public void align() {
        if (this.getFloatDistances() == null) {
            XRLog.layout(Level.WARNING, "Float distances not available. Cannot align.");
            return;
        }
        IdentValue align = this.getParent().getStyle().getCalculatedStyle().getIdent(CSSName.TEXT_ALIGN);
        int calcX = 0;
        if (align == IdentValue.LEFT || align == IdentValue.JUSTIFY) {
            int floatDistance = this.getFloatDistances().getLeftFloatDistance();
            calcX = this.getContentStart() + floatDistance;
        } else if (align == IdentValue.CENTER) {
            int leftFloatDistance = this.getFloatDistances().getLeftFloatDistance();
            int rightFloatDistance = this.getFloatDistances().getRightFloatDistance();
            int midpoint = leftFloatDistance + (this.getParent().getContentWidth() - leftFloatDistance - rightFloatDistance) / 2;
            calcX = midpoint - (this.getContentWidth() + this.getContentStart()) / 2;
        } else if (align == IdentValue.RIGHT) {
            int floatDistance = this.getFloatDistances().getRightFloatDistance();
            calcX = this.getParent().getContentWidth() - floatDistance - this.getContentWidth();
        }
        if (calcX != this.x) {
            this.x = calcX;
            this.calcCanvasLocation();
            this.calcChildLocations();
        }
    }

    public FloatDistances getFloatDistances() {
        return this.floatDistances;
    }

    public void setFloatDistances(FloatDistances floatDistances) {
        this.floatDistances = floatDistances;
    }

    public boolean isContainsBlockLevelContent() {
        return this.containsBlockLevelContent;
    }

    public void setContainsBlockLevelContent(boolean containsBlockLevelContent) {
        this.containsBlockLevelContent = containsBlockLevelContent;
    }

    public boolean intersects(CssContext cssCtx, Shape clip) {
        return clip == null || this.intersectsLine(cssCtx, clip) || this.isContainsBlockLevelContent() && this.intersectsInlineBlocks(cssCtx, clip);
    }

    private boolean intersectsLine(CssContext cssCtx, Shape clip) {
        Box parent = this.getParent();
        Rectangle result = null;
        result = parent.getStyle().getCalculatedStyle().isIdent(CSSName.FS_TEXT_DECORATION_EXTENT, IdentValue.BLOCK) ? new Rectangle(this.getAbsX(), this.getAbsY() + this.paintingTop, parent.getAbsX() + parent.tx + parent.getContentWidth() - this.getAbsX(), this.paintingHeight) : new Rectangle(this.getAbsX(), this.getAbsY() + this.paintingTop, this.contentWidth, this.paintingHeight);
        return clip.intersects(result);
    }

    private boolean intersectsInlineBlocks(CssContext cssCtx, Shape clip) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            BoxCollector collector;
            boolean possibleResult;
            Box child = this.getChild(i);
            if (!(child instanceof InlineBox ? (possibleResult = ((InlineBox)child).intersectsInlineBlocks(cssCtx, clip)) : (collector = new BoxCollector()).intersectsAny(cssCtx, clip, child))) continue;
            return true;
        }
        return false;
    }

    public TextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.textDecoration = textDecoration;
    }

    public int getPaintingHeight() {
        return this.paintingHeight;
    }

    public void setPaintingHeight(int paintingHeight) {
        this.paintingHeight = paintingHeight;
    }

    public int getPaintingTop() {
        return this.paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this.paintingTop = paintingTop;
    }

    public void addAllChildren(List list, Layer layer) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            if (this.getContainingLayer() != layer) continue;
            list.add(child);
            if (!(child instanceof InlineBox)) continue;
            ((InlineBox)child).addAllChildren(list, layer);
        }
    }

    public List getNonFlowContent() {
        return this.nonFlowContent == null ? Collections.EMPTY_LIST : this.nonFlowContent;
    }

    public void addNonFlowContent(BlockBox box) {
        if (this.nonFlowContent == null) {
            this.nonFlowContent = new ArrayList();
        }
        this.nonFlowContent.add(box);
    }

    public void detach(LayoutContext c) {
        for (int i = 0; i < this.getNonFlowContent().size(); ++i) {
            Box content = (Box)this.getNonFlowContent().get(i);
            content.detach(c);
        }
        if (this.markerData != null) {
            this.markerData.restorePreviousReferenceLine(this);
        }
        super.detach(c);
    }

    public void calcCanvasLocation() {
        Box parent = this.getParent();
        if (parent == null) {
            XRLog.layout(Level.WARNING, "calcCanvasLocation() called with no parent");
        }
        this.setAbsX(parent.getAbsX() + parent.tx + this.x);
        this.setAbsY(parent.getAbsY() + parent.ty + this.y);
    }

    public void calcChildLocations() {
        super.calcChildLocations();
        for (int i = 0; i < this.getNonFlowContent().size(); ++i) {
            Box content = (Box)this.getNonFlowContent().get(i);
            if (!content.getStyle().isAbsolute()) continue;
            content.calcCanvasLocation();
            content.calcChildLocations();
        }
    }

    public MarkerData getMarkerData() {
        return this.markerData;
    }

    public void setMarkerData(MarkerData markerData) {
        this.markerData = markerData;
    }

    public boolean isContainsDynamicFunction() {
        return this.containsDynamicFunction;
    }

    public void setContainsDynamicFunction(boolean containsPageCounter) {
        this.containsDynamicFunction |= containsPageCounter;
    }

    public int getContentStart() {
        return this.contentStart;
    }

    public void setContentStart(int contentOffset) {
        this.contentStart = contentOffset;
    }

    public InlineText findTrailingText() {
        if (this.getChildCount() == 0) {
            return null;
        }
        for (int offset = this.getChildCount() - 1; offset >= 0; --offset) {
            Box child = this.getChild(offset);
            if (child instanceof InlineBox) {
                InlineText result = ((InlineBox)child).findTrailingText();
                if (result != null && result.isEmpty()) continue;
                return result;
            }
            return null;
        }
        return null;
    }

    public void maybeTrimTrailingSpace(LayoutContext c) {
        InlineBox iB;
        IdentValue whitespace;
        InlineText text = this.findTrailingText();
        if (text != null && ((whitespace = (iB = text.getParent()).getStyle().getCalculatedStyle().getWhitespace()) == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP)) {
            text.maybeTrimTrailingSpace(c);
        }
    }

    public Box find(CssContext cssCtx, int absX, int absY) {
        Box result = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            result = child.find(cssCtx, absX, absY);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

