/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.StrutMetrics;

public class MarkerData {
    private StrutMetrics structMetrics;
    private TextMarker textMarker;
    private GlyphMarker glyphMarker;
    private ImageMarker imageMarker;
    private LineBox referenceLine;
    private LineBox previousReferenceLine;

    public TextMarker getTextMarker() {
        return this.textMarker;
    }

    public void setTextMarker(TextMarker markerText) {
        this.textMarker = markerText;
    }

    public GlyphMarker getGlyphMarker() {
        return this.glyphMarker;
    }

    public void setGlyphMarker(GlyphMarker glyphMarker) {
        this.glyphMarker = glyphMarker;
    }

    public ImageMarker getImageMarker() {
        return this.imageMarker;
    }

    public void setImageMarker(ImageMarker imageMarker) {
        this.imageMarker = imageMarker;
    }

    public StrutMetrics getStructMetrics() {
        return this.structMetrics;
    }

    public void setStructMetrics(StrutMetrics structMetrics) {
        this.structMetrics = structMetrics;
    }

    public int getLayoutWidth() {
        if (this.textMarker != null) {
            return this.textMarker.getLayoutWidth();
        }
        if (this.glyphMarker != null) {
            return this.glyphMarker.getLayoutWidth();
        }
        if (this.imageMarker != null) {
            return this.imageMarker.getLayoutWidth();
        }
        return 0;
    }

    public LineBox getReferenceLine() {
        return this.referenceLine;
    }

    public void setReferenceLine(LineBox referenceLine) {
        this.previousReferenceLine = this.referenceLine;
        this.referenceLine = referenceLine;
    }

    public void restorePreviousReferenceLine(LineBox current) {
        if (current == this.referenceLine) {
            this.referenceLine = this.previousReferenceLine;
        }
    }

    public static class TextMarker {
        private String text;
        private int layoutWidth;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getLayoutWidth() {
            return this.layoutWidth;
        }

        public void setLayoutWidth(int width) {
            this.layoutWidth = width;
        }
    }

    public static class GlyphMarker {
        private int diameter;
        private int layoutWidth;

        public int getDiameter() {
            return this.diameter;
        }

        public void setDiameter(int diameter) {
            this.diameter = diameter;
        }

        public int getLayoutWidth() {
            return this.layoutWidth;
        }

        public void setLayoutWidth(int layoutWidth) {
            this.layoutWidth = layoutWidth;
        }
    }

    public static class ImageMarker {
        private int layoutWidth;
        private FSImage image;

        public FSImage getImage() {
            return this.image;
        }

        public void setImage(FSImage image) {
            this.image = image;
        }

        public int getLayoutWidth() {
            return this.layoutWidth;
        }

        public void setLayoutWidth(int layoutWidth) {
            this.layoutWidth = layoutWidth;
        }
    }
}

