/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.FSFontMetrics;

public class Style {
    private CalculatedStyle calculatedStyle;
    private float marginTopOverride;
    private boolean marginTopOverrideSet = false;
    private float marginBottomOverride;
    private boolean marginBottomOverrideSet = false;
    private int containingBlockWidth;

    public Style(CalculatedStyle calculatedStyle, int containingBlockWidth) {
        this.calculatedStyle = calculatedStyle;
        this.containingBlockWidth = containingBlockWidth;
    }

    public FSFontMetrics getFSFontMetrics(LayoutContext c) {
        return this.calculatedStyle.getFSFontMetrics(c);
    }

    public int getContainingBlockWidth() {
        return this.containingBlockWidth;
    }

    public boolean isClearLeft() {
        IdentValue clear = this.calculatedStyle.getIdent(CSSName.CLEAR);
        return clear == IdentValue.LEFT || clear == IdentValue.BOTH;
    }

    public boolean isClearRight() {
        IdentValue clear = this.calculatedStyle.getIdent(CSSName.CLEAR);
        return clear == IdentValue.RIGHT || clear == IdentValue.BOTH;
    }

    public boolean isCleared() {
        return !this.calculatedStyle.isIdent(CSSName.CLEAR, IdentValue.NONE);
    }

    public CalculatedStyle getCalculatedStyle() {
        return this.calculatedStyle;
    }

    public IdentValue getBackgroundRepeat() {
        return this.calculatedStyle.getIdent(CSSName.BACKGROUND_REPEAT);
    }

    public IdentValue getBackgroundAttachment() {
        return this.calculatedStyle.getIdent(CSSName.BACKGROUND_ATTACHMENT);
    }

    public boolean isFixedBackground() {
        return this.calculatedStyle.getIdent(CSSName.BACKGROUND_ATTACHMENT) == IdentValue.FIXED;
    }

    public boolean isAbsolute() {
        return this.calculatedStyle.isIdent(CSSName.POSITION, IdentValue.ABSOLUTE);
    }

    public boolean isFixed() {
        return this.calculatedStyle.isIdent(CSSName.POSITION, IdentValue.FIXED);
    }

    public boolean isFloated() {
        IdentValue floatVal = this.calculatedStyle.getIdent(CSSName.FLOAT);
        return floatVal == IdentValue.LEFT || floatVal == IdentValue.RIGHT;
    }

    public boolean isFloatedLeft() {
        return this.calculatedStyle.isIdent(CSSName.FLOAT, IdentValue.LEFT);
    }

    public boolean isFloatedRight() {
        return this.calculatedStyle.isIdent(CSSName.FLOAT, IdentValue.RIGHT);
    }

    public boolean isRelative() {
        return this.calculatedStyle.isIdent(CSSName.POSITION, IdentValue.RELATIVE);
    }

    public boolean isPostionedOrFloated() {
        return this.isAbsolute() || this.isFixed() || this.isFloated() || this.isRelative();
    }

    public float getMarginTopOverride() {
        return this.marginTopOverride;
    }

    public void setMarginTopOverride(float marginTopOverride) {
        if (!this.marginTopOverrideSet) {
            this.marginTopOverride = marginTopOverride;
            this.marginTopOverrideSet = true;
        }
    }

    public float getMarginBottomOverride() {
        return this.marginBottomOverride;
    }

    public void setMarginBottomOverride(float marginBottomOverride) {
        if (!this.marginBottomOverrideSet) {
            this.marginBottomOverride = marginBottomOverride;
            this.marginBottomOverrideSet = true;
        }
    }

    public RectPropertySet getMarginWidth(CssContext cssContext) {
        RectPropertySet rect = this.calculatedStyle.getMarginRect(this.containingBlockWidth, this.containingBlockWidth, cssContext);
        if (this.marginTopOverrideSet || this.marginBottomOverrideSet) {
            rect = rect.copyOf();
            if (this.marginTopOverrideSet) {
                rect.setTop((int)this.marginTopOverride);
            }
            if (this.marginBottomOverrideSet) {
                rect.setBottom((int)this.marginBottomOverride);
            }
        }
        return rect;
    }

    public RectPropertySet getPaddingWidth(CssContext cssCtx) {
        return this.calculatedStyle.getPaddingRect(this.containingBlockWidth, this.containingBlockWidth, cssCtx);
    }

    public boolean isAutoWidth() {
        return this.calculatedStyle.isIdent(CSSName.WIDTH, IdentValue.AUTO);
    }

    public boolean isAutoHeight() {
        return this.calculatedStyle.isIdent(CSSName.HEIGHT, IdentValue.AUTO) || !this.calculatedStyle.hasAbsoluteUnit(CSSName.HEIGHT);
    }

    public boolean isAutoZIndex() {
        return this.calculatedStyle.isIdent(CSSName.Z_INDEX, IdentValue.AUTO);
    }

    public void setCalculatedStyle(CalculatedStyle calculatedStyle) {
        this.calculatedStyle = calculatedStyle;
    }

    public boolean establishesBFC() {
        IdentValue display = this.calculatedStyle.getIdent(CSSName.DISPLAY);
        IdentValue position = this.calculatedStyle.getIdent(CSSName.POSITION);
        return this.isFloated() || position == IdentValue.ABSOLUTE || position == IdentValue.FIXED || display == IdentValue.INLINE_BLOCK || display == IdentValue.TABLE_CELL || !this.calculatedStyle.isIdent(CSSName.OVERFLOW, IdentValue.VISIBLE);
    }

    public boolean requiresLayer() {
        IdentValue position = this.calculatedStyle.getIdent(CSSName.POSITION);
        return position == IdentValue.ABSOLUTE || position == IdentValue.RELATIVE || position == IdentValue.FIXED;
    }

    public boolean isHorizontalBackgroundRepeat() {
        IdentValue value = this.calculatedStyle.getIdent(CSSName.BACKGROUND_REPEAT);
        return value == IdentValue.REPEAT_X || value == IdentValue.REPEAT;
    }

    public boolean isVerticalBackgroundRepeat() {
        IdentValue value = this.calculatedStyle.getIdent(CSSName.BACKGROUND_REPEAT);
        return value == IdentValue.REPEAT_Y || value == IdentValue.REPEAT;
    }

    public boolean isTopAuto() {
        return this.calculatedStyle.isIdent(CSSName.TOP, IdentValue.AUTO);
    }

    public boolean isBottomAuto() {
        return this.calculatedStyle.isIdent(CSSName.BOTTOM, IdentValue.AUTO);
    }

    public int getMarginBorderPadding(CssContext cssCtx, int which) {
        return this.getCalculatedStyle().getMarginBorderPadding(cssCtx, this.containingBlockWidth, which);
    }

    public boolean isListItem() {
        return this.getCalculatedStyle().isIdent(CSSName.DISPLAY, IdentValue.LIST_ITEM);
    }

    public boolean isVisible() {
        return this.getCalculatedStyle().isIdent(CSSName.VISIBILITY, IdentValue.VISIBLE);
    }

    public boolean isForcePageBreakBefore() {
        IdentValue val = this.getCalculatedStyle().getIdent(CSSName.PAGE_BREAK_BEFORE);
        return val == IdentValue.ALWAYS || val == IdentValue.LEFT || val == IdentValue.RIGHT;
    }

    public boolean isForcePageBreakAfter() {
        IdentValue val = this.getCalculatedStyle().getIdent(CSSName.PAGE_BREAK_AFTER);
        return val == IdentValue.ALWAYS || val == IdentValue.LEFT || val == IdentValue.RIGHT;
    }

    public boolean isAvoidPageBreakInside() {
        return this.getCalculatedStyle().isIdent(CSSName.PAGE_BREAK_INSIDE, IdentValue.AVOID);
    }

    public void setContainingBlockWidth(int containingBlockWidth) {
        this.containingBlockWidth = containingBlockWidth;
    }

    public void resetCollapsedMargin() {
        this.marginBottomOverride = 0.0f;
        this.marginBottomOverrideSet = false;
        this.marginTopOverride = 0.0f;
        this.marginTopOverrideSet = false;
    }

    public boolean isAlternateFlow() {
        return this.getCalculatedStyle().isAlternateFlow();
    }
}

