/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class FSScrollPane
extends JScrollPane {
    private JPanel view;
    public static final String PAGE_DOWN = "page-down";
    public static final String PAGE_UP = "page-up";
    public static final String LINE_DOWN = "down";
    public static final String LINE_UP = "up";
    public static final String PAGE_END = "page-end";
    public static final String PAGE_START = "page-start";

    public FSScrollPane(JPanel aview) {
        super(aview);
        this.view = aview;
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
        this.setPreferredSize(new Dimension((int)this.view.getSize().getWidth(), (int)this.view.getSize().getHeight()));
        this.getVerticalScrollBar().setUnitIncrement(15);
        this.setDefaultInputMap();
        this.setDefaultActionMap();
        this.addResizeListener();
    }

    private void setDefaultInputMap() {
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), PAGE_DOWN);
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), PAGE_UP);
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(40, 0), LINE_DOWN);
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(38, 0), LINE_UP);
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(35, 2), PAGE_END);
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(35, 0), PAGE_END);
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(36, 2), PAGE_START);
        this.view.getInputMap(2).put(KeyStroke.getKeyStroke(36, 0), PAGE_START);
    }

    private void setDefaultActionMap() {
        this.view.getActionMap().put(PAGE_DOWN, new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JScrollBar sb = FSScrollPane.this.getVerticalScrollBar();
                sb.getModel().setValue(sb.getModel().getValue() + sb.getBlockIncrement(1));
            }
        });
        this.view.getActionMap().put(PAGE_END, new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JScrollBar sb = FSScrollPane.this.getVerticalScrollBar();
                sb.getModel().setValue(sb.getModel().getMaximum());
            }
        });
        this.view.getActionMap().put(PAGE_UP, new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JScrollBar sb = FSScrollPane.this.getVerticalScrollBar();
                sb.getModel().setValue(sb.getModel().getValue() - sb.getBlockIncrement(-1));
            }
        });
        this.view.getActionMap().put(PAGE_START, new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JScrollBar sb = FSScrollPane.this.getVerticalScrollBar();
                sb.getModel().setValue(0);
            }
        });
        this.view.getActionMap().put(LINE_DOWN, new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JScrollBar sb = FSScrollPane.this.getVerticalScrollBar();
                sb.getModel().setValue(sb.getModel().getValue() + sb.getUnitIncrement(1));
            }
        });
        this.view.getActionMap().put(LINE_UP, new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JScrollBar sb = FSScrollPane.this.getVerticalScrollBar();
                sb.getModel().setValue(sb.getModel().getValue() - sb.getUnitIncrement(-1));
            }
        });
    }

    private void addResizeListener() {
        this.view.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JScrollBar bar = FSScrollPane.this.getVerticalScrollBar();
                int incr = (int)(FSScrollPane.this.getSize().getHeight() - (double)(bar.getUnitIncrement(1) * 3));
                FSScrollPane.this.getVerticalScrollBar().setBlockIncrement(incr);
            }
        });
    }
}

