/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.css.sheet.InlineStyleInfo;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.swing.NoNamespaceHandler;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.XRLog;

public class XhtmlCssOnlyNamespaceHandler
extends NoNamespaceHandler {
    static final String _namespace = "http://www.w3.org/1999/xhtml";

    public String getNamespace() {
        return _namespace;
    }

    public String getClass(Element e) {
        return e.getAttribute("class");
    }

    public String getID(Element e) {
        return e.getAttribute("id");
    }

    public String getElementStyling(Element e) {
        StringBuffer style = new StringBuffer();
        if (e.getNodeName().equals("td") || e.getNodeName().equals("th")) {
            String s = e.getAttribute("colspan");
            if (!s.equals("")) {
                style.append("-fs-table-cell-colspan: ");
                style.append(s);
                style.append(";");
            }
            if (!(s = e.getAttribute("rowspan")).equals("")) {
                style.append("-fs-table-cell-rowspan: ");
                style.append(s);
                style.append(";");
            }
        } else if (e.getNodeName().equals("img")) {
            String s = e.getAttribute("width");
            if (!s.equals("")) {
                style.append("width: ");
                style.append(s);
                style.append(";");
            }
            if (!(s = e.getAttribute("height")).equals("")) {
                style.append("height: ");
                style.append(s);
                style.append(";");
            }
        }
        style.append(e.getAttribute("style"));
        return style.toString();
    }

    public String getLinkUri(Element e) {
        String href = null;
        if (e.getNodeName().equalsIgnoreCase("a") && e.hasAttribute("href")) {
            href = e.getAttribute("href");
        }
        return href;
    }

    public String getAnchorName(Element e) {
        if (e != null && e.getNodeName().equalsIgnoreCase("a") && e.hasAttribute("name")) {
            return e.getAttribute("name");
        }
        return null;
    }

    public String getDocumentTitle(Document doc) {
        String title = "TITLE UNKNOWN";
        try {
            Element html;
            NodeList nl;
            for (int i = 0; i < 1 && (nl = (html = doc.getDocumentElement()).getElementsByTagName("head")).getLength() != 0 && (nl = ((Element)nl.item(0)).getElementsByTagName("title")).getLength() != 0 && (nl = ((Element)nl.item(0)).getChildNodes()).getLength() != 0; ++i) {
                title = nl.item(0).getNodeValue();
            }
        }
        catch (Exception ex) {
            System.err.println("Error retrieving document title. " + ex.getMessage());
            title = "";
        }
        return title;
    }

    public InlineStyleInfo[] getInlineStyle(Document doc) {
        Element html;
        int i;
        ArrayList<InlineStyleInfo> list = new ArrayList<InlineStyleInfo>();
        NodeList nl = null;
        for (i = 0; i < 1 && (nl = (html = doc.getDocumentElement()).getElementsByTagName("head")).getLength() != 0; ++i) {
            nl = ((Element)nl.item(0)).getElementsByTagName("style");
        }
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            StringBuffer style = new StringBuffer();
            Element elem = (Element)nl.item(i);
            String m = elem.getAttribute("media");
            if ("".equals(m)) {
                m = "all";
            }
            StylesheetInfo info = new StylesheetInfo();
            info.setMedia(m);
            info.setType(elem.getAttribute("type"));
            info.setTitle(elem.getAttribute("title"));
            info.setOrigin(2);
            NodeList children = elem.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node txt = children.item(j);
                if (!(txt instanceof CharacterData)) continue;
                style.append(txt.getNodeValue());
            }
            InlineStyleInfo isi = new InlineStyleInfo();
            isi.setInfo(info);
            isi.setStyle(style.toString());
            list.add(isi);
        }
        InlineStyleInfo[] infos = new InlineStyleInfo[list.size()];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            infos[i2] = (InlineStyleInfo)list.get(i2);
        }
        return infos;
    }

    public StylesheetInfo[] getStylesheetLinks(Document doc) {
        Element html;
        int i;
        ArrayList<StylesheetInfo> list = new ArrayList<StylesheetInfo>();
        StylesheetInfo[] refs = super.getStylesheetLinks(doc);
        list.addAll(Arrays.asList(refs));
        NodeList nl = null;
        for (i = 0; i < 1 && (nl = (html = doc.getDocumentElement()).getElementsByTagName("head")).getLength() != 0; ++i) {
            nl = ((Element)nl.item(0)).getElementsByTagName("link");
        }
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            Element link = (Element)nl.item(i);
            if (!link.getAttribute("rel").equals("stylesheet")) continue;
            StylesheetInfo info = new StylesheetInfo();
            info.setOrigin(2);
            String a = link.getAttribute("rel");
            if (a.indexOf("alternate") != -1) continue;
            a = link.getAttribute("type");
            if ("".equals(a)) {
                a = "text/css";
            }
            info.setType(a);
            a = link.getAttribute("href");
            info.setUri(a);
            a = link.getAttribute("media");
            if ("".equals(a)) {
                a = "screen";
            }
            info.setMedia(a);
            a = link.getAttribute("title");
            info.setTitle(a);
            if (!info.getType().equals("text/css")) continue;
            list.add(info);
        }
        refs = new StylesheetInfo[list.size()];
        for (i = 0; i < refs.length; ++i) {
            refs[i] = (StylesheetInfo)list.get(i);
        }
        return refs;
    }

    public InputStream getDefaultStylesheet() {
        InputStream stream = null;
        try {
            String defaultStyleSheet = Configuration.valueFor("xr.css.user-agent-default-css") + "XhtmlNamespaceHandler.css";
            if (this.getClass().getResourceAsStream(defaultStyleSheet) != null) {
                stream = this.getClass().getResource(defaultStyleSheet).openStream();
            } else {
                XRLog.exception("Can't load default CSS from " + defaultStyleSheet + "." + "This file must be on your CLASSPATH. Please check before continuing.");
            }
        }
        catch (IOException ex) {
            XRLog.exception("Bad IO", ex);
        }
        return stream;
    }
}

